﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.HealthShare.Processor;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.HealthShare.MessageHandler
{
    /// <summary>
    /// HealthShare Get Consults handler for VIMT.
    /// </summary>
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.TmpHealthShareGetConsultsRequest)]
    public class GetConsultsHandler : RequestResponseHandler
    {
        private TmpHealthShareGetConsultsRequest _request;
        private string _serializedRequest;

        /// <summary>
        /// Handle the Virtual Meeting Request and send back a response.
        /// </summary>
        /// <param name="message">VirtualMeetingRoomCreateRequestMessage.</param>
        /// <returns>VirtualMeetingRoomCreateResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                if (message == null)
                {
                    const string errorMessage = "ERROR: The message object parameter in GetConsultsHandler.HandleRequestResponse is NULL/INVALID";
                    throw new ArgumentNullException(nameof(message), errorMessage);
                }

                _request = (TmpHealthShareGetConsultsRequest) message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var requestProcessor = new GetConsultsProcessor();
                var response = (TmpHealthShareGetConsultsResponse) requestProcessor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: HealthShare Get Consults: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);

                return response;
            }
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        /// <summary>
        /// Log and create an error response.
        /// </summary>
        /// <param name="exception">Exception.</param>
        /// <returns>VirtualMeetingRoomCreateResponseMessage.</returns>
        private TmpHealthShareGetConsultsResponse LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: HealthShare Get Consults Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new TmpHealthShareGetConsultsResponse
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}