﻿using Microsoft.Xrm.Sdk;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Messages.HealthShare;
using VA.TMP.OptionSets;

namespace VA.TMP.Integration.VIMT.HealthShare.Mappers
{
    internal class UpdateClinicMapper
    {
        private readonly TmpHealthShareUpdateClinicRequestMessage _request;
        private readonly IOrganizationService _organizationService;

        public UpdateClinicMapper(TmpHealthShareUpdateClinicRequestMessage request, IOrganizationService organizationService)
        {
            _request = request;
            _organizationService = organizationService;
        }

        internal mcs_resource Map()
        {
            var clinic = new mcs_resource
            {
                cvt_Institution = _request.Institution.ToString(),
                cvt_VISNText = _request.Visn.ToString(),
                mcs_RelatedSiteId = MappingResolver.SiteResolver(_organizationService, _request.StationNumber),
                mcs_Facility = MappingResolver.FacilityResolver(_organizationService, _request.Institution.ToString()),
                mcs_BusinessUnitId = MappingResolver.VisnResolver(_organizationService, _request.Visn),
                cvt_primarystopcode = _request.PrimaryStopCode.ToString(),
                cvt_secondarystopcode = _request.SecondaryStopCode.ToString(),
                cvt_ien = _request.ClinicIen.ToString(),
                mcs_UserNameInput = _request.ClinicName,
                cvt_TreatingSpecialty = _request.TreatingSpecialty,
                cvt_ServiceText = _request.Service,
                cvt_DefaultProviderNameImport = _request.DefaultProviderName,
                cvt_DefaultProviderEmail = _request.DefaultProviderEmail,
                cvt_defaultproviderduz = _request.DefaultProviderId,
                cvt_defaultprovider = MappingResolver.DefaultProviderResolver(_organizationService, _request.DefaultProviderEmail),
                cvt_StationNumber = _request.StationNumber,
                cvt_OverBookAllowed = _request.OverBookAllowed,
                mcs_Type = new OptionSetValue((int) mcs_resourcetype.VistaClinic),
                mcs_resourceId = MappingResolver.ClinicResolver(_organizationService, _request.ClinicIen.ToString(), _request.StationNumber)
            };

            return clinic;
        }
    }
}