﻿using System;
using System.Linq;

namespace VA.TMP.Integration.Plugins.Messages
{
    public class RetrieveOrSearchPersonResponse
    {
        public string MessageId { get; set; }

        public Acknowledgement Acknowledgement { get; set; }

        public bool ExceptionOccured { get; set; }

        public MessageProcessType FetchMessageProcessType { get; set; }

        public string Message { get; set; }

        public string OrganizationName { get; set; }

        public PatientPerson[] Person { get; set; }

        public QueryAcknowledgement QueryAcknowledgement { get; set; }

        public string RawMviExceptionMessage { get; set; }
    }

    public class Acknowledgement
    {
        public AcknowledgementDetail[] AcknowledgementDetails { get; set; }

        public string TargetMessage { get; set; }

        public string TypeCode { get; set; }
    }

    public class AcknowledgementDetail
    {
        public AcknowledgementDetailCode Code { get; set; }

        public string Text { get; set; }
    }

    public class AcknowledgementDetailCode
    {
        public string Code { get; set; }

        public string CodeSystemName { get; set; }

        public string DisplayName { get; set; }
    }

    public enum MessageProcessType
    {
        Local = 0,
        Remote = 1,
        RemoteQueued = 2,
    }

    public class PatientPerson
    {
        public PatientAddress Address { get; set; }

        public string BirthDate { get; set; }

        public string BranchOfService { get; set; }

        public UnattendedSearchRequest[] CorrespondingIdList { get; set; }

        public string DeceasedDate { get; set; }

        public string EdiPi { get; set; }

        public string GenderCode { get; set; }

        public string Identifier { get; set; }

        public string IdentifierType { get; set; }

        public string IdentifyTheft { get; set; }

        public string IsDeceased { get; set; }

        public Name[] NameList { get; set; }

        public string ParticipantId { get; set; }

        public string PhoneNumber { get; set; }

        public string RecordSource { get; set; }

        public string Ss { get; set; }

        public string StatusCode { get; set; }

        public string Url { get; set; }

        public string FullName
        {
            get
            {
                const string nameFormat = "{0} {1}";

                if (NameList != null && NameList.Any()) return string.Format(nameFormat, NameList[0].GivenName, NameList[0].FamilyName);

                return string.Empty;
            }
        }

        public string FullAddress
        {
            get
            {
                return Address == null ? string.Empty : Address.ToString();
            }
        }
    }

    public class PatientAddress
    {
        public string City { get; set; }

        public string Country { get; set; }

        public string PostalCode { get; set; }

        public string State { get; set; }

        public string StreetAddressLine { get; set; }

        public AddressUse Use { get; set; }

        public override string ToString()
        {
            return string.Format("{0}\n{1}, {2} {3} {4}", StreetAddressLine, City, State, PostalCode, Country).TrimEnd('\n', ',').Trim();
        }
    }

    public enum AddressUse
    {
        Unspecified = 0,
        Bad = 1,
        Confidential = 2,
        Home = 3,
        PrimaryHome = 4,
        OtherHome = 5,
        Temporary = 6,
        Workplace = 7,
        Other = 8,
    }

    public class UnattendedSearchRequest
    {
        public string AssigningAuthority { get; set; }

        public string AssigningFacility { get; set; }

        public string AuthorityOid { get; set; }

        public MessageProcessType FetchMessageProcessType { get; set; }

        public string IdentifierType { get; set; }

        public string OrganizationName { get; set; }

        public string PatientIdentifier { get; set; }

        public string RawValueFromMvi { get; set; }

        public bool UseRawMviValue { get; set; }

        public string UserFirstName { get; set; }

        public Guid UserId { get; set; }

        public string UserLastName { get; set; }

        public override string ToString()
        {
            return string.Format("{0}^{1}^{2}^{3}", PatientIdentifier, IdentifierType, AssigningFacility, AssigningAuthority);
        }
    }

    public class Name
    {
        public string FamilyName { get; set; }

        public string GivenName { get; set; }

        public string MiddleName { get; set; }

        public string NamePrefix { get; set; }

        public string NameSuffix { get; set; }

        public string NameType { get; set; }

        public NameUse Use { get; set; }

        public override string ToString()
        {
            var nameString = string.Empty;

            if (!string.IsNullOrEmpty(FamilyName))
            {
                nameString += FamilyName;
                if (!string.IsNullOrEmpty(NameSuffix)) nameString += " " + NameSuffix;
                nameString += ",";
            }

            if (!string.IsNullOrEmpty(GivenName)) nameString += " " + GivenName;

            if (!string.IsNullOrEmpty(MiddleName)) nameString += " " + MiddleName;

            return nameString.Trim().TrimEnd(',');
        }
    }

    public enum NameUse
    {
        Unspecified = 0,
        Assigned = 1,
        Certificate = 2,
        OfficialRegistry = 3,
        Indigenous = 4,
        Legal = 5,
        Pseudoymn = 6,
        Religous = 7,
        Maiden = 8,
        Alias = 9,
    }

    public class QueryAcknowledgement
    {
        public string QueryResponseCode { get; set; }

        public string ResultCurrentQuantity { get; set; }
    }
}