﻿using System.Collections.Generic;

namespace VA.TMP.Integration.Plugins.Messages
{
    public class HealthShareGetConsultsResponse : TmpVimtResponseMessage
    {
        /// <summary>
        /// Gets or sets ControlId.
        /// </summary>
        public string ControlId { get; set; }

        /// <summary>
        /// Gets or sets Patient DFN.
        /// </summary>
        public string PatientDfn { get; set; }

        /// <summary>
        /// Gets or sets Patient ICN.
        /// </summary>
        public string PatientIcn { get; set; }

        /// <summary>
        /// Gets or sets Query Name.
        /// </summary>
        public string QueryName { get; set; }

        /// <summary>
        /// Gets or sets Institution.
        /// </summary>
        public int Institution { get; set; }

        /// <summary>
        /// Gets or sets Patient Consults.
        /// </summary>
        public List<TmpConsult> PatientConsults { get; set; }

        /// <summary>
        /// Gets or sets Provider Consults.
        /// </summary>
        public List<TmpConsult> ProviderConsults { get; set; }

        /// <summary>
        /// Gets or sets Patient Return to Clinic Orders.
        /// </summary>
        public List<TmpReturnToClinicOrder> PatientReturnToClinicOrders { get; set; }

        /// <summary>
        /// Gets or sets Provider Return to Clinic Orders.
        /// </summary>
        public List<TmpReturnToClinicOrder> ProviderReturnToClinicOrders { get; set; }
    }

    /// <summary>
    /// Tmp HealthShare Pending Consult.
    /// </summary>
    public class TmpConsult
    {
        /// <summary>
        /// Gets or sets ConsultId.
        /// </summary>
        public string ConsultId { get; set; }

        /// <summary>
        /// Gets or sets UniqueRequestId.
        /// </summary>
        public string UniqueRequestId { get; set; }


        /// <summary>
        /// Gets or sets Consult Request Date.
        /// </summary>
        public string ConsultRequestDateTime { get; set; }

        /// <summary>
        /// Gets or sets To Consult Service.
        /// </summary>
        public string ToConsultService { get; set; }

        /// <summary>
        /// Gets or sets Consult Title.
        /// </summary>
        public string ConsultTitle { get; set; }

        /// <summary>
        /// Gets or sets Clinically Indicated Date.
        /// </summary>
        public string ClinicallyIndicatedDate { get; set; }

        /// <summary>
        /// Gets or sets Stop Codes.
        /// </summary>
        public string StopCodes { get; set; }

        /// <summary>
        /// Gets or sets Provider.
        /// </summary>
        public string Provider { get; set; }

        /// <summary>
        /// Gets or sets Receiving Site ConsultId.
        /// </summary>
        public string ReceivingSiteConsultId { get; set; }

        /// <summary>
        /// Gets or sets Consult Status.
        /// </summary>
        public string ConsultStatus { get; set; }
    }

    public class TmpReturnToClinicOrder
    {
        /// <summary>
        /// Gets or sets RTC Id.
        /// </summary>
        public string RtcId { get; set; }

        /// <summary>
        /// Gets or sets RTC Request DateTime.
        /// </summary>
        public string RtcRequestDateTime { get; set; }

        /// <summary>
        /// Gets or sets Clinic IEN.
        /// </summary>
        public string ToClinicIen { get; set; }

        /// <summary>
        /// Gets or sets Clinic Name.
        /// </summary>
        public string ClinicName { get; set; }

        /// <summary>
        /// Gets or sets Clinically Indicated Date.
        /// </summary>
        public string ClinicallyIndicatedDate { get; set; }

        /// <summary>
        /// Gets or sets Stop Codes.
        /// </summary>
        public string StopCodes { get; set; }

        /// <summary>
        /// Gets or sets Provider.
        /// </summary>
        public string Provider { get; set; }

        /// <summary>
        /// Gets or sets Comments.
        /// </summary>
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets Multiple Rtc.
        /// </summary>
        public string MultiRtc { get; set; }
    }
}