﻿using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Workflow;
using System;
using System.Activities;
using System.Collections.Generic;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.Integration.CustomActivities.Messages;
using VRMRest;

namespace VA.TMP.Integration.CustomActivities
{
    public sealed class VIALoginAction : CodeActivity
    {
        [Input("StationCode")]
        public InArgument<string> StationNumber { get; set; }

        [Input("SamlToken")]
        public InArgument<string> SamlToken { get; set; }

        [Input("AccessCode")]
        public InArgument<string> AccessCode { get; set; }

        [Input("VerifyCode")]
        public InArgument<string> VerifyCode { get; set; }

        [Output("UserDuz")]
        public OutArgument<string> UserDuz { get; set; }

        [Output("ErrorMessage")]
        public OutArgument<string> ErrorMessage { get; set; }

        [Output("SuccessfulLogin")]
        public OutArgument<bool> SuccessfulLogin { get; set; }

        public int VimtTimeout { get; set; }

        public string VimtUrl { get; set; }

        public string ErrorTracker { get; set; }

        protected override void Execute(CodeActivityContext executionContext)
        {
            var runner = new ViaLoginActionRunner(executionContext);
            var error = "";
            try
            {
                var inputCollection = new AttributeCollection
                {
                    { "StationNumber", StationNumber.Get(executionContext) },
                    { "SamlToken", SamlToken.Get(executionContext) },
                    { "AccessCode", AccessCode.Get(executionContext) },
                    { "VerifyCode", VerifyCode.Get(executionContext) }
                };
                
                runner.RunCustomAction(inputCollection);
            }
            catch (Exception ex)
            {
                error = ex.Message;
                executionContext.GetExtension<ITracingService>().Trace("Unable to handle Exception in Custom Action: " + error);
            }
            finally
            {
                SuccessfulLogin.Set(executionContext, runner.SuccessfulLogin);
                if (runner.SuccessfulLogin)
                    UserDuz.Set(executionContext, runner.UserDuz);
                else
                {
                    error = string.IsNullOrEmpty(error) ? runner.ErrorMessage : runner.ErrorMessage + " | " + error;
                    ErrorMessage.Set(executionContext, error);
                }
            }
        }

        //public void test(CodeActivityContext context)
        //{
        //    ErrorTracker += "_testmethod";
        //}

        //public void RunIntegration(CodeActivityContext context)
        //{
        //    ErrorTracker += "MethodEntry";
        //    //return;
        //    var inputCollection = new Dictionary<string, string>();
        //    inputCollection.Add("StationNumber", StationNumber.Get(context));
        //    inputCollection.Add("SamlToken", SamlToken.Get(context));
        //    inputCollection.Add("AccessCode", AccessCode.Get(context));
        //    inputCollection.Add("VerifyCode", VerifyCode.Get(context));

        //    ErrorTracker += "5";
        //    var WorkflowExecutionContext = context.GetExtension<IWorkflowContext>();
        //    var OrganizationServiceFactory = context.GetExtension<IOrganizationServiceFactory>();
        //    var OrganizationService = OrganizationServiceFactory.CreateOrganizationService(WorkflowExecutionContext.UserId);
        //    var TracingService = context.GetExtension<ITracingService>();
        //    ErrorTracker += "6";
        //    //return;
        //    TracingService.Trace("Getting Integration Settings");
        //    ErrorTracker += "7";
        //    GetIntegrationSettings(OrganizationService);
        //    //GetPassedInVariables(attributes);
        //    ErrorTracker += "8";
        //    TracingService.Trace("Calling VIMT");
        //    //return;
        //    ErrorTracker += "9";
        //    var response = CallVimt(WorkflowExecutionContext, inputCollection);
        //    ErrorTracker += "10";
        //    TracingService.Trace("Processing Response");
        //    //return;
        //    ErrorTracker += "11";
        //    ProcessResponse(response, context);
        //    ErrorTracker += "12";
        //    TracingService.Trace("Completed Custom Workflow Activity logic");
        //    return;
        //}

        //private void GetPassedInVariables(AttributeCollection inputs)
        //{
        //    StationNumber = inputs["StationNumber"].ToString();
        //    SamlToken = inputs["SamlToken"].ToString();
        //    AccessCode = inputs["AccessCode"]?.ToString() ?? "";
        //    VerifyCode = inputs["VerifyCode"]?.ToString() ?? "";
        //}

        //private void GetIntegrationSettings(IOrganizationService OrganizationService)
        //{
        //    ErrorTracker += "a";
        //    using (var srv = new Xrm(OrganizationService))
        //    {
        //        var vimtTimeoutObj = srv.mcs_integrationsettingSet.FirstOrDefault(x => x.mcs_name == "VimtTimeout_ViaLoginRunner");
        //        if (vimtTimeoutObj != null)
        //            VimtTimeout = Convert.ToInt32(vimtTimeoutObj.mcs_value);
        //        ErrorTracker += "b";

        //        vimtTimeoutObj = srv.mcs_integrationsettingSet.FirstOrDefault(x => x.mcs_name == "VimtTimeout");
        //        if (vimtTimeoutObj != null)
        //            VimtTimeout = Convert.ToInt32(vimtTimeoutObj.mcs_value);
        //        else
        //            VimtTimeout = 60;

        //        ErrorTracker += "c";
        //        var vimtUrlObj = srv.mcs_integrationsettingSet.FirstOrDefault(x => x.mcs_name == "VIMT URL");
        //        if (vimtUrlObj == null) throw new InvalidPluginExecutionException("No VIMT URL Integration Setting was found");
        //        VimtUrl = vimtUrlObj.mcs_value;
        //        ErrorTracker += "d";
        //    }
        //}

        //private ViaLoginResponseMessage CallVimt(IWorkflowContext WorkflowExecutionContext, Dictionary<string, string> inputs)
        //{
        //    ErrorTracker += "a";

        //    //return new ViaLoginResponseMessage
        //    //{
        //    //    ExceptionOccured = true,
        //    //    ExceptionMessage = "FAKE FAILURE with VIMT"
        //    //};
        //    //ErrorTracker += "b";

        //    var stationNumber = inputs["StationNumber"].ToString();
        //    var samlToken = inputs["SamlToken"].ToString();
        //    var accessCode = inputs["AccessCode"]?.ToString() ?? "";
        //    var verifyCode = inputs["VerifyCode"]?.ToString() ?? "";
        //    ErrorTracker += "c";

        //    var request = new ViaLoginRequestMessage
        //    {
        //        SamlToken = samlToken,
        //        StationNumber = stationNumber,
        //        AccessCode = accessCode,
        //        VerifyCode = verifyCode,
        //        UserId = WorkflowExecutionContext.UserId,
        //        OrganizationName = WorkflowExecutionContext.OrganizationName
        //    };
        //    ErrorTracker += "d";

        //    try
        //    {
        //        //Logger.WriteDebugMessage("Sending Login request to VIMT");
        //        var response = Utility.SendReceive<ViaLoginResponseMessage>(new Uri(VimtUrl), CustomActionMessageRegistry.ViaLoginRequestMessage, request, null, VimtTimeout);
        //        //Logger.WriteDebugMessage("Finished sending Login request to VIMT");
        //        return response;
        //    }
        //    catch (Exception ex)
        //    {
        //        //Logger.WriteToFile("Failed to Call VIMT");
        //        return new ViaLoginResponseMessage
        //        {
        //            ExceptionOccured = true,
        //            ExceptionMessage = ex.Message
        //        };
        //    }
        //    ErrorTracker += "e";
        //}

        //private void ProcessResponse(ViaLoginResponseMessage response, CodeActivityContext executionContext)
        //{
        //    ErrorTracker += "a";

        //    if (response == null) throw new Exception("No Response was returned from VIMT");
        //    //Logger.WriteDebugMessage(string.Format("VIMT Request: {0}\n|EC Request: {1}\n|VIMT Response {2}", response.VimtRequest, response.SerializedInstance, response.VimtResponse));
        //    //SuccessfulLogin = !response.ExceptionOccured;
        //    //ErrorMessage = response.ExceptionMessage;
        //    //UserDuz = response.UserDuz;
        //    //Logger.WriteDebugMessage("User Duz: " + UserDuz + "|Error Message: " + ErrorMessage + "|Success: " + SuccessfulLogin);

        //    SuccessfulLogin.Set(executionContext, !response.ExceptionOccured);
        //    ErrorTracker += "b";

        //    if (!response.ExceptionOccured)
        //        UserDuz.Set(executionContext, response.UserDuz);
        //    else
        //    {
        //        var error = string.IsNullOrEmpty(response.ExceptionMessage) ? "" : response.ExceptionMessage;
        //        ErrorMessage.Set(executionContext, error);
        //    }
        //    ErrorTracker += "c";

        //}

    }
}