using System;
using System.Collections.Generic;
using System.Web.Http.Dependencies;
using Microsoft.Practices.Unity;

namespace VA.TMP.Integration.VIMT.Shared
{
    /// <summary>
    /// Represents a Unity dependency injection container.
    /// </summary>
    public class UnityResolver : IDependencyResolver
    {
        protected IUnityContainer Container;

        /// <summary>
        /// Default constructor.
        /// </summary>
        /// <param name="container">The container.</param>
        public UnityResolver(IUnityContainer container)
        {
            if (container == null)
            {
                throw new ArgumentNullException("container");
            }
            
            Container = container;
        }

        /// <summary>
        /// Gets a Service from the container.
        /// </summary>
        /// <param name="serviceType">Type of Service.</param>
        /// <returns>The Service.</returns>
        public object GetService(Type serviceType)
        {
            try
            {
                return Container.Resolve(serviceType);
            }
            catch (ResolutionFailedException)
            {
                return null;
            }
        }

        /// <summary>
        /// Gets a list of Services from the container.
        /// </summary>
        /// <param name="serviceType">Type of Service.</param>
        /// <returns>List of Services.</returns>
        public IEnumerable<object> GetServices(Type serviceType)
        {
            try
            {
                return Container.ResolveAll(serviceType);
            }
            catch (ResolutionFailedException)
            {
                return new List<object>();
            }
        }

        /// <summary>
        /// Starts a resolution scope.
        /// </summary>
        /// <returns>The dependency scope.</returns>
        public IDependencyScope BeginScope()
        {
            var child = Container.CreateChildContainer();
            return new UnityResolver(child);
        }

        /// <summary>
        /// Disposes the container.
        /// </summary>
        public void Dispose()
        {
            Container.Dispose();
        }
    }
}