﻿using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages
{
    [DataContract]
    public abstract class TmpVimtResponseMessage : MessageBase
    {
        /// <summary>
        /// Indicates if VIMT threw an exception anywhere along the way that wasn't caught
        /// </summary>
        [DataMember]
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Message corresponding to any uncaught VIMT Exception
        /// </summary>
        [DataMember]
        public string ExceptionMessage { get; set; }

        /// <summary>
        /// Serialized Ec Request generated in VIMT
        /// </summary>
        [DataMember]
        public string SerializedInstance { get; set; }

        /// <summary>
        /// Serialized Vimt Request Message
        /// </summary>
        [DataMember]
        public string VimtRequest { get; set; }

        /// <summary>
        /// Serialized Vimt Response Message
        /// </summary>
        [DataMember]
        public string VimtResponse { get; set; }

        /// <summary>
        /// # of milliseconds the code spent in the Enterprise Component(s)
        /// </summary>
        [DataMember]
        public int EcProcessingMs { get; set; }

        /// <summary>
        /// # of milliseconds the code spent in Vimt
        /// </summary>
        [DataMember]
        public int VimtProcessingMs { get; set; }

        /// <summary>
        /// # of milliseconds the code spent from calling VIMT until returning the response
        /// </summary>
        [DataMember]
        public int VimtLagMs { get; set; }
    }
}