﻿using BaseVimtConsoleTester.Messages;
using System;
using System.Collections.Generic;
using System.IO;
using System.Net;
using System.Net.Http;
using System.Net.Http.Formatting;
using System.Net.Http.Headers;
using System.Text;
using System.Xml.Serialization;
using VRMRest;

namespace BaseVimtConsoleTester
{
    public class Program
    {
        private static Guid _apptId = Guid.NewGuid();

        private static void Main()
        {
            try
            {
                var url = System.Configuration.ConfigurationManager.AppSettings["BaseUrl"];
                var vvsUrl = System.Configuration.ConfigurationManager.AppSettings["VvsBaseUrl"];

                var createPayload = System.Configuration.ConfigurationManager.AppSettings["CreatePayload"];
                var callCreate = Convert.ToBoolean(System.Configuration.ConfigurationManager.AppSettings["CallCreate"]);

                var updatePayload = System.Configuration.ConfigurationManager.AppSettings["UpdatePayload"];
                var callUpdate = Convert.ToBoolean(System.Configuration.ConfigurationManager.AppSettings["CallUpdate"]);

                var cancelPayload = System.Configuration.ConfigurationManager.AppSettings["CancelPayload"];
                var callCancel = Convert.ToBoolean(System.Configuration.ConfigurationManager.AppSettings["CallCancel"]);

                var token = GetJwt(url);
                
                if (callCreate)
                {
                    var apptXml = File.ReadAllText(createPayload);
                    var appt = DeserializeInstance<Appointment>(apptXml);
                    appt.Id = _apptId.ToString();
                    VvsCreate(appt, token, vvsUrl);
                }

                if (callUpdate)
                {
                    var apptXml = File.ReadAllText(updatePayload);
                    var appt = DeserializeInstance<Appointment>(apptXml);
                    appt.Id = _apptId.ToString();
                    VvsUpdate(appt, token, vvsUrl);
                }

                if (callCancel)
                {
                    var apptXml = File.ReadAllText(cancelPayload);
                    var appt = DeserializeInstance<CancelAppointmentRequest>(apptXml);
                    appt.Id = _apptId.ToString();
                    VvsCancel(appt, token, vvsUrl);
                }
            }
            catch (Exception ex)
            {
                Console.WriteLine(ex);
            }
            finally
            {
                Console.WriteLine("Press [Enter] key to end.");
                Console.ReadLine();
            }
        }

        private static string GetJwt(string url)
        {
            var token = File.ReadAllText("token4.xml");
            
            var request = new VimtJwtEncryptTokenRequest { SamlToken = token };
            var response = Utility.SendReceive<VimtJwtEncryptTokenResponse>(new Uri(url), MessageRegistry.VimtJwtEncryptTokenRequest, request, null, out var lag);

            Console.WriteLine(SerializeInstance(response));
            Console.WriteLine(Environment.NewLine);

            return response.EncryptedJwtToken;
        }

        private static void VvsCreate(Appointment appt, string token, string vvsUrl)
        {
            ServicePointManager.ServerCertificateValidationCallback += (sender, certificate, chain, sslPolicyErrors) => true;
            ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;

            using (var client = new HttpClient())
            {
                client.BaseAddress = new Uri(vvsUrl);
                client.DefaultRequestHeaders.Accept.Clear();
                client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/xml"));

                client.DefaultRequestHeaders.Add("X-VAMF-JWT", token);
                var response = client.PostAsync("video-visit-resources/v2/appointment", appt, new XmlMediaTypeFormatter { UseXmlSerializer = true }).GetAwaiter().GetResult();

                if (response.IsSuccessStatusCode)
                {
                    var apptResponse = response.Content.ReadAsAsync<AppointmentResponse>(new List<MediaTypeFormatter> { new XmlMediaTypeFormatter { UseXmlSerializer = true } }).GetAwaiter().GetResult();
                    Console.WriteLine("Appointment Id: {0}", apptResponse.Id);
                    foreach (var result in apptResponse.WriteResults.WriteResult)
                    {
                        Console.WriteLine("Reason: {0} - VistA Result {1}", result.Reason, result.VistaStatus.ToString());
                    }
                }
                else if (response.StatusCode == HttpStatusCode.BadRequest)
                {
                    var errors = response.Content.ReadAsAsync<ValidationErrors>(new List<MediaTypeFormatter>{new XmlMediaTypeFormatter { UseXmlSerializer = true } }).GetAwaiter().GetResult();
                    var errorString = "Validation Error(s):";
                    errors.Errors.ForEach(e => errorString += string.Format("\nField Name={0} | Error={1}", e.FieldName, e.ErrorMessage));
                    foreach (var error in errors.Errors)
                    {
                        Console.WriteLine("Field Name: {0} Error Message {1}", error.FieldName, error.ErrorMessage);
                    }
                }
                else
                {
                    var unknownErrorString = response.Content.ReadAsStringAsync().GetAwaiter().GetResult();
                    Console.WriteLine("Unknown Error: {0}", unknownErrorString);
                }
            }
        }

        private static void VvsUpdate(Appointment payload, string token, string vvsUrl)
        {
            ServicePointManager.ServerCertificateValidationCallback += (sender, certificate, chain, sslPolicyErrors) => true;
            ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;

            using (var client = new HttpClient())
            {
                client.BaseAddress = new Uri(vvsUrl);
                client.DefaultRequestHeaders.Accept.Clear();
                client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/xml"));

                var updateUri = string.Format("video-visit-resources/v2/appointment/{0}", payload.Id);
                client.DefaultRequestHeaders.Add("X-VAMF-JWT", token);
                var response = client.PutAsync(updateUri, payload, new XmlMediaTypeFormatter { UseXmlSerializer = true }).GetAwaiter().GetResult();

                if (response.IsSuccessStatusCode)
                {
                    var apptResponse = response.Content.ReadAsAsync<AppointmentResponse>(new List<MediaTypeFormatter> { new XmlMediaTypeFormatter { UseXmlSerializer = true } }).GetAwaiter().GetResult();
                    Console.WriteLine("Appointment Id: {0}", apptResponse.Id);
                    foreach (var result in apptResponse.WriteResults.WriteResult)
                    {
                        Console.WriteLine("Reason: {0} - VistA Result {1}", result.Reason, result.VistaStatus.ToString());
                    }
                }
                else if (response.StatusCode == HttpStatusCode.BadRequest)
                {
                    var errors = response.Content.ReadAsAsync<ValidationErrors>(new List<MediaTypeFormatter> { new XmlMediaTypeFormatter { UseXmlSerializer = true } }).GetAwaiter().GetResult();
                    var errorString = "Validation Error(s):";
                    errors.Errors.ForEach(e => errorString += string.Format("\nField Name={0} | Error={1}", e.FieldName, e.ErrorMessage));
                    foreach (var error in errors.Errors)
                    {
                        Console.WriteLine("Field Name: {0} Error Message {1}", error.FieldName, error.ErrorMessage);
                    }
                }
                else
                {
                    var unknownErrorString = response.Content.ReadAsStringAsync().GetAwaiter().GetResult();
                    Console.WriteLine("Unknown Error: {0}", unknownErrorString);
                }
            }
        }

        public static void VvsCancel(CancelAppointmentRequest payload, string token, string vvsUrl)
        {
            ServicePointManager.ServerCertificateValidationCallback += (sender, certificate, chain, sslPolicyErrors) => true;
            ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;

            using (var client = new HttpClient())
            {
                client.BaseAddress = new Uri(vvsUrl);
                client.DefaultRequestHeaders.Accept.Clear();
                client.DefaultRequestHeaders.Accept.Add(new MediaTypeWithQualityHeaderValue("application/xml"));
                client.DefaultRequestHeaders.Add("X-VAMF-JWT", token);

                var cancelUri = string.Format("video-visit-resources/v2/appointment/{0}/cancellation", payload.Id);
                var response = client.PutAsync(cancelUri, payload, new XmlMediaTypeFormatter { UseXmlSerializer = true }).Result;

                if (response.IsSuccessStatusCode)
                {
                    var apptResponse = response.Content.ReadAsAsync<AppointmentResponse>(new List<MediaTypeFormatter> { new XmlMediaTypeFormatter { UseXmlSerializer = true } }).GetAwaiter().GetResult();
                    Console.WriteLine("Appointment Id: {0}", apptResponse.Id);
                    foreach (var result in apptResponse.WriteResults.WriteResult)
                    {
                        Console.WriteLine("Reason: {0} - VistA Result {1}", result.Reason, result.VistaStatus.ToString());
                    }
                }
                else if (response.StatusCode == HttpStatusCode.BadRequest)
                {
                    var errors = response.Content.ReadAsAsync<ValidationErrors>(new List<MediaTypeFormatter> { new XmlMediaTypeFormatter { UseXmlSerializer = true } }).GetAwaiter().GetResult();
                    var errorString = "Validation Error(s):";
                    errors.Errors.ForEach(e => errorString += string.Format("\nField Name={0} | Error={1}", e.FieldName, e.ErrorMessage));
                    foreach (var error in errors.Errors)
                    {
                        Console.WriteLine("Field Name: {0} Error Message {1}", error.FieldName, error.ErrorMessage);
                    }
                }
                else
                {
                    var unknownErrorString = response.Content.ReadAsStringAsync().GetAwaiter().GetResult();
                    Console.WriteLine("Unknown Error: {0}", unknownErrorString);
                }
            }
        }

        private static string SerializeInstance<T>(T classInstance)
        {
            using (var stream = new MemoryStream())
            {
                var serializer = new XmlSerializer(typeof(T));

                serializer.Serialize(stream, classInstance);
                return Encoding.ASCII.GetString(stream.ToArray());
            }
        }

        private static T DeserializeInstance<T>(string message)
        {
            var serializer = new XmlSerializer(typeof(T));

            using (TextReader reader = new StringReader(message))
            {
                return (T)serializer.Deserialize(reader);
            }
        }
    }
}