﻿using System;

namespace BaseVimtConsoleTester.Messages
{
    public class VistaAppointment
    {
        public Guid AppointmentId { get; set; }

        public Guid ServiceAppointmentId { get; set; }

        public PersonName PatientName { get; set; }

        public string PatientIcn { get; set; }

        public string FacilityName { get; set; }

        public string FacilityStationCode { get; set; }

        public string ClinicName { get; set; }

        public string ClinicIen { get; set; }

        public string LocalStartTime { get; set; }

        public string Duration { get; set; }

        public VistaStatus Status { get; set; }

        public string ErrorMessage { get; set; }

        public VistaCancelCode CancelCode { get; set; }

        public VistaCancelReason CancelReason { get; set; }

        public string CancelRemarks { get; set; }

        public static explicit operator VistaAppointment (WriteResult writeResult)
        {
            return new VistaAppointment
            {
                ClinicIen = writeResult.ClinicIen,
                ClinicName = writeResult.ClinicName,
                LocalStartTime = writeResult.DateTime,
                FacilityStationCode = writeResult.FacilityCode,
                FacilityName = writeResult.FacilityName,
                PatientName = writeResult.Name,
                PatientIcn = writeResult.PersonId,
                ErrorMessage = writeResult.Reason,
                Status = writeResult.VistaStatus
            };
        }
    }

    //public enum VistaAppointmentStatus
    //{
    //    BOOKED,
    //    FAILED_TO_BOOK,
    //    FAILED_TO_CANCEL,
    //    CANCELED
    //}

    public enum VistaCancelCode
    {
        UNKNOWN,
        NO_SHOW,
        CANCELLED_BY_CLINIC,
        CANCELLED_BY_CLINIC_AND_AUTO_RE_BOOK,
        NO_SHOW_AND_AUTO_RE_BOOK,
        INPATIENT_APPOINTMENT,
        CANCELLED_BY_PATIENT,
        CANCELLED_BY_PATIENT_AND_AUTO_RE_BOOK,
        NO_ACTION_TAKEN
    }

    public enum VistaCancelReason
    {
        UNKOWN = 0,
        WEATHER = 1,
        INPATIENT_STATUS = 2,
        PATIENT_DEATH = 3,
        TRAVEL_DIFFICULTY = 4,
        UNABLE_TO_KEEP_APPOINTMENT = 5,
        DEATH_IN_FAMILY = 6,
        CLINIC_STAFFING = 7,
        SCHEDULING_CONFLICT_ERROR = 8,
        PATIENT_NOT_ELIGIBLE = 9,
        APPOINTMENT_NO_LONGER_REQUIRED = 10,
        OTHER = 11,
        TRANSFER_OPT_CARE_TO_OTHER_VA = 12,
        CLINIC_CANCELLED = 13,
    }

}
