﻿namespace BaseVimtConsoleTester.Messages
{
    public abstract class TmpVimtResponseMessage
    {
        /// <summary>
        /// Required field for all Vimt Messages to track messages uniquely
        /// </summary>
        public string MessageId { get; set; }

        /// <summary>
        /// Indicates if VIMT threw an exception anywhere along the way that wasn't caught
        /// </summary>
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Message corresponding to any uncaught VIMT Exception
        /// </summary>
        public string ExceptionMessage { get; set; }

        /// <summary>
        /// Serialized Ec Request generated in VIMT
        /// </summary>
        public string SerializedInstance { get; set; }

        /// <summary>
        /// Serialized Vimt Request Message
        /// </summary>
        public string VimtRequest { get; set; }

        /// <summary>
        /// Serialized Vimt Response Message
        /// </summary>
        public string VimtResponse { get; set; }

        /// <summary>
        /// # of milliseconds the code spent in the Enterprise Component(s)
        /// </summary>
        public int EcProcessingMs { get; set; }

        /// <summary>
        /// # of milliseconds the code spent in Vimt
        /// </summary>
        public int VimtProcessingMs { get; set; }

        public int VimtLagMs { get; set; }
    }
}
