﻿namespace BaseVimtConsoleTester.Messages
{
    public class WriteResults
    {
        public WriteResult[] WriteResult { get; set; }
    }

    public class WriteResult
    {
        public string PersonId { get; set; }

        public PersonName Name { get; set; }

        public string FacilityCode { get; set; }

        public string FacilityName { get; set; }

        public string ClinicIen { get; set; }

        public string ClinicName { get; set; }

        public string DateTime { get; set; }

        public VistaStatus VistaStatus { get; set; }

        public string Reason { get; set; }

        public string VistaCancelReason { get; set; }

        public string VistaCancelCode { get; set; }

        public static explicit operator WriteResult(VistaAppointment appt)
        {
            return new WriteResult
            {
                ClinicIen = appt.ClinicIen,
                ClinicName = appt.ClinicName,
                DateTime = appt.LocalStartTime,
                FacilityCode = appt.FacilityStationCode,
                FacilityName = appt.FacilityName,
                PersonId = appt.PatientIcn,
                Reason = appt.ErrorMessage,
                VistaStatus = appt.Status,
                Name = appt.PatientName,
                VistaCancelCode = appt.CancelCode.ToString(),
                VistaCancelReason = appt.CancelReason.ToString()
            };
        }
    }

    public enum VistaStatus
    {
        BOOKED,
        FAILED_TO_BOOK,
        RECEIVED,
        FAILED_TO_RECEIVE,
        CANCELLED,
        FAILED_TO_CANCEL,
    }

    public class PersonName
    {
        public string FirstName { get; set; }

        public string LastName { get; set; }

        public string MiddleInitial { get; set; }

        public override string ToString() { return string.Format("{0}, {1} {2}", LastName, FirstName, MiddleInitial).Trim().TrimEnd(','); }
    }

}
