﻿using System;
using Vimt.HealthShare.Messages.Messages;
using Vimt.HealthShare.Services.Rest;
using VRM.Integration.Servicebus.Core;

namespace Vimt.HealthShare.Processors
{
    /// <summary>
    ///  HealthShare Make Cancel Outbound EC Processor.
    /// </summary>
    public class MakeCancelOutboundProcessor
    {
        /// <summary>
        /// Process the request.
        /// </summary>
        /// <param name="request">VimtHealthShareMakeCancelOutboundRequestMessage.</param>
        /// <returns>VimtHealthShareMakeCancelOutboundRequestMessage.</returns>
        public IMessageBase Execute(VimtHealthShareMakeCancelOutboundRequestMessage request)
        {
            try
            {
                if (request == null) throw new Exception("VimtHealthShareMakeCancelOutboundRequestMessage message is null");

                Logger.Instance.Info("Processing EC Make Cancel Outbound request");

                return ServiceFactory.MakeCancelOutbound(request);
            }
            catch (Exception ex)
            {
                Logger.Instance.Error("There was an error with HealthShare Make Cancel Outbound: Error", ex);
                return new VimtHealthShareGetConsultsResponse { ExceptionOccured = true, ExceptionMessage = ex.Message };
            }
        }
    }
}