﻿using System;
using System.Collections.Generic;
using Vimt.HealthShare.Messages.Messages;
using Vimt.HealthShare.Services.Rest;
using VRM.Integration.Servicebus.Core;

namespace Vimt.HealthShare.Processors
{
    /// <summary>
    ///  HealthShare Get Consults EC Processor.
    /// </summary>
    public class GetConsultsProcessor
    {
        /// <summary>
        /// Process the request.
        /// </summary>
        /// <param name="request">VimtHealthShareGetConsultsRequest.</param>
        /// <returns>VimtHealthShareGetConsultsResponse.</returns>
        public IMessageBase Execute(VimtHealthShareGetConsultsRequest request)
        {
            try
            {
                if (request == null) throw new Exception("VimtHealthShareGetConsultsRequest message is null");

                Logger.Instance.Info("Processing EC Get Consults request");

                return ServiceFactory.GetConsults(request);
            }
            catch (Exception ex)
            {
                Logger.Instance.Error("There was an error with HealthShare Get Consults: Error", ex);
                return new VimtHealthShareGetConsultsResponse { ExceptionOccured = true, ExceptionMessage = ex.Message };
            }
        }
    }
}