﻿using System;
using System.ComponentModel.Composition;
using Vimt.HealthShare.Messages;
using Vimt.HealthShare.Messages.Messages;
using Vimt.HealthShare.Processors;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;

namespace Vimt.HealthShare.MessageHandler
{
    /// <summary>
    /// HealthShare Make Cancel Outbound EC Message Handler.
    /// </summary>
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VimtHealthShareMakeCancelOutboundRequestMessage)]
    public class MakeCancelOutboundMessageHandler : RequestResponseHandler
    {
        /// <summary>
        /// Handle the request.
        /// </summary>
        /// <param name="message">VimtHealthShareMakeCancelOutboundRequestMessage.</param>
        /// <returns>VimtHealthShareMakeCancelOutboundResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                LogMessageReceipt(message);
                return new MakeCancelOutboundProcessor().Execute((VimtHealthShareMakeCancelOutboundRequestMessage)message);
            }
            catch (Exception ex)
            {
                LogHelper.LogError(string.Empty, Guid.Empty, "MakeCancelOutboundMessageHandler.HandleRequestResponse", ex);
                throw new Exception($"MakeCancelOutboundMessageHandler Error: {ex.Message}", ex);
            }
        }
    }
}