﻿using System;
using System.ComponentModel.Composition;
using Vimt.HealthShare.Messages;
using Vimt.HealthShare.Messages.Messages;
using Vimt.HealthShare.Processors;
using VRM.Integration.Servicebus.Core;
using VRM.Integration.Servicebus.Logging.CRM.Util;

namespace Vimt.HealthShare.MessageHandler
{
    /// <summary>
    /// HealthShare Get Consults EC Message Handler.
    /// </summary>
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VimtHealthShareGetConsultsRequest)]
    public class GetConsultsMessageHandler : RequestResponseHandler
    {
        /// <summary>
        /// Handle the request.
        /// </summary>
        /// <param name="message">VimtHealthShareGetConsultsRequest.</param>
        /// <returns>VimtHealthShareGetConsultsResponse.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                LogMessageReceipt(message);
                return new GetConsultsProcessor().Execute((VimtHealthShareGetConsultsRequest)message);
            }
            catch (Exception ex)
            {
                LogHelper.LogError(string.Empty, Guid.Empty, "GetConsultsMessageHandler.HandleRequestResponse", ex);
                throw new Exception($"GetConsultsMessageHandler Error: {ex.Message}", ex);
            }
        }
    }
}