﻿using System;
using VRM.Integration.Servicebus.Core;

namespace Vimt.HealthShare.Configuration
{
    public class HealthShareConfiguration : ObjectConfigHandler
    {
        private readonly string _orgName;

        public HealthShareConfiguration(string orgName)
        {
            _orgName = orgName;
        }
        public HealthShareConfiguration()
        {
        }

        public HealthShareConfiguration Current
        {
            get
            {
                var customConfigurationFileReader = new CustomConfigurationFileReader();

                var section = customConfigurationFileReader.GetCustomConfig<HealthShareConfiguration>(
                    ConfigurationLocation.ConfigDefiningAssemblyPath,
                    ConfigurationLocation.GetConfigFilePath(_orgName),
                    "HealthShareConfiguration");
                if (section == null)
                    throw new Exception("The IMS Custom Settings configuration section has not been specified");
                return section;
            }
        }

        public bool IMS { get; set; }
    }
}