﻿using Newtonsoft.Json;
using System;
using System.Diagnostics;
using System.Net;
using System.Net.Http;
using System.Net.Http.Formatting;
using Vimt.HealthShare.Messages.Messages;
using Vimt.HealthShare.Services.Configuration;
using VRM.Integration.Servicebus.Core;

namespace Vimt.HealthShare.Services.Rest
{
    public static class ServiceFactory
    {
        public static VimtHealthShareGetConsultsResponse GetConsults(VimtHealthShareGetConsultsRequest request)
        {
            try
            {
                ServicePointManager.ServerCertificateValidationCallback += (sender, certificate, chain, sslPolicyErrors) => true;
                ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;
                
                using (var client = new HttpClient())
                {
                   var queryString = string.Format(HealthShareSecurityConfiguration.Current.GetConsultsUri, request.UniqueId, request.PatientDfn, request.PatientIcn, request.StationNumber);

                    Logger.Instance.Info($"Get Consults URL for {request.Side} station: {queryString}");

                    client.BaseAddress = new Uri(HealthShareSecurityConfiguration.Current.BaseUri);

                    var stopWatch = Stopwatch.StartNew();

                    var response = client.GetAsync(queryString).GetAwaiter().GetResult();

                    stopWatch.Stop();
                    Logger.Instance.Info($"The call to HealthShare GetConsults took {stopWatch.ElapsedMilliseconds} ms");

                    var result = response.Content.ReadAsStringAsync().GetAwaiter().GetResult();

                    if (string.IsNullOrEmpty(result)) throw new Exception("Results from GetConsults call are null or empty");

                    Logger.Instance.Info($"Get Consults for Patient HealthShare JSON Response: {result}");

                    var consults = JsonConvert.DeserializeObject<VimtHealthShareGetConsultsResponse>(result);

                    Logger.Instance.Info($"Get Consults: ControlId: {consults.ControlId}, Institution: {consults.Institution}");

                    return consults;
                }
            }
            catch (Exception ex)
            {
                Logger.Instance.Error($"Unexpected error occured. Failed to GET consults from HealthShare EC. Reason : {ex.Message}", ex);
                return new VimtHealthShareGetConsultsResponse {ExceptionOccured = true, ExceptionMessage = ex.Message};
            }
        }

        public static VimtHealthShareMakeCancelOutboundResponseMessage MakeCancelOutbound(VimtHealthShareMakeCancelOutboundRequestMessage request)
        {
            try
            {
                ServicePointManager.ServerCertificateValidationCallback += (sender, certificate, chain, sslPolicyErrors) => true;
                ServicePointManager.SecurityProtocol = SecurityProtocolType.Tls12;

                using (var client = new HttpClient())
                {
                    client.BaseAddress = new Uri(HealthShareSecurityConfiguration.Current.BaseUri);

                    var stopWatch = Stopwatch.StartNew();

                    var response = client.PostAsync(HealthShareSecurityConfiguration.Current.MakeCancelOutboundUri, request, new JsonMediaTypeFormatter {UseDataContractJsonSerializer = true}).GetAwaiter().GetResult();

                    stopWatch.Stop();
                    Logger.Instance.Info($"The call to HealthShare Make Cancel Outbound took {stopWatch.ElapsedMilliseconds} ms");

                    if (response?.Content != null)
                    {
                        var result = response.Content.ReadAsStringAsync().GetAwaiter().GetResult();
                        Logger.Instance.Info($"Response Content: {result}");
                    }

                    return response != null && !response.IsSuccessStatusCode
                        ? new VimtHealthShareMakeCancelOutboundResponseMessage { ExceptionOccured = true, ExceptionMessage = $"POST Make Cancel to HealthShare failed with status {response.StatusCode}" } 
                        : new VimtHealthShareMakeCancelOutboundResponseMessage { ExceptionOccured = false, ExceptionMessage = string.Empty };
                }
            }
            catch (Exception ex)
            {
                Logger.Instance.Error($"Unexpected error occured. Failed to Make Cancel from HealthShare EC. Reason : {ex.Message}", ex);
                return new VimtHealthShareMakeCancelOutboundResponseMessage { ExceptionOccured = true, ExceptionMessage = ex.Message };
            }
        }
    }
}