﻿using System;
using VRM.Integration.Servicebus.Core;

namespace Vimt.HealthShare.Services.Configuration
{
    /// <summary>
    /// HealthShare Security Configuration class.
    /// </summary>
    public class HealthShareSecurityConfiguration : ObjectConfigHandler
    {
        /// <summary>
        /// Default Static Constructor.
        /// </summary>
        public static HealthShareSecurityConfiguration Current
        {
            get
            {
                var customConfigurationFileReader = new CustomConfigurationFileReader();

                var section = customConfigurationFileReader.GetCustomConfig<HealthShareSecurityConfiguration>(ConfigurationLocation.ConfigDefiningAssemblyPath,
                     ConfigurationLocation.GetConfigFilePath("EC"),
                    "HealthShareSecurityConfiguration");

                if (section == null) throw new Exception("The HealthShare Service Security configuration section has not been specified");

                return section;
            }
        }
        
        /// <summary>
        /// Gets or sets the Base URI.
        /// </summary>
        public string BaseUri { get; set; }

        /// <summary>
        /// Gets or sets the Get Consults URI.
        /// </summary>
        public string GetConsultsUri { get; set; }

        /// <summary>
        /// Gets or sets the Make Cancel Outbound URI.
        /// </summary>
        public string MakeCancelOutboundUri { get; set; }

        /// <summary>
        /// Gets or sets whether to enable logging.
        /// </summary>
        public bool EnableLogging { get; set; }
    }
}