﻿using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace Vimt.HealthShare.Messages.Messages
{
    /// <summary>
    /// Vimt HealthShare Make Cancel Outbound Response.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VimtHealthShareMakeCancelOutboundResponseMessage)]
    [DataContract]
    public class VimtHealthShareMakeCancelOutboundResponseMessage : MessageBase
    {
        /// <summary>
        /// Gets or sets whether Exception occurred.
        /// </summary>
        [DataMember]
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Gets or sets Exception message.
        /// </summary>
        [DataMember]
        public string ExceptionMessage { get; set; }
    }
}