﻿using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace Vimt.HealthShare.Messages.Messages
{
    /// <summary>
    /// VIMT message for VimtHealthShareMakeCancelOutboundRequestMessage.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VimtHealthShareMakeCancelOutboundRequestMessage)]
    [DataContract]
    public class VimtHealthShareMakeCancelOutboundRequestMessage : MessageBase
    {
        /// <summary>
        /// Default Constructor.
        /// </summary>
        public VimtHealthShareMakeCancelOutboundRequestMessage()
        {
            Patient = new List<Patient>();
            Provider = new List<Provider>();
        }

        /// <summary>
        /// Gets or sets the Organization Name.
        /// </summary>
        [DataMember]
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets ControlId.
        /// </summary>
        [DataMember]
        public string ControlId { get; set; }
        
        /// <summary>
        /// Gets or sets SignOnFacility.
        /// </summary>
        [DataMember]
        public string SignOnFacility { get; set; }

        /// <summary>
        /// Gets or sets SecondFacility.
        /// </summary>
        [DataMember]
        public string SecondFacility { get; set; }

        /// <summary>
        /// Gets or Sets PatientIcn.
        /// </summary>
        [DataMember]
        public string PatientIcn { get; set; }

        /// <summary>
        /// Gets or Sets the Patient Name.
        /// </summary>
        [DataMember]
        public string PatientName { get; set; }

        /// <summary>
        /// Gets or Sets Duration.
        /// </summary>
        [DataMember]
        public string Duration { get; set; }

        /// <summary>
        /// Gets or Sets StartTime.
        /// </summary>
        [DataMember]
        public string StartTime { get; set; }

        /// <summary>
        /// Gets or Sets VisitStatus.
        /// </summary>
        [DataMember]
        public string VisitStatus { get; set; }

        /// <summary>
        /// Gets or Sets CancelReason.
        /// </summary>
        [DataMember]
        public string CancelReason { get; set; }

        /// <summary>
        /// Gets or Sets CancelCode.
        /// </summary>
        [DataMember]
        public string CancelCode { get; set; }

        /// <summary>
        /// Gets or Sets CancelRemarks.
        /// </summary>
        [DataMember]
        public string CancelRemarks { get; set; }

        /// <summary>
        /// Gets or Sets Scheduler SecId.
        /// </summary>
        [DataMember]
        public string SchedulerSecId { get; set; }

        /// <summary>
        /// Gets or Sets SchedulerEmail.
        /// </summary>
        [DataMember]
        public string SchedulerEmail { get; set; }

        /// <summary>
        /// Gets or Sets Comments.
        /// </summary>
        [DataMember]
        public string Comments { get; set; }

        /// <summary>
        /// Gets or Sets VvdUrl.
        /// </summary>
        [DataMember]
        public string VvdUrl { get; set; }

        /// <summary>
        /// Gets or Sets Cid.
        /// </summary>
        [DataMember]
        public string ClinicallyIndicatedDate { get; set; }

        /// <summary>
        /// Gets or Sets Patient.
        /// </summary>
        [DataMember]
        public List<Patient> Patient { get; set; }

        /// <summary>
        /// Gets or Sets Providers.
        /// </summary>
        [DataMember]
        public List<Provider> Provider { get; set; }
    }

    /// <summary>
    /// Patient.
    /// </summary>
    [DataContract]
    public class Patient
    {
        /// <summary>
        /// Gets or Sets Facility.
        /// </summary>
        [DataMember]
        public string Facility { get; set; }

        /// <summary>
        /// Gets or Sets ClinicIen.
        /// </summary>
        [DataMember]
        public string ClinicIen { get; set; }

        /// <summary>
        /// Gets or Sets ClinicDefaultProviderDuz.
        /// </summary>
        [DataMember]
        public string ClinicDefaultProviderDuz { get; set; }

        /// <summary>
        /// Gets or Sets ProviderEmail.
        /// </summary>
        [DataMember]
        public string ProviderEmail { get; set; }

        /// <summary>
        /// Gets or Sets ConsultId.
        /// </summary>
        [DataMember]
        public string ConsultId { get; set; }

        /// <summary>
        /// Gets or Sets ConsultTitle.
        /// </summary>
        [DataMember]
        public string ConsultTitle { get; set; }

        /// <summary>
        /// Gets or Sets RtcId.
        /// </summary>
        [DataMember]
        public string RtcId { get; set; }

        /// <summary>
        /// Gets or Sets Rtc parent.
        /// </summary>
        [DataMember]
        public string RtcParent { get; set; }
    }

    /// <summary>
    /// Provider.
    /// </summary>
    [DataContract]
    public class Provider
    {
        /// <summary>
        /// Gets or Sets Facility.
        /// </summary>
        [DataMember]
        public string Facility { get; set; }

        /// <summary>
        /// Gets or Sets ClinicIen.
        /// </summary>
        [DataMember]
        public string ClinicIen { get; set; }

        /// <summary>
        /// Gets or Sets ClinicDefaultProviderDuz.
        /// </summary>
        [DataMember]
        public string ClinicDefaultProviderDuz { get; set; }

        /// <summary>
        /// Gets or Sets ProviderEmail.
        /// </summary>
        [DataMember]
        public string ProviderEmail { get; set; }

        /// <summary>
        /// Gets or Sets ConsultId.
        /// </summary>
        [DataMember]
        public string ConsultId { get; set; }

        /// <summary>
        /// Gets or Sets ConsultTitle.
        /// </summary>
        [DataMember]
        public string ConsultTitle { get; set; }

        /// <summary>
        /// Gets or Sets RtcId.
        /// </summary>
        [DataMember]
        public string RtcId { get; set; }

        /// <summary>
        /// Gets or Sets Rtc parent.
        /// </summary>
        [DataMember]
        public string RtcParent { get; set; }
    }
}