﻿using System.Collections.Generic;
using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace Vimt.HealthShare.Messages.Messages
{
    /// <summary>
    /// Vimt HealthShare Get Consults Response.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VimtHealthShareGetConsultsResponse)]
    [DataContract]
    public class VimtHealthShareGetConsultsResponse : MessageBase
    {
        /// <summary>
        /// Default Constructor.
        /// </summary>
        public VimtHealthShareGetConsultsResponse()
        {
            Consults = new List<VimtConsult>();
            ReturnToClinic = new List<VimtReturnToClinicOrder>();
        }

        /// <summary>
        /// Gets or sets ControlId.
        /// </summary>
        [DataMember]
        public string ControlId { get; set; }

        /// <summary>
        /// Gets or sets Patient DFN.
        /// </summary>
        [DataMember]
        public string PatientDfn { get; set; }

        /// <summary>
        /// Gets or sets Patient ICN.
        /// </summary>
        [DataMember]
        public string PatientIcn { get; set; }

        /// <summary>
        /// Gets or sets Query Name.
        /// </summary>
        [DataMember]
        public string QueryName { get; set; }

        /// <summary>
        /// Gets or sets Institution.
        /// </summary>
        [DataMember]
        public int Institution { get; set; }

        /// <summary>
        /// Gets or sets Pending Consults.
        /// </summary>
        [DataMember]
        public List<VimtConsult> Consults { get; set; }

        /// <summary>
        /// Gets or sets Return to Clinic Orders.
        /// </summary>
        [DataMember]
        public List<VimtReturnToClinicOrder> ReturnToClinic { get; set; }

        /// <summary>
        /// Gets or sets whether Exception occurred.
        /// </summary>
        [DataMember]
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Gets or sets Exception message.
        /// </summary>
        [DataMember]
        public string ExceptionMessage { get; set; }
    }

    /// <summary>
    /// Vimt Pending Consult Class.
    /// </summary>
    [DataContract]
    public class VimtConsult
    {
        /// <summary>
        /// Gets or sets ConsultId.
        /// </summary>
        [DataMember]
        public string ConsultId { get; set; }

        /// <summary>
        /// Gets or sets Consult Request Date.
        /// </summary>
        [DataMember]
        public string ConsultRequestDateTime { get; set; }

        /// <summary>
        /// Gets or sets To Consult Service.
        /// </summary>
        [DataMember]
        public string ToConsultService { get; set; }

        /// <summary>
        /// Gets or sets Consult Title.
        /// </summary>
        [DataMember]
        public string ConsultTitle { get; set; }

        /// <summary>
        /// Gets or sets Consult Status.
        /// </summary>
        [DataMember]
        public string ConsultStatus { get; set; }

        /// <summary>
        /// Gets or sets Clinically Indicated Date.
        /// </summary>
        [DataMember]
        public string ClinicallyIndicatedDate { get; set; }

        /// <summary>
        /// Gets or sets Stop Codes.
        /// </summary>
        [DataMember]
        public string StopCodes { get; set; }

        /// <summary>
        /// Gets or sets Provider.
        /// </summary>
        [DataMember]
        public string Provider { get; set; }

        /// <summary>
        /// Gets or sets Receiving Site ConsultId.
        /// </summary>
        [DataMember]
        public string ReceivingSiteConsultId { get; set; }
    }

    /// <summary>
    /// Return to Clinic Order.
    /// </summary>
    [DataContract]
    public class VimtReturnToClinicOrder
    {
        /// <summary>
        /// Gets or sets RTC Id.
        /// </summary>
        [DataMember]
        public string RtcId { get; set; }

        /// <summary>
        /// Gets or sets RTC Request DateTime.
        /// </summary>
        [DataMember]
        public string RtcRequestDateTime { get; set; }

        /// <summary>
        /// Gets or sets Clinic IEN.
        /// </summary>
        [DataMember]
        public string ToClinicIen { get; set; }

        /// <summary>
        /// Gets or sets Clinic Name.
        /// </summary>
        [DataMember]
        public string ClinicName { get; set; }

        /// <summary>
        /// Gets or sets Clinically Indicated Date.
        /// </summary>
        [DataMember]
        public string ClinicallyIndicatedDate { get; set; }

        /// <summary>
        /// Gets or sets Stop Codes.
        /// </summary>
        [DataMember]
        public string StopCodes { get; set; }

        /// <summary>
        /// Gets or sets Provider.
        /// </summary>
        [DataMember]
        public string Provider { get; set; }

        /// <summary>
        /// Gets or sets Comments.
        /// </summary>
        [DataMember]
        public string Comments { get; set; }

        /// <summary>
        /// Gets or sets Multiple Rtc.
        /// </summary>
        [DataMember]
        public string MultiRtc { get; set; }
    }
}