﻿using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace Vimt.HealthShare.Messages.Messages
{
    /// <summary>
    /// Vimt HealthShare Get Consults Request.
    /// </summary>
    [Export(typeof(IMessageBase))]
    [ExportMetadata("MessageType", MessageRegistry.VimtHealthShareGetConsultsRequest)]
    [DataContract]
    public class VimtHealthShareGetConsultsRequest : MessageBase
    {
        /// <summary>
        /// Gets or sets the Unique Id.
        /// </summary>
        [DataMember]
        public string UniqueId { get; set; }

        /// <summary>
        /// Gets or sets Patient DFN.
        /// </summary>
        [DataMember]
        public string PatientDfn { get; set; }

        /// <summary>
        /// Gets or sets Patient ICN.
        /// </summary>
        [DataMember]
        public string PatientIcn { get; set; }

        /// <summary>
        /// Gets or sets Station Number.
        /// </summary>
        [DataMember]
        public int StationNumber { get; set; }

        /// <summary>
        /// Gets or set the whether this is Patient/Provider Side.
        /// </summary>
        [DataMember]
        public string Side { get; set; }
    }
}