﻿//If the MCS namespace object is not defined, create it.
if (typeof MCS == "undefined")
    MCS = {};

MCS.User = {};

//Check for Location alignment
MCS.User.SetLocationRequirement = function () {
    //Check if Type is VISN Lead or Other/Support
    if (Xrm.Page.getAttribute('cvt_type').getValue() != null && (Xrm.Page.getAttribute('cvt_type').getValue() == 917290006 || Xrm.Page.getAttribute('cvt_type').getValue() == 917290002)) {
        //Make Facility and TSS Site not required
        Xrm.Page.getAttribute('cvt_facility').setRequiredLevel("none");
        Xrm.Page.getAttribute('cvt_site').setRequiredLevel("none");
    }
    else {
        Xrm.Page.getAttribute('cvt_facility').setRequiredLevel("required");
        Xrm.Page.getAttribute('cvt_site').setRequiredLevel("required");
    }
};
//Displays different tabs & Fields based on field values selected. 
MCS.User.SetSubmit = function () {
    if (Xrm.Page.getAttribute("cvt_deleteuserconnections").getIsDirty() == true)
        Xrm.Page.getAttribute("cvt_deleteuserconnections").setSubmitMode("always");

    if (Xrm.Page.getAttribute("cvt_updateuserconnections").getIsDirty() == true)
        Xrm.Page.getAttribute("cvt_updateuserconnections").setSubmitMode("always");

    if (Xrm.Page.getAttribute("cvt_replacementuser").getIsDirty() == true)
        Xrm.Page.getAttribute("cvt_replacementuser").setSubmitMode("always");
};

//Set Provider Preference field with default text 
MCS.User.DefaultProviderPreferences = function () {
    
    var defaultpreftext = "The Provider visit preferences help your virtual team to understand your expectations in the provision of care using telehealth. It defines the responsibilities and procedures involved in a remote clinical visit. Below is standard guidance you may want to provide to your team. You can edit this list as you feel fits your type of visits. \n";
  
    //Preferred methods of contact
    defaultpreftext += "\nA. Provider's preferred methods of communication and contact information: \n";
    defaultpreftext += "  1. For questions/issues that may not need an appointment (pre- or post-telehealth visit): \n";
    defaultpreftext += "  2. For questions while the visit is in progress about the care or recommendation given by the provider/consultant: \n";
    defaultpreftext += "  3. For immediate needs/urgent care situations pre- or post-telehealth visit (e.g., critical lab values or time-dependent diagnoses): \n";
    defaultpreftext += "  4. For last-minute clinic/patient cancellations: \n";
    defaultpreftext += "  5.Other (specify): \n";
    
    //Clinical information
    defaultpreftext += "\nB. Clinical information you will routinely require and that the virtual team needs to ensure was completed based on your orders: \n";
    defaultpreftext += "  1. Specific clinical history: \n";
    defaultpreftext += "  2. Labs: \n";
    defaultpreftext += "  3. Imaging: \n";
    defaultpreftext += "  4. Studies: \n";
    defaultpreftext += "  5. Screenings/vital signs: \n";
    defaultpreftext += "  6. Other: \n";

    //Clinical scheduling
    defaultpreftext += "\nC. Clinical scheduling (CVT or SFT, as applicable): \n";
    defaultpreftext += "  1. Days/times clinic will be held: \n";
    defaultpreftext += "  2. Length of new (initial) patient appointment: \n";
    defaultpreftext += "  3. Length of established (returning) patient appointment (in minutes):  \n";
    
    //Technology requirements 
    defaultpreftext += "\nD. Telehealth technology requirements (Clinic, Non-VA, Home): \n";
    defaultpreftext += "  1. Provider: \n";
    defaultpreftext += "    a. PC/Laptop: \n";
    defaultpreftext += "    b. Web camera: \n";
    defaultpreftext += "    c. Desktop codec: \n";
    defaultpreftext += "    d. Other: \n";
    defaultpreftext += "  2. Patient (Clinic-Based): \n";
    defaultpreftext += "    a. Clinical Cart: \n";
    defaultpreftext += "    b. Stethoscope: \n";
    defaultpreftext += "    c. Exam Camera: \n";
    defaultpreftext += "    d. Otoscope: \n";
    defaultpreftext += "    e. Simple Video Monitor: \n";
    
    //TC vs. TM 
    defaultpreftext += "\nE. Teleconsultation vs. Telemedicine: \n";

    //TP skill
    defaultpreftext += "\nF. Telepresenter/Telehealth staff skill level and requirements to support clinical service being provided: \n";

    //Patient safety
    defaultpreftext += "\nG. Patient Safety:  \n";
    defaultpreftext += "  Requirements for service-specific emergency and disaster plan should include a patient medical or behavioral emergency and how to manage during a telehealth visit, as well as what actions/activities are expected to be performed by the provider site staff and the patient site staff. The virtual team should know the location of emergency and disaster plan/emergency procedure. There should be predetermined dates and times for practice drills. \n";
    
    //Critical labs 
    defaultpreftext += "\nH. Critical Lab and Abnormal Finding Notifications: \n";
    defaultpreftext += "  Frequency that the telehealth provider (or surrogate) logs in to Patient Site CPRS to receive/view/respond to notifications based on the site's critical value policy. Provide your guidance here: \n";

    //Record info
    defaultpreftext += "\nI. The appropriate use of telehealth for each individual patient should be noted in the patient's record and expected discharge if episodic care. Also an initial verbal consent should be annotated in the patient record. \n";
    
    var providerPreference = Xrm.Page.getAttribute("cvt_tsaproviderpreferences");
    var userType = Xrm.Page.getAttribute("cvt_type").getValue();

    if (userType == 917290001) {
        Xrm.Page.ui.tabs.get('SUMMARY_TAB').sections.get('ProviderPreferences').setVisible(true);

        if ((providerPreference.getValue() == "") || (providerPreference.getValue() == null))
            providerPreference.setValue(defaultpreftext);

        //Show VC section
        Xrm.Page.ui.tabs.get('tab_vc').setVisible(true);
        //Unlock VC fields
        Xrm.Page.getControl("cvt_intrafacilityvistaclinic").setDisabled(false);
        Xrm.Page.getControl("cvt_interfacilityvistaclinic").setDisabled(false);
        Xrm.Page.getControl("cvt_homemobilevistaclinic").setDisabled(false);
    }
    else {
        Xrm.Page.ui.tabs.get('SUMMARY_TAB').sections.get('ProviderPreferences').setVisible(false);
        Xrm.Page.ui.tabs.get('tab_vc').setVisible(false);
        Xrm.Page.getControl("cvt_intrafacilityvistaclinic").setDisabled(true);
        Xrm.Page.getControl("cvt_interfacilityvistaclinic").setDisabled(true);
        Xrm.Page.getControl("cvt_homemobilevistaclinic").setDisabled(true);
    }
};

//Check for Location alignment
MCS.User.VerifyLocations = function (context) {
    var visn = "";
    var facility = "";
    var site = "";
    var event = context.getEventArgs();

    if (Xrm.Page.getAttribute('businessunitid').getValue() != null)
        visn = Xrm.Page.getAttribute('businessunitid').getValue()[0].id;
    else {
        alert("Please select a VISN.");
        event.preventDefault();
        return;
    }
    //Check if Type is VISN Lead or Other/Support
    if (Xrm.Page.getAttribute('cvt_type').getValue() != null &&
        (Xrm.Page.getAttribute('cvt_type').getValue() == 917290006 ||
        Xrm.Page.getAttribute('cvt_type').getValue() == 917290002)) {
        return;
    }
    if (Xrm.Page.getAttribute('cvt_facility').getValue() != null)
        facility = Xrm.Page.getAttribute('cvt_facility').getValue()[0].id;
    else {
        alert("Please select a Facility.");
        event.preventDefault();
        return;
    }
    if (Xrm.Page.getAttribute('cvt_site').getValue() != null)
        site = Xrm.Page.getAttribute('cvt_site').getValue()[0].id;
    else {
        alert("Please select a TSS Site.");
        event.preventDefault();
        return;
    }
    //Make two query
    //Verify that TSS Site's (1)Facility and (2)BU match
    var calls = CrmRestKit.Retrieve("mcs_site", site, ['mcs_FacilityId', 'mcs_BusinessUnitId'], false);
    calls.fail(
            function (error) {
            }).done(function (data) {
                if (data && data.d) {
                    //Check Facility
                    if (MCS.cvt_Common.compareGUIDS(facility, data.d.mcs_FacilityId.Id) == false) {
                        alert("Save prevented. Please make sure the TSS Site, from " + data.d.mcs_FacilityId.Name + ", belongs to the Facility listed on the form: " + Xrm.Page.getAttribute('cvt_facility').getValue()[0].name);
                        event.preventDefault();
                        return;
                    }
                    var callsFacility = CrmRestKit.Retrieve("mcs_facility", data.d.mcs_FacilityId.Id, ['mcs_BusinessUnitId'], false);
                    callsFacility.fail(
                            function (error) {
                            }).done(function (result) {
                                if (result && result.d) {
                                    //Check BU
                                    if (MCS.cvt_Common.compareGUIDS(visn, result.d.mcs_BusinessUnitId.Id) == false) {
                                        alert("Save prevented. Please make sure the Facility, from " + result.d.mcs_BusinessUnitId.Name + ", belongs to the Business Unit listed on the form: " + Xrm.Page.getAttribute('businessunitid').getValue()[0].name);
                                        event.preventDefault();
                                        return;
                                    }
                                }
                            });
                }
            });
};

//Check for Location alignment
MCS.User.onLoad = function () {
    //Check if Type is Clinician/Provider, TCT/Staff, Telepresenter
    if (Xrm.Page.getAttribute('cvt_type').getValue() != null &&
        (Xrm.Page.getAttribute('cvt_type').getValue() == 917290001 ||
            Xrm.Page.getAttribute('cvt_type').getValue() == 917290005 ||
            Xrm.Page.getAttribute('cvt_type').getValue() == 917290000)) {

        //Show field
        Xrm.Page.getControl('cvt_staticvmrlink').setVisible(true);
    }
    else {
        //Hide field and clear value
        Xrm.Page.getControl('cvt_staticvmrlink').setVisible(false);
        Xrm.Page.getAttribute('cvt_staticvmrlink').setValue(null);
    }
};