﻿//Library Name: mcs_TSA.OnLoad.js
if (typeof MCS == "undefined")
    MCS = {};
// Create Namespace container for functions in this library;
MCS.mcs_TSA_OnLoad = {};

//Global Variables
MCS.mcs_TSA_OnLoad.Form_Type;
MCS.mcs_TSA_OnLoad.EntityName;
MCS.mcs_TSA_OnLoad.GroupAppt;
MCS.mcs_TSA_OnLoad.Type;
MCS.mcs_TSA_OnLoad.EntityId;

MCS.mcs_TSA_OnLoad.TSAName;
MCS.mcs_TSA_OnLoad.MTSAName;

MCS.mcs_TSA_OnLoad.relatedProviderSiteId;
MCS.mcs_TSA_OnLoad.relatedProviderSiteName;

MCS.mcs_TSA_OnLoad.relatedPatientSiteId;
MCS.mcs_TSA_OnLoad.relatedPatientSiteName;

MCS.mcs_TSA_OnLoad.relatedPatientFacilityId;
MCS.mcs_TSA_OnLoad.relatedPatientFacilityName;

MCS.mcs_TSA_OnLoad.ProvResourcesCreated = new Boolean;

MCS.SiteEmergencyPhone;
MCS.SiteMainPhone;
MCS.TCTPhone = "";
MCS.SiteLocal911Phone;

//Compare for Audit cleanup
MCS.mcs_TSA_OnLoad.Capacity;
MCS.mcs_TSA_OnLoad.InitalStatus;

MCS.mcs_TSA_OnLoad.OnLoad = function () {
    MCS.mcs_TSA_OnLoad.CheckForMTSA();

    if (Xrm.Page.getAttribute("cvt_relatedmasterid").getValue() == null)
        return;
    //Actually set all the values used in the library
    MCS.mcs_TSA_OnLoad.Form_Type = Xrm.Page.ui.getFormType();
    MCS.mcs_TSA_OnLoad.EntityName = Xrm.Page.data.entity.getEntityName();
    MCS.mcs_TSA_OnLoad.GroupAppt = (Xrm.Page.getAttribute("cvt_groupappointment") != null) ? Xrm.Page.getAttribute("cvt_groupappointment").getValue() : false;
    MCS.mcs_TSA_OnLoad.Type = (Xrm.Page.getAttribute("cvt_type") != null) ? Xrm.Page.getAttribute("cvt_type").getValue() : false;
    MCS.mcs_TSA_OnLoad.EntityId = Xrm.Page.data.entity.getId();

    if (MCS.mcs_TSA_OnLoad.Form_Type == MCS.cvt_Common.FORM_TYPE_CREATE)
        MCS.cvt_Common.DateTime('cvt_beginngtime', 8, 00);

    MCS.cvt_Common.EnableDependentLookup("cvt_servicetype", "cvt_servicesubtype");

    if (Xrm.Page.getAttribute("cvt_relatedmasterid").getValue() != null) {
        Xrm.Page.getControl("cvt_relatedmasterid").setDisabled(true);
    }
    //Conditional because of potentially missing data.
    if (Xrm.Page.getAttribute("cvt_providerlocationtype").getValue() != null) {
        Xrm.Page.getControl("cvt_providerlocationtype").setDisabled(true);
    }
    else {
        Xrm.Page.getControl("cvt_providerlocationtype").setDisabled(false);
    }

    Xrm.Page.getControl("mcs_name").setFocus(); //To bring to the top
   
    Xrm.Page.getAttribute("cvt_relatedpatientsiteid").setSubmitMode("always");
};

MCS.mcs_TSA_OnLoad.BulkEdit = function () {
    //Not Bulk Edit
    if (MCS.mcs_TSA_OnLoad.Form_Type != 6) {
        //Hide the Bulk Edit section on all forms
        Xrm.Page.ui.tabs.get('tab_Pat').sections.get('tab_Pat_section_Bulk').setVisible(false);

        //Set all sections to hidden on form.  Show all sections
        //TSA tab
        Xrm.Page.ui.tabs.get('tab_Name').setVisible(true); 
        
        //General section
        Xrm.Page.ui.tabs.get('tab_Info').sections.get('tab_Info_section_General').setVisible(true);
        Xrm.Page.ui.tabs.get('tab_Info').sections.get('tab_Info_section_General2').setVisible(true);
        
        //Provider Grid section
        Xrm.Page.ui.tabs.get('tab_Prov').sections.get('tab_provresources').setVisible(true);

        //Patient Grid section
        Xrm.Page.ui.tabs.get('tab_Pat').sections.get('tab_patientresources').setVisible(true);
        //Set Emergency IFRAME true       
        Xrm.Page.ui.tabs.get('tab_Pat').sections.get('tab_Info_section_Emergency').setVisible(true);
        Xrm.Page.getControl('IFRAME_EmergencyContactViewer').setVisible(true);

        //Admin tab
        Xrm.Page.ui.tabs.get('tab_Admin').setVisible(true);

        MCS.mcs_TSA_OnLoad.SOS();

        //Load Operations Guide
        var filter = "mcs_name eq 'Active Settings'";
        calls = CrmRestKit.ByQuery("mcs_setting", ['cvt_telehealthoperationsmanual'], filter, false);
        calls.fail(function (err) {
        }).done(function (data) {
            if (data && data.d && data.d.results != null && data.d.results.length != 0) {
                var url = data.d.results[0].cvt_telehealthoperationsmanual != null ? data.d.results[0].cvt_telehealthoperationsmanual : null;
                if (url != null)
                    Xrm.Page.getAttribute("cvt_telehealthoperationsmanual").setValue(url);
            }
        });
    }
};

//Getting Attributes needed for Quick Create Buttons
MCS.mcs_TSA_OnLoad.GetAttributes = function () {
    //TSA
    //if (MCS.mcs_TSA_OnLoad.EntityName == "mcs_services") {
        MCS.mcs_TSA_OnLoad.TSAName = Xrm.Page.getAttribute("mcs_name").getValue();

        var provSiteField = Xrm.Page.getAttribute("cvt_relatedprovidersiteid");
        var patSiteField = Xrm.Page.getAttribute("cvt_relatedpatientsiteid");
        switch (MCS.mcs_TSA_OnLoad.GroupAppt) {           
            case false:
                if (patSiteField.getValue() != null) {
                    var relatedPatientSite = patSiteField.getValue();
                    MCS.mcs_TSA_OnLoad.relatedPatientSiteId = relatedPatientSite[0].id;
                    MCS.mcs_TSA_OnLoad.relatedPatientSiteName = relatedPatientSite[0].name;
                }
                if (provSiteField.getValue() != null) {
                    var relatedProviderSite = provSiteField.getValue();
                    MCS.mcs_TSA_OnLoad.relatedProviderSiteId = relatedProviderSite[0].id;
                    MCS.mcs_TSA_OnLoad.relatedProviderSiteName = relatedProviderSite[0].name;
                }
                break;

            case true:
                if (provSiteField.getValue() != null) {
                    var relatedProviderSite = provSiteField.getValue();
                    MCS.mcs_TSA_OnLoad.relatedProviderSiteId = relatedProviderSite[0].id;
                    MCS.mcs_TSA_OnLoad.relatedProviderSiteName = relatedProviderSite[0].name;
                }
                var patFacilityField = Xrm.Page.getAttribute("cvt_patientfacility");
                if (patFacilityField.getValue() != null) {
                    MCS.mcs_TSA_OnLoad.relatedPatientFacilityId = patFacilityField.getValue()[0].id;
                    MCS.mcs_TSA_OnLoad.relatedPatientFacilityName = patFacilityField.getValue()[0].name;
                }
                break;
        }
};

MCS.mcs_TSA_OnLoad.LoadProvResources = function (executionObj) {
    if (Xrm.Page.getAttribute("cvt_relatedmasterid").getValue() == null)
        return;
    var mtsaId = Xrm.Page.getAttribute("cvt_relatedmasterid").getValue()[0].id;
   
    if ((mtsaId != null) && (MCS.mcs_TSA_OnLoad.Form_Type == 1) && (MCS.mcs_TSA_OnLoad.ProvResourcesCreated == false)) {

        //Looking up the Prov Site Resources related to the MTSA we came from.     
        //var columns = "<attribute name='cvt_providerresourcegroupid'/><attribute name='cvt_tsaresourcetype'/>";
        var columns = [
            'cvt_providerresourcegroupid',
            'cvt_tsaresourcetype'
        ];
        var conditions = [
            "<condition attribute='cvt_relatedmastertsaid' operator='eq' uitype='cvt_mastertsa' value='" + mtsaId + "' />",
            "<condition attribute= 'statecode' operator='in'><value>0</value><value>3</value></condition>"
        ];
        var fetchXml = MCS.cvt_Common.CreateFetch('cvt_providerresourcegroup', columns, conditions, null);

        XrmSvcToolkit.fetch({
            fetchXml: fetchXml,
            async: true,
            successCallback: function (result) {
                countValue = result.entities.length;
                if (countValue > 0) {
                    for (var i = 0; i < countValue; i++) {
                        var provResourceId = result.entities[i].cvt_providerresourcegroupid;
                        var tsaResourceType = result.entities[i].cvt_tsaresourcetype.Value;
                        
                        //Single Resource
                        if (tsaResourceType == 1) {
                            CrmRestKit.Retrieve('cvt_providerresourcegroup', provResourceId, ['cvt_name', 'cvt_TSAResourceType', 'cvt_Type', 'cvt_RelatedResourceId', 'cvt_relatedsiteid'], false)
                                     .fail(function () { alert("Retrieve Failed") })
                                     .done(function (data) {
                                         Name = data.d.cvt_name;
                                         Type = data.d.cvt_Type.Value;
                                         TSAType = data.d.cvt_TSAResourceType.Value;
                                         RelatedSite = data.d.cvt_relatedsiteid;
                                         Resource = data.d.cvt_RelatedResourceId;                                      
                                     })
                            var provResource = {
                                'cvt_name': Name,
                                'cvt_TSAResourceType': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.OptionSetValue" }, Value: TSAType },
                                'cvt_Type': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.OptionSetValue" }, Value: Type },
                               // 'cvt_RelatedTSAid': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: EntityId, LogicalName: EntityName },                             
                                'cvt_RelatedResourceId': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: Resource.Id, LogicalName: Resource.LogicalName },
                                'cvt_relatedsiteid': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: RelatedSite.Id, LogicalName: RelatedSite.LogicalName },
                                'cvt_mtsaguid': mtsaId
                            };
                            CrmRestKit.Create('cvt_providerresourcegroup', provResource, true)
                            .fail(function () { alert("Create failed") })
                            .done()
                        }

                        //Resource Group
                        if (tsaResourceType == 0) {
                            CrmRestKit.Retrieve('cvt_providerresourcegroup', provResourceId, ['cvt_name', 'cvt_TSAResourceType', 'cvt_Type', 'cvt_RelatedResourceGroupid', 'cvt_relatedsiteid'], false)
                                     .fail(function () { alert("Retrieve Failed") })
                                     .done(function (data) {
                                         Name = data.d.cvt_name;
                                         Type = data.d.cvt_Type.Value;
                                         TSAType = data.d.cvt_TSAResourceType.Value;
                                         RelatedSite = data.d.cvt_relatedsiteid;
                                         ResourceGroup = data.d.cvt_RelatedResourceGroupid;                                        
                                     })
                            var provResource = {
                                'cvt_name': Name,
                                'cvt_TSAResourceType': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.OptionSetValue" }, Value: TSAType },
                                'cvt_Type': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.OptionSetValue" }, Value: Type },
                              //  'cvt_RelatedTSAid': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: EntityId, LogicalName: EntityName },
                                'cvt_RelatedResourceGroupid': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: ResourceGroup.Id, LogicalName: ResourceGroup.LogicalName },                                
                                'cvt_relatedsiteid': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: RelatedSite.Id, LogicalName: RelatedSite.LogicalName },
                                'cvt_mtsaguid': mtsaId
                            };
                            CrmRestKit.Create('cvt_providerresourcegroup', provResource, true)
                            .fail(function () { alert("Create failed") })
                            .done()
                        }

                        //Provider
                        if (tsaResourceType == 2) {
                            CrmRestKit.Retrieve('cvt_providerresourcegroup', provResourceId, ['cvt_name', 'cvt_TSAResourceType', 'cvt_RelatedUserId', 'cvt_relatedsiteid'], false)
                                     .fail(function () { alert("Retrieve Failed") })
                                     .done(function (data) {
                                         Name = data.d.cvt_name;
                                         TSAType = data.d.cvt_TSAResourceType.Value;
                                         RelatedSite = data.d.cvt_relatedsiteid;
                                         User = data.d.cvt_RelatedUserId;
                                     })
                            var provResource = {
                                'cvt_name': Name,
                                'cvt_TSAResourceType': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.OptionSetValue" }, Value: TSAType },                               
                              //  'cvt_RelatedTSAid': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: EntityId, LogicalName: EntityName },                                
                                'cvt_RelatedUserId': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: User.Id, LogicalName: User.LogicalName },                               
                                'cvt_relatedsiteid': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: RelatedSite.Id, LogicalName: RelatedSite.LogicalName },
                                'cvt_mtsaguid': mtsaId
                            };
                            CrmRestKit.Create('cvt_providerresourcegroup', provResource, true)
                            .fail(function () { alert("Create failed") })
                            .done()
                        }
                    }
                }
            },
            errorCallback: function (error) {
                throw error;
            }
        });      
    }
};

MCS.mcs_TSA_OnLoad.AssignProvResources = function (executionObj) {
    if (Xrm.Page.getAttribute("cvt_relatedmasterid").getValue() == null)
        return;
    var mtsaId = Xrm.Page.getAttribute("cvt_relatedmasterid").getValue()[0].id;
    var EntityId;
    var EntityName;

    if ((mtsaId != null) && (MCS.mcs_TSA_OnLoad.Form_Type == 2)) {
        if (typeof (MCS.mcs_TSA_OnLoad) != "undefined") {
            EntityId = MCS.mcs_TSA_OnLoad.EntityId;
            EntityName = MCS.mcs_TSA_OnLoad.EntityName;
        }
        else {
            EntityId = window.parent.MCS.mcs_TSA_OnLoad.EntityId;
            EntityName = window.parent.MCS.mcs_TSA_OnLoad.EntityName;
        }

        //Looking up the Prov Site Resources related to the MTSA we came from. 
        var columns = [
            'cvt_providerresourcegroupid',
            'cvt_tsaresourcetype'
        ];
        var conditions = [
            "<condition attribute='cvt_mtsaguid' value='" + mtsaId + "' operator='eq'/>",
            "<condition attribute= 'statecode' operator='in'><value>0</value><value>3</value></condition>"
        ];
        var fetchXml = MCS.cvt_Common.CreateFetch('cvt_providerresourcegroup', columns, conditions, null);

        XrmSvcToolkit.fetch({
            fetchXml: fetchXml,
            async: false,
            successCallback: function (result) {
                countValue = result.entities.length;
                if (countValue > 0) {
                    for (var i = 0; i < countValue; i++) {
                        var provResourceId = result.entities[i].cvt_providerresourcegroupid;

                        var provResource = {
                            'cvt_RelatedTSAid': { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: EntityId, LogicalName: EntityName },
                            'cvt_mtsaguid': ''
                        };
                        CrmRestKit.Update('cvt_providerresourcegroup', provResourceId, provResource, false)
                                        .fail(function () { alert("Update Failed") })
                                        .done(function () {
                                        })
                    }
                }
            },
            errorCallback: function (error) {
                throw error;
            }
        });
    }
};

MCS.mcs_TSA_OnLoad.RefreshGridAgain = function () {
    if (Xrm.Page.getAttribute("cvt_relatedmasterid").getValue() == null)
        return;
    var mtsaId = Xrm.Page.getAttribute("cvt_relatedmasterid").getValue()[0].id;
    if ((mtsaId != null) && (MCS.mcs_TSA_OnLoad.Form_Type == 2)) {

        var ProvSiteResourcesGrid = document.getElementById("provgroups");
        if (ProvSiteResourcesGrid == null) {
            setTimeout(function () { MCS.mcs_TSA_OnLoad.RefreshGridAgain(); }, 500);
            return;
        }
        setTimeout(function () {

            if (ProvSiteResourcesGrid.control.Refresh != undefined) {
                ProvSiteResourcesGrid.control.Refresh()
            }
            else {
                ProvSiteResourcesGrid.control.refresh()
            }
        }, 3000);

        setTimeout(function () {

            if (ProvSiteResourcesGrid.control.Refresh != undefined) {
                ProvSiteResourcesGrid.control.Refresh()
            }
            else {
                ProvSiteResourcesGrid.control.refresh()
            }
        }, 3000);

        setTimeout(function () {

            if (ProvSiteResourcesGrid.control.Refresh != undefined) {
                ProvSiteResourcesGrid.control.Refresh()
            }
            else {
                ProvSiteResourcesGrid.control.refresh()
            }
        }, 3000);

        setTimeout(function () {

            if (ProvSiteResourcesGrid.control.Refresh != undefined) {
                ProvSiteResourcesGrid.control.Refresh()
            }
            else {
                ProvSiteResourcesGrid.control.refresh()
            }
        }, 3000);
    }
};

MCS.mcs_TSA_OnLoad.showEmergencyContactViewer = function () {
    if (Xrm.Page.getAttribute("cvt_relatedmasterid").getValue() == null)
        return;
    if (MCS.mcs_TSA_OnLoad.Form_Type == MCS.cvt_Common.FORM_TYPE_CREATE || MCS.mcs_TSA_OnLoad.GroupAppt == true || MCS.mcs_TSA_OnLoad.Type == true) {
        Xrm.Page.getControl("IFRAME_EmergencyContactViewer").setVisible(false);
        return;
    }
    if (Xrm.Page.getAttribute("cvt_relatedpatientsiteid").getValue() == null) {
        alert("Please select a Patient Site.");
        Xrm.Page.getControl("IFRAME_EmergencyContactViewer").setVisible(false);
        return;
    }
    var siteId = Xrm.Page.getAttribute("cvt_relatedpatientsiteid").getValue()[0];
    CrmRestKit.Retrieve('mcs_site', siteId.id, ["cvt_Local911", "cvt_UrgentEmergencyPhone", "cvt_phone"], false).fail(
        function (err) {
            //throw new Exception;
        }).done(function (data) {
            var resultFields = data.d;
            var patTCTteam = (Xrm.Page.getAttribute("cvt_patientsitetctteam") != null) ? Xrm.Page.getAttribute("cvt_patientsitetctteam").getValue() : null;
            MCS.SiteLocal911Phone = resultFields["cvt_Local911"];
            MCS.SiteEmergencyPhone = resultFields["cvt_UrgentEmergencyPhone"];
            MCS.SiteMainPhone = resultFields["cvt_phone"];

            if (patTCTteam != null) {
                //var filter = "SystemUserId eq (Guid' " + userId + "') and TeamId eq (Guid' " + teamid + "')";
                var filter = "TeamId eq (Guid'" + patTCTteam[0].id + "')";;   //Teammembers where teamid = PatTCTTeam
                calls = CrmRestKit.ByQuery("TeamMembership", ['TeamId', 'SystemUserId'], filter, false);
                calls.fail(function (err) {
                    alert("team member retrieve failed");
                }).done(function (data) {
                    if (data && data.d && data.d.results != null && data.d.results.length != 0) {
                        //alert("Results found: " + data.d.results.length);
                        var teamMembers = data.d.results;
                        for (var i = 0; i < teamMembers.length; i++)
                        {
                            var tctName = "";
                            var tctPhone = "";

                            CrmRestKit.Retrieve('SystemUser', teamMembers[i].SystemUserId, ['FirstName', 'LastName', 'cvt_officephone', 'MobilePhone', 'SystemUserId'], false).fail(function (err) {
                                alert("user retrieve failed");
                            }).done(function (data2) {
                                var office = data2.d["cvt_officephone"];
                                var mobile = data2.d["MobilePhone"];
                                tctName = data2.d["FirstName"] + " " + data2.d["LastName"];
                                tctPhone = (mobile == null) ? office : mobile;
                            });
                            if (tctPhone != null) {
                                if (MCS.TCTPhone != "")
                                    MCS.TCTPhone += "; ";
                                MCS.TCTPhone += tctName + ': ' + tctPhone;
                            }
                        }
                    }
                });
            }
            else {
                MCS.TCTPhone = "No TCT Team Members";
            }
        });
    var urlBuilder = MCS.cvt_Common.BuildRelationshipServerUrl() + "/WebResources/cvt_EmergencyContactViewer.html";
    var IFrame = Xrm.Page.ui.controls.get("IFRAME_EmergencyContactViewer");

    // Use the setSrc method so that the IFRAME uses the new page with the existing parameters
    IFrame.setSrc(urlBuilder);
};

MCS.mcs_TSA_OnLoad.CheckForMTSA = function () {
    //Check if formType = create
    if (Xrm.Page.ui.getFormType() == MCS.cvt_Common.FORM_TYPE_CREATE) {
        //Check for MTSA - //No MTSA - must be created from one.
        if (Xrm.Page.getAttribute("cvt_relatedmasterid").getValue() == null)
            MCS.cvt_Common.closeWindow("A TSA must be created from a MTSA.\n\nPlease close this TSA form and start from a MTSA.");
    }
};

MCS.mcs_TSA_OnLoad.SOS = function () {
    //Make the SOS field visible and get the url
    if (Xrm.Page.getAttribute("cvt_servicetype").getValue() != null) {
        CrmRestKit.Retrieve('mcs_servicetype', Xrm.Page.getAttribute("cvt_servicetype").getValue()[0].id, ["cvt_specialtyoperationssupplement"], false).fail(function (err) {
            //alert("fail");
        }).done(function (data) {
            //alert("success");
            var url = data.d["cvt_specialtyoperationssupplement"];

            if (url) {
                Xrm.Page.getControl("cvt_specialtyoperationssupplement").setVisible(true);
                Xrm.Page.getAttribute("cvt_specialtyoperationssupplement").setValue(url);
            }
        });
    }
};