﻿//If the SDK namespace object is not defined, create it.
if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;
MCS.cvt_StagingResource = {};

MCS.cvt_StagingResource.FormOnload = function () {
    MCS.cvt_StagingResource.SetRequiredFields();
    MCS.cvt_StagingResource.SetConnectedResourceVisibility();
    Xrm.Page.getAttribute("cvt_action").addOnChange(MCS.cvt_StagingResource.ActionOnChange);
    MCS.cvt_StagingResource.SetCartTypeVisibility();
    Xrm.Page.getAttribute("cvt_systemtype").addOnChange(MCS.cvt_StagingResource.SystemTypeOnChange);
    Xrm.Page.getAttribute("cvt_masterserialnumber").addOnChange(MCS.cvt_StagingResource.MasterSerialNumberOnChange);
    //Xrm.Page.getAttribute("mcs_facility").addOnChange(MCS.cvt_StagingResource.SetRequiredFields);
    //Xrm.Page.getAttribute("mcs_relatedsiteid").addOnChange(MCS.cvt_StagingResource.SetRequiredFields);
    Xrm.Page.getAttribute("cvt_resourcetomatch").addOnChange(MCS.cvt_StagingResource.ShowNotification);
};

MCS.cvt_StagingResource.MasterSerialNumberOnChange = function () {
    var masterSerialNumber = Xrm.Page.getAttribute("cvt_masterserialnumber").getValue();
    Xrm.Page.getAttribute("mcs_name").setValue(masterSerialNumber);
};

MCS.cvt_StagingResource.SetRequiredFields = function () {
    var formName = Xrm.Page.ui.formSelector.getCurrentItem().getLabel();
    var isInfoForm = (formName == 'Information');
    var facility = Xrm.Page.getAttribute("mcs_facility").getValue();
    var siteControl = Xrm.Page.getControl("mcs_relatedsiteid");
    siteControl.setRequiredLevel(facility == null ? "recommended" : "required");

    var site = Xrm.Page.getAttribute("mcs_relatedsiteid").getValue();
    var actionControl = Xrm.Page.getControl("cvt_action");
    actionControl.setRequiredLevel(site == null ? "recommended" : "required");

    var masterSerialNumber = Xrm.Page.getAttribute("cvt_masterserialnumber").getValue();
    if (masterSerialNumber !== "" && isInfoForm) {
        var masterSerialfield = Xrm.Page.getControl("cvt_masterserialnumber");
        masterSerialfield.setDisabled(true);
    }

    var approvalResult = Xrm.Page.getControl("cvt_approvalresult");
    approvalResult.setVisible(false);

    var approvalStatus = Xrm.Page.getControl("cvt_approvalstatus");
    approvalStatus.setVisible(false);
};

MCS.cvt_StagingResource.SetConnectedResourceVisibility = function () {
    if (Xrm.Page.ui.getFormType() === MCS.cvt_Common.FORM_TYPE_CREATE) {
        Xrm.Page.getControl("cvt_resourcetomatch").setVisible(false);
    } else {
        var action = Xrm.Page.getAttribute("cvt_action").getValue();
        var visibility = action !== null && action === 917290000;
        var resourceToUse = Xrm.Page.getControl("cvt_resourcetomatch");
        resourceToUse.setVisible(visibility);
        resourceToUse.setRequiredLevel(visibility ? "required" : "none");
    }
};

MCS.cvt_StagingResource.SetCartTypeVisibility = function () {
    if (Xrm.Page.ui.getFormType() === MCS.cvt_Common.FORM_TYPE_CREATE) {
        Xrm.Page.getControl("cvt_carttypeid").setVisible(false);
    } else {
        var systemType = Xrm.Page.getAttribute("cvt_systemtype").getValue();
        var visibility = systemType !== null && systemType === 917290001; //Telehealth Patient Cart System
        var cartType = Xrm.Page.getControl("cvt_carttypeid");
        cartType.setVisible(visibility);
        cartType.setRequiredLevel(visibility ? "required" : "none");
    }
};

MCS.cvt_StagingResource.ShowNotification = function () {
    Xrm.Page.ui.clearFormNotification("00000000-0000-0000-0000-000000000000");
    Xrm.Page.ui.setFormNotification("Next Steps: Please review and take action on the Import field mismatches, update the actions for each of the Staging Component records prior to approving the Inventory Resource", "INFO", "00000000-0000-0000-0000-000000000000");
}

MCS.cvt_StagingResource.ActionOnChange = function () {
    MCS.cvt_StagingResource.ShowNotification();
    var resourceToUse = Xrm.Page.getAttribute("cvt_resourcetomatch");
    resourceToUse.setValue(null);
    MCS.cvt_StagingResource.SetConnectedResourceVisibility();
};

MCS.cvt_StagingResource.SystemTypeOnChange = function () {
    var cartType = Xrm.Page.getAttribute("cvt_carttypeid");
    cartType.setValue(null);
    MCS.cvt_StagingResource.SetCartTypeVisibility();
};