﻿//If the SDK namespace object is not defined, create it.
if (typeof (MCS) == "undefined") {
    MCS = {};
};
// Create Namespace container for functions in this library;
MCS.cvt_StagingResource_Buttons = {};

MCS.cvt_StagingResource_Buttons.ApproveAndComplete = function () {
    if (MCS.cvt_StagingResource_Buttons.VerifyRequiredFormFields() && confirm("Do you want to approve the Inventory Resource and all the Components under it?\n\rPlease review the Inventory resource and staging components records and ensure all the required fields have the values set."))
        MCS.cvt_StagingResource_Buttons.UpdateRecord(917290000);
};

MCS.cvt_StagingResource_Buttons.Reject = function () {
    var dialog = MCS.cvt_Common.openDialogOnCurrentRecord("0463e5a0-a15c-4e95-acd4-a188e6f14eec");
    try {
        var timer = setInterval(function () { MCS.cvt_StagingResource_Buttons.OnDialogClose(dialog, timer) }, 1000); //Poll every second
    } catch (ex) {
        //Error Handling
        MCS.cvt_Common.RestError("An error occured while opening the dialog:" + ex);
    }
};

MCS.cvt_StagingResource_Buttons.OnDialogClose = function (dialog, timer) {
    if (!dialog || dialog.closed) {
        clearInterval(timer); //stop the timer
        MCS.cvt_StagingResource_Buttons.Refresh(false);
    }
}

MCS.cvt_StagingResource_Buttons.Refresh = function (isApproved) {
    CrmRestKit.Retrieve("cvt_stagingresource", Xrm.Page.data.entity.getId(), ["statecode", "cvt_approvalresult"], false)
            .fail(function (ex) {
                MCS.cvt_Common.RestError("An error occured while retriving the record:" + ex);
                window.location.reload(true);
            }).done(function (result) {
                var resourceRecord = result.d; //Refresh the form when the state code has changed from Active to Inactive from the dialog
                if (isApproved && resourceRecord.cvt_approvalresult != null && resourceRecord.cvt_approvalresult === true) {
                    Xrm.Page.ui.clearFormNotification("00000000-0000-0000-0000-000000000000");
                    Xrm.Page.ui.setFormNotification("Please resolve all Import Field Mismatches before you proceed with the approval.", "WARNING", "00000000-0000-0000-0000-000000000000");

                    //alert("Please resolve all Import Field Mismatches before you proceed with the approval.");
                    var fieldMismatchValidationGrid = document.getElementById("MismatchFieldValidation");
                    setTimeout(function () { fieldMismatchValidationGrid.control.Refresh() }, 500);
                }

                if (resourceRecord.statecode != null && (resourceRecord.statecode.Value === 1)) {
                    window.location.reload(true);
                }

                Xrm.Page.getAttribute("cvt_approvalstatus").setValue(false);
            });
}

MCS.cvt_StagingResource_Buttons.VerifyRequiredFormFields = function () {
    var fieldsToVerify = ['cvt_masterserialnumber', 'mcs_type', 'cvt_systemtype', 'cvt_action', 'mcs_relatedsiteid', 'mcs_facility', 'cvt_uniqueid', 'cvt_locationuse'];
    var i;
    for (i = 0; i < fieldsToVerify.length; i++) {
        var field = Xrm.Page.getControl(fieldsToVerify[i]);
        var fieldValue = Xrm.Page.getAttribute(fieldsToVerify[i]);
        if (field !== null && fieldValue !== null && fieldValue.getValue() == null) {
            //alert('Please review and set all the required fields before you proceed');
            Xrm.Page.ui.clearFormNotification("00000000-0000-0000-0000-000000000000");
            Xrm.Page.ui.setFormNotification("Please review and set all the required fields before you proceed", "WARNING", "00000000-0000-0000-0000-000000000000");

            Xrm.Page.getAttribute("cvt_approvalstatus").setValue(false);
            return false;
        }
    }
    var action = Xrm.Page.getAttribute("cvt_action").getValue();
    var resourceToUse = Xrm.Page.getAttribute("cvt_resourcetomatch").getValue();

    var systemType = Xrm.Page.getAttribute("cvt_systemtype").getValue();
    var cartType = Xrm.Page.getAttribute("cvt_carttypeid").getValue();
    if ((systemType === 917290001 && cartType == null) || (action === 917290000 && resourceToUse == null)) //Telehealth Patient Cart System
    {
        Xrm.Page.ui.clearFormNotification("00000000-0000-0000-0000-000000000000");
        Xrm.Page.ui.setFormNotification("Please review and set all the required fields before you proceed", "WARNING", "00000000-0000-0000-0000-000000000000");
        Xrm.Page.getAttribute("cvt_approvalstatus").setValue(false);
        return false;
    }

    return true;
};

MCS.cvt_StagingResource_Buttons.UpdateRecord = function(userSelection) {
    if (Xrm.Page.ui.getFormType() !== MCS.cvt_Common.FORM_TYPE_CREATE) {
        var id = Xrm.Page.data.entity.getId();
        id = id.replace("{", "").replace("}", "");
        var record = {};

        record.cvt_approvalstatus = { Value: userSelection };
        CrmRestKit.Update("cvt_stagingresource", id, record, false)
            .fail(function(ex) {
                if (ex != null && ex.responseText != null) {
                    var errorJson = JSON.parse(ex.responseText);
                    if (errorJson != null && errorJson.error != null && errorJson.error.message != null && errorJson.error.message.value != null) {
                        alert(errorJson.error.message.value);
                        return;
                    }
                }
                //alert("Please review and resolve all Import Field Mismatches before you proceed with the approval.");
            })
            .done(function() {
                setTimeout(function() { MCS.cvt_StagingResource_Buttons.Refresh(true); }, 1000);
            });
    }
};