﻿//If the SDK namespace object is not defined, create it.
if (typeof MCS == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;
MCS.cvt_StagingComponent = {};

MCS.cvt_StagingComponent.FormOnload = function () {
    matchingResourceId = '';
    var stagingResource = Xrm.Page.getAttribute("cvt_relatedresourceid").getValue();
    if (stagingResource != null && stagingResource[0] != null) {
        CrmRestKit.Retrieve("cvt_stagingresource", stagingResource[0].id, ["cvt_resourcetomatch", "cvt_action"], false)
            .fail(function (ex) {
                MCS.cvt_Common.RestError("An error occured while retriving the record:" + ex);
            }).done(function (result) {
                var resourceRecord = result.d; //Refresh the form when the state code has changed from Active to Inactive from the dialog
                if (resourceRecord.cvt_action != null && resourceRecord.cvt_action.Value == null) {
                    Xrm.Page.ui.clearFormNotification();
                    Xrm.Page.ui.setFormNotification("Please review and update the action in the Inventory Resource record before starting with the Staging Component Action", "WARNING");
                    Xrm.Page.getControl("cvt_action").setDisabled(true);
                }
                else if (resourceRecord.cvt_action.Value != null && resourceRecord.cvt_action.Value === 917290000 && resourceRecord.cvt_resourcetomatch != null) {
                    var matchingResource = resourceRecord.cvt_resourcetomatch;
                    matchingResourceId = matchingResource.Id;
                }
            });
    }

    MCS.cvt_StagingComponent.GetMatchingComponents();
    MCS.cvt_StagingComponent.SetConnectedComponentVisibility();
    Xrm.Page.getAttribute("cvt_action").addOnChange(MCS.cvt_StagingComponent.ActionOnChange);
    MCS.cvt_StagingComponent.DisableFormFields();
};
//Set grids which will retrieve all Components matching the serial number of the staging component.
MCS.cvt_StagingComponent.GetMatchingComponents = function () {
    if (Xrm.Page.ui.getFormType() !== MCS.cvt_Common.FORM_TYPE_CREATE) {

        MCS.cvt_StagingComponent.AddLookupView();
        var matchingComponentsGrid = document.getElementById("MatchingComponents");
        if (matchingComponentsGrid == null) { //make sure the grids have loaded 
            setTimeout(function () { MCS.cvt_StagingComponent.GetMatchingComponents(); }, 500); //if the grid hasn’t loaded run this again when it has 
            return;
        }

        var serialNumber = Xrm.Page.getAttribute("cvt_serialnumber").getValue();

        matchingComponentsGrid.control.SetParameter("fetchXml", MCS.cvt_StagingComponent.GetFetchXML("cvt_component", serialNumber)); //set the fetch xml to the sub grid   
        setTimeout(function () { matchingComponentsGrid.control.Refresh(); }, 500);
        matchingComponentsGrid.control.Refresh();
    }
};

MCS.cvt_StagingComponent.DisableFormFields = function () {
    var fieldsToDisable = ['cvt_manufacturerid', 'cvt_modelnumber', 'cvt_serialnumber', 'cvt_partnumber', 'cvt_eenumber', 'cvt_ipaddress', 'cvt_tmssystemname', 'cvt_e164alias', 'cvt_tmsid'];
    var i;
    var formName = Xrm.Page.ui.formSelector.getCurrentItem().getLabel();
    for (i = 0; i < fieldsToDisable.length; i++) {
        var field = Xrm.Page.getControl(fieldsToDisable[i]);
        var fieldValue = Xrm.Page.getAttribute(fieldsToDisable[i]);
        if (field !== null && fieldValue !== null && fieldValue.getValue() !== null && formName == 'Information') {
            field.setDisabled(true);
        }
    }
};

MCS.cvt_StagingComponent.ActionOnChange = function () {
    var resourceToUse = Xrm.Page.getAttribute("cvt_connectedcomponentid");
    resourceToUse.setValue(null);
    MCS.cvt_StagingComponent.SetConnectedComponentVisibility();
};

MCS.cvt_StagingComponent.SetConnectedComponentVisibility = function() {
    if (Xrm.Page.ui.getFormType() === MCS.cvt_Common.FORM_TYPE_CREATE) {
        Xrm.Page.getControl("cvt_connectedcomponentid").setVisible(false);
    } else {
        var action = Xrm.Page.getAttribute("cvt_action").getValue();
        var visibility = action !== null && action === 917290000;
        var componentToUse = Xrm.Page.getControl("cvt_connectedcomponentid");
        componentToUse.setVisible(visibility);
        componentToUse.setRequiredLevel(visibility ? "required" : "none");
    }
};

MCS.cvt_StagingComponent.GetFetchXML = function (entityName, serialNumber) {
    var fetchXml = "";
    switch (entityName) {
        case "cvt_component":
            //fetch xml code which will retrieve all Components matching the serial number of the staging component.  
            fetchXml =
                "<fetch version='1.0' mapping='logical'>" +
                  "<entity name='cvt_component'>" +
                    "<order attribute='cvt_relatedresourceid' descending='false' />" +
                    "<filter type='and'>" +
                      "<condition attribute='statecode' operator='eq' value='0' />" +
                      "<condition attribute='cvt_serialnumber' operator='eq' value='" + serialNumber + "' />" +
                      (matchingResourceId == null || matchingResourceId === "" ? "" : "<condition attribute='cvt_relatedresourceid' operator='ne' value='" + matchingResourceId + "' />") +
                    "</filter>" +
                    "<attribute name='cvt_componenttype' />" +
                    "<attribute name='cvt_modelnumber' />" +
                    "<attribute name='cvt_relatedresourceid' />" +
                    "<attribute name='cvt_manufacturerid' />" +
                    "<attribute name='cvt_parentresourceidentifier' />" +
                    "<attribute name='cvt_tmssystemname' />" +
                    "<attribute name='cvt_tmsid' />" +
                    "<attribute name='cvt_serialnumber' />" +
                    "<attribute name='cvt_eenumber' />" +
                    "<attribute name='cvt_e164alias' />" +
                    "<link-entity alias='a_2c7b6fee1868e3119e2500155d559835' name='mcs_resource' from='mcs_resourceid' to='cvt_relatedresourceid' link-type='outer' visible='false'>" +
                      "<attribute name='mcs_relatedsiteid' />" +
                      "<attribute name='cvt_relateduser' />" +
                    "</link-entity>" +
                    "<attribute name='cvt_ipaddress' />" +
                    "<attribute name='cvt_componentid' />" +
                  "</entity>" +
                "</fetch>";
            break;
    }
    return fetchXml;
};

MCS.cvt_StagingComponent.AddLookupView = function () {
    if (Xrm.Page.getAttribute("cvt_serialnumber").getValue() == null)
        return;
    var serialNumber = Xrm.Page.getAttribute("cvt_serialnumber").getValue();
    var viewId = Xrm.Page.data.entity.getId() != null ? Xrm.Page.data.entity.getId() : MCS.cvt_Common.BlankGUID;
    var componentlayoutXml = "<grid name='resultset' object='10000' jump='cvt_name' select='1' icon='1' preview='1' >" +
                                  "<row name='result' id='cvt_componentid' >" +
                                    "<cell name='cvt_componenttype' width='150' />" +
                                    "<cell name='a_2c7b6fee1868e3119e2500155d559835.mcs_relatedsiteid' width='100' disableSorting='1' />" +
                                    "<cell name='cvt_relatedresourceid' width='150' />" +
                                    "<cell name='cvt_parentresourceidentifier' width='100' />" +
                                    "<cell name='cvt_manufacturerid' width='150' />" +
                                    "<cell name='cvt_modelnumber' width='150' />" +
                                    "<cell name='cvt_serialnumber' width='100' />" +
                                    "<cell name='cvt_ipaddress' width='100' />" +
                                    "<cell name='cvt_eenumber' width='100' />" +
                                    "<cell name='cvt_tmssystemname' width='100' />" +
                                    "<cell name='cvt_tmsid' width='100' />" +
                                    "<cell name='cvt_e164alias' width='100' />" +
                                    "<cell name='a_2c7b6fee1868e3119e2500155d559835.cvt_relateduser' width='100' disableSorting='1' />" +
                                  "</row>" +
                                "</grid>";
    var fetch = MCS.cvt_StagingComponent.GetFetchXML("cvt_component", serialNumber);
    Xrm.Page.ui.controls.get("cvt_connectedcomponentid").addCustomView(viewId, "cvt_component", "Components that match the serial number", fetch, componentlayoutXml, true);

};
