﻿//If the SDK namespace object is not defined, create it.
if (typeof (MCS) == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;
MCS.Patient = {};

MCS.Patient.FormOnload = function () {
    MCS.Patient.SetCommunicationFieldsVisibility();
    Xrm.Page.getAttribute("cvt_tablettype").addOnChange(MCS.Patient.SetCommunicationFieldsVisibility);
    Xrm.Page.getAttribute("donotemail").addOnChange(MCS.Patient.DoNotEmailOnChange);
};

MCS.Patient.SetCommunicationFieldsVisibility = function () {
    //Set Default Visibility
    var sipAddress = Xrm.Page.getControl("cvt_bltablet");
    sipAddress.setVisible(false);
    sipAddress.setRequiredLevel("none");
    var email = Xrm.Page.getControl("emailaddress1");
    email.setVisible(false);
    email.setRequiredLevel("none");
    var donotemail = Xrm.Page.getControl("donotemail");
    donotemail.setVisible(false);
    donotemail.setRequiredLevel("none");
    var staticvmrlinkControl = Xrm.Page.getControl("cvt_staticvmrlink");
    staticvmrlinkControl.setVisible(false);
    staticvmrlinkControl.setRequiredLevel("none");

    var techType = Xrm.Page.getAttribute("cvt_tablettype").getValue();
    switch (techType) {
        case 917290000: //CVT Tablet
        case 917290001: //COTS Tablet
            var sipAddress = Xrm.Page.getControl("cvt_bltablet");
            sipAddress.setVisible(true);
            sipAddress.setRequiredLevel("required");
            break;
        case 917290002: //VA Issued iOS Device
            var donotemail = Xrm.Page.getControl("donotemail");
            donotemail.setVisible(true);
            donotemail.setRequiredLevel("required");
            MCS.Patient.DoNotEmailOnChange();
            break;
        case 917290003: //Personal VA Video Connect Device
            var email = Xrm.Page.getControl("emailaddress1");
            email.setVisible(true);
            email.setRequiredLevel("required");
            break;
    }
};

MCS.Patient.DoNotEmailOnChange = function () {
    var donotemail = Xrm.Page.getAttribute("donotemail").getValue();
        var staticvmrlinkControl = Xrm.Page.getControl("cvt_staticvmrlink");
        staticvmrlinkControl.setVisible(donotemail);
        staticvmrlinkControl.setRequiredLevel(donotemail ? "required" : "none");

        var email = Xrm.Page.getControl("emailaddress1");
        email.setVisible(!donotemail);
        email.setRequiredLevel(donotemail ? "none" : "required");
};