﻿//Establish the Namespace if it doesnt already exist
if (typeof GetConsultsForPatient == "undefined")
    GetConsultsForPatient = {};

if (typeof parent.Xrm != "undefined")
    Xrm = parent.Xrm;

if (typeof MCS == "undefined" && typeof parent.MCS != "undefined")
    MCS = parent.MCS;

GetConsultsForPatient.Rows = [];
GetConsultsForPatient.SeeMore = '<font color="blue"> See More</font>';
GetConsultsForPatient.SeeLess = '<font color="blue"> See Less</font>';

var TsaProviderSiteId;
var TsaPatientSiteId;

GetConsultsForPatient.HookToCrmPage = function () {
    Xrm.Page.getAttribute("cvt_rungetconsults").addOnChange(GetConsultsForPatient.RetrieveConsults);

};

GetConsultsForPatient.RefreshResults = function () {
    var error = $("#errorDetails").text();
    if (error.indexOf("queryBean.provider.userId value has expired") != -1) {
        if (parent.MCS.VIALogin.IsValidSamlToken())
            Xrm.Page.getAttribute("cvt_samltoken").fireOnChange();
        else
            parent.MCS.VIALogin.Saml();
    }
    else
        GetConsultsForPatient.RetrieveConsults();
};

GetConsultsForPatient.FilterResults = function () {
    var filterVal = $('#FilterOption').val();
    var rowVisibility = (filterVal == "P") ? "display:none" : "";
    $('tr[ConsultType="NP"]').attr("style", rowVisibility);
};

GetConsultsForPatient.FilterTypeResults = function () {
    var filterVal = $('#FilterType').val();
    if (filterVal == "RTC") {
        $("#ConsultResultsGrid").hide();
        $("#RtcResultsGrid").show();
        document.getElementById("FilterOption").disabled = true;
    }
    else {
        $("#ConsultResultsGrid").show();
        $("#RtcResultsGrid").hide();
        document.getElementById("FilterOption").disabled = false;
    }
};

GetConsultsForPatient.RetrieveConsults = function () {
    var group = Xrm.Page.getAttribute("mcs_groupappointment");
    if (group != null && group.getValue() != null && group.getValue())
        return;
    if (!GetConsultsForPatient.CheckVistaSwitches())
        return;

    GetConsultsForPatient.HideAll();

    Xrm.Page.ui.tabs.get('tab_9').setVisible(true);
    var isHomeMobile = Xrm.Page.getAttribute("cvt_type").getValue();
    var isSft = false;
    var sftObj = Xrm.Page.getAttribute("cvt_telehealthmodality");
    isSft = sftObj != null ? sftObj.getValue() : false;

    Xrm.Page.getControl("cvt_proconsultien").setVisible(!isSft);
    Xrm.Page.getControl("cvt_prortcid").setVisible(!isSft);
    Xrm.Page.getControl("cvt_rtcparentprovider").setVisible(!isSft);
    Xrm.Page.getControl("cvt_patconsultien").setVisible(!isHomeMobile);
    Xrm.Page.getControl("cvt_patrtcid").setVisible(!isHomeMobile);
    Xrm.Page.getControl("cvt_rtcparentpatient").setVisible(!isHomeMobile);

    var patient = null;
    var patients = Xrm.Page.getAttribute("customers").getValue();
    if (patients != null)
        patient = patients[0].id;
    var patSiteObj = Xrm.Page.getAttribute("mcs_relatedsite");
    var patSite = patSiteObj != null && patSiteObj.getValue() != null ? patSiteObj.getValue()[0].id : null;
    var proSiteObj = Xrm.Page.getAttribute("mcs_relatedprovidersite");
    var proSite = proSiteObj != null && proSiteObj.getValue() != null ? proSiteObj.getValue()[0].id : null;

    //Fallbacks making use of TSA OData Query from Switch Statement in case form fields aren't populated
    if (proSite == null)
        proSite = TsaProviderSiteId;
    if (patSite == null)
        patSite = TsaPatientSiteId;
    if (patient != null && Xrm.Page.getAttribute("cvt_relatedschedulingpackage") != null && Xrm.Page.getAttribute("cvt_relatedschedulingpackage").getValue() != null) {
        $("#msgBoxWorking").show();

        var data = GetConsultsForPatient.CallIntegration(patient, proSite, patSite, isHomeMobile, isSft);
        if (data != null)
            GetConsultsForPatient.DisplayResults(data);
    }
    else {
        var message = "";
        if (patient == null)
            message = "There is no patient selected, please select a SP before selecting the patient consult";
        if (Xrm.Page.getAttribute("cvt_relatedschedulingpackage") == null || Xrm.Page.getAttribute("cvt_relatedschedulingpackage").getValue() == null)
            message = "There is no SP selected, please select a SP before selecting the patient's consult";
        GetConsultsForPatient.ShowWarningMessage(message);
    }
};

GetConsultsForPatient.CallIntegration = function (patientId, providerSiteId, patientSiteId, isHomeMobile, isSft) {
    //Determine whether to use Action or OData call to CRME_RetrieveMultiplePostStageRunner (like person search)
    var patDuz = Xrm.Page.getAttribute("cvt_patuserduz").getValue();
    var proDuz = Xrm.Page.getAttribute("cvt_prouserduz").getValue();
    var filter = "cvt_IntegrationType/Value eq 917290001";
    if (patientId != null)
        filter += " and crme_ContactId eq '" + patientId + "'";
    if (patientSiteId != null)
        filter += " and cvt_PatientSiteId eq '" + patientSiteId + "'";
    if (providerSiteId != null)
        filter += " and cvt_ProviderSiteId eq '" + providerSiteId + "'";
    filter += " and cvt_isSft eq '" + isSft.toString() + "'";
    filter += " and cvt_isHomeMobile eq '" + isHomeMobile.toString() + "'";
    if (patDuz != null)
        filter += " and cvt_PatUserDuz eq '" + patDuz + "'";
    if (proDuz != null)
        filter += " and cvt_ProUserDuz eq '" + proDuz + "'";
    var integrationResults = null;
    CrmRestKit.ByQuery("crme_person", ['cvt_ConsultTitle', 'cvt_ConsultIEN', 'cvt_ConsultStatus', 'cvt_ConsultTimestamp', 'cvt_ClinicallyIndicatedDate', 'cvt_isSft', 'cvt_isHomeMobile', 'crme_url', 'cvt_ConsultText', 'cvt_ConsultType', 'cvt_RtcId', 'cvt_RtcRequestDateTime', 'cvt_ClinicIen', 'cvt_ClinicName', 'cvt_StopCodes', 'cvt_Provider', 'cvt_Comments', 'cvt_numberofappointments', 'cvt_interval', 'cvt_rtcparent'], filter, true).
        done(function (data) {
            if (data != null && data.d != null && data.d.results != null) {
                var results = data.d.results;
                if (results.length == 0 || results.length == 1) {
                    $("#msgBoxWorking").hide();
                    GetConsultsForPatient.ShowWarningMessage("No Consults/Return to Clinics were found");
                }
                else {
                    integrationResults = results;
                    GetConsultsForPatient.DisplayResults(results);
                }
            }
            return null;
        }
        ).fail(function (err) {
            var friendlyError = "Failure in Get Consults/Return to Clinics For Patient: " + parent.MCS.cvt_Common.RestError(err);
            $("#msgBoxWorking").hide();
            GetConsultsForPatient.ShowErrorMessage(friendlyError);
            return null;
        });
    return integrationResults;
};

GetConsultsForPatient.DisplayResults = function (data) {
    var consultResultsTable = $("#ConsultResultsTable");
    consultResultsTable.find("thead, tr, th").remove();
    consultResultsTable.find("tr:gt(0)").remove();

    var rtcResultsTable = $("#RtcResultsTable");
    rtcResultsTable.find("thead, tr, th").remove();
    rtcResultsTable.find("tr:gt(0)").remove();

    if (data != null && data.length > 0) {
        var error = GetConsultsForPatient.Failure(data);
        if (error != "") {
            GetConsultsForPatient.ShowErrorMessage(error);
            return;
        }
        //Todo:Show/Hide Tables based on the optionSet Selection
        GetConsultsForPatient.BindConsultsResults(consultResultsTable, data);
        GetConsultsForPatient.BindReturnToClinicsResults(rtcResultsTable, data);
    }
    else {
        $("#warningDetails").text("");
        $("#warningDetails").append("No Consults/Return To Clinics were found for this station");
        $("#msgBoxNoDataReturned").show();
    }
    $("#msgBoxWorking").hide();
};

GetConsultsForPatient.SetConsultValues = function (selectedRow) {
    document.getElementById("FilterType").disabled = true;
    document.getElementById("RefreshButton").disabled = true;

    var ien = selectedRow.getAttribute("cvt_ConsultIEN");
    var location = selectedRow.getAttribute("location").toLowerCase();

    if (location == "patient")
        Xrm.Page.getAttribute("cvt_patconsultien").setValue(ien);
    else
        Xrm.Page.getAttribute("cvt_proconsultien").setValue(ien);

    $("#selectedConsult").append("<br/>Added Consult with IEN: " + ien + " to appointment booking on " + location + " side.");
    $("#informUserConsultAdded").show();

    GetConsultsForPatient.RemoveOtherConsultsFromSameLocation(selectedRow.parentElement, selectedRow);
};

GetConsultsForPatient.ShowErrorMessage = function (errorMessage) {
    $("#errorDetails").text("");
    $("#errorDetails").append(errorMessage);

    $("#msgBoxSearchResultError").show();
    $("#msfBoxSearchResultError").focus();
};

GetConsultsForPatient.ShowWarningMessage = function (message) {
    $("#warningDetails").text("");
    $("#warningDetails").append(message);

    $("#msgBoxNoDataReturned").show();
};

GetConsultsForPatient.HideAll = function () {
    $("#msgBoxNoDataReturned").hide();
    $("#ConsultResultsGrid").hide();
    $("#RtcResultsGrid").hide();
    $("#msgBoxSearchResultError").hide();
    $("#msgBoxFailedValidation").hide();
    $("#msgBoxWorking").hide();
};

GetConsultsForPatient.GetRtcValues = function (data, row, counter) {
    var rtcId = data.cvt_RtcId;
    row.setAttribute("cvt_RtcId", rtcId);

    var rtcParent = data.cvt_rtcparent;
    row.setAttribute("cvt_rtcparent", rtcParent);

    var ien = data.cvt_ClinicIen;
    row.setAttribute("cvt_ClinicIen", ien);

    var rtcRequestDateTime = data.cvt_RtcRequestDateTime;
    row.setAttribute("cvt_RtcRequestDateTime", rtcRequestDateTime);

    var clinicallyIndicatedDate = data.cvt_ClinicallyIndicatedDate;
    row.setAttribute("cvt_ClinicallyIndicatedDate", clinicallyIndicatedDate);

    var clinicName = data.cvt_ClinicName;
    row.setAttribute("cvt_ClinicName", clinicName);

    var stopCodes = data.cvt_StopCodes;
    row.setAttribute("cvt_StopCodes", stopCodes);

    var provider = data.cvt_Provider;
    row.setAttribute("cvt_Provider", provider);

    var comments = data.cvt_Comments;
    row.setAttribute("cvt_Comments", comments);

    var side = data.crme_url;
    row.setAttribute("location", side);

    row.setAttribute("status", "less");

    var formattedCid = 'Not Available';
    var consultCid = new Date(clinicallyIndicatedDate);
    if (consultCid != null && consultCid != undefined)
        formattedCid = (consultCid.getMonth() + 1) + '/' + consultCid.getDate() + '/' + consultCid.getFullYear();

    var rtcRequestedFormattedDate = 'Not Available';
    var rtcRequestDate = new Date(rtcRequestDateTime);
    if (rtcRequestDate != null && rtcRequestDate != undefined)
        rtcRequestedFormattedDate = (rtcRequestDate.getMonth() + 1) + '/' + rtcRequestDate.getDate() + '/' + rtcRequestDate.getFullYear();

    return [rtcId, rtcRequestedFormattedDate, formattedCid, ien, clinicName, stopCodes, provider, comments, side];
};

GetConsultsForPatient.GetValues = function (data, row, counter) {
    var title = data.cvt_ConsultTitle;
    row.setAttribute("cvt_ConsultTitle", title);

    var ien = data.cvt_ConsultIEN;
    row.setAttribute("cvt_ConsultIEN", ien);

    var consultCreatedOn = data.cvt_ConsultTimestamp;
    row.setAttribute("cvt_ConsultTimestamp", consultCreatedOn);

    var clinicallyIndicatedDate = data.cvt_ClinicallyIndicatedDate;
    row.setAttribute("cvt_ClinicallyIndicatedDate", clinicallyIndicatedDate);

    var status = data.cvt_ConsultStatus;
    row.setAttribute("cvt_ConsultStatus", status);
    if (status != "Pending") {
        var filterVal = $('#FilterOption').val();
        if (filterVal == "P")
            row.setAttribute("style", "display:none");

        row.setAttribute("ConsultType", "NP");
    }

    var side = data.crme_url;
    row.setAttribute("location", side);

    row.setAttribute("status", "less");

    var formattedCid = 'Not Available';
    var consultCid = new Date(clinicallyIndicatedDate);
    if (consultCid != null && consultCid != undefined)
        formattedCid = (consultCid.getMonth() + 1) + '/' + consultCid.getDate() + '/' + consultCid.getFullYear();

    var formattedTimeStamp = 'Not Available';
    var consultCreatedDate = new Date(consultCreatedOn);
    if (consultCreatedDate != null && consultCreatedDate != undefined)
        formattedTimeStamp = (consultCreatedDate.getMonth() + 1) + '/' + consultCreatedDate.getDate() + '/' + consultCreatedDate.getFullYear();

    return [title.toLowerCase(), ien, formattedTimeStamp, formattedCid, status, side];
};

GetConsultsForPatient.SetUserDuzs = function (data) {
    var patDuz = data[0].cvt_ConsultIEN; //arbitrarily re-purposing consult IEN for pat side user duz in plugin
    var proDuz = data[0].cvt_ConsultText; //arbitrarily re-purposing consult text for pro side user duz in plugin
    var patFieldObj = parent.Xrm.Page.getAttribute("cvt_patuserduz");
    var proFieldObj = parent.Xrm.Page.getAttribute("cvt_prouserduz");
    if (patFieldObj.getValue() != null)
        patFieldObj.setValue(patDuz);
    if (proFieldObj.getValue() != null)
        proFieldObj.setValue(proDuz);
    patFieldObj.setSubmitMode("always");
    proFieldObj.setSubmitMode("always");
};

GetConsultsForPatient.ToggleText = function (cell, row) {
    if (row.getAttribute("status") == "less") {
        cell.innerHTML = row.getAttribute("cvt_ConsultText");
        cell.innerHTML += GetConsultsForPatient.SeeLess;
        row.setAttribute("status", "more");
    } else if (row.getAttribute("status") == "more") {
        cell.innerHTML = row.getAttribute("displayText");
        cell.innerHTML += GetConsultsForPatient.SeeMore;
        row.setAttribute("status", "less");
    }
};

GetConsultsForPatient.Failure = function (data) {
    var errorMessage = "";
    for (var i = 0; i < data.length; i++) {
        if (data[i].crme_url == "fail")
            errorMessage = data[i].cvt_ConsultTitle;
    }
    return errorMessage;
};

GetConsultsForPatient.RemoveOtherConsultsFromSameLocation = function (table, row) {
    var isProvider = row.getAttribute("location").toLowerCase() == "provider";
    var tableRows = table.children;
    //Skip header row, start with row index 1; use decrementer if a row has been removed to cancel out the table size change
    for (var i = 1; i < tableRows.length; i++) {
        var rowLocation = tableRows[i].getAttribute("location");
        if (isProvider) {
            if (rowLocation.toLowerCase() == "provider") {
                table.deleteRow(i--);
            }
        }
        else {
            if (rowLocation.toLowerCase() == "patient") {
                table.deleteRow(i--);
            }
        }
    }
};

GetConsultsForPatient.CheckVistaSwitches = function () {
    var vistaSwitchesConfig = true;
    var baseSwitchConfig = true;
    var hmConfig = true;
    var ifcConfig = true;
    var singleNonHmConfig = true;
    var filter = "mcs_name eq 'Active Settings'";
    calls = CrmRestKit.ByQuery("mcs_setting", ['cvt_UseVistaIntegration', 'cvt_UseVVSHomeMobile', 'cvt_UseVVSInterfacility', 'cvt_UseVVSSingleEncounterNonHomeMobile'], filter, false);
    calls.fail(function (err) {
        return vistaSwitchesConfig;
    }).done(function (data) {
        if (data && data.d && data.d.results != null && data.d.results.length != 0) {
            var record = data.d.results[0];
            baseSwitchConfig = record.cvt_UseVistaIntegration != null ? record.cvt_UseVistaIntegration : true;
            hmConfig = record.cvt_UseVVSHomeMobile != null ? record.cvt_UseVVSHomeMobile : true;
            ifcConfig = record.cvt_UseVVSInterfacility != null ? record.cvt_UseVVSInterfacility : true;
            singleNonHmConfig = record.cvt_UseVVSSingleEncounterNonHomeMobile != null ? record.cvt_UseVVSSingleEncounterNonHomeMobile : true;
        }
    });
    //Note that this is a triple equal, not a double, so a null value is considered acceptable to continue, only a false will mean "don't show Get Consults"
    if (baseSwitchConfig === false)
        return false;

    if (typeof Xrm != "undefined")
        return MCS.VIALogin.AppointmentTypeSwitchCheck(hmConfig, ifcConfig, singleNonHmConfig, Xrm);
    else
        return MCS.VIALogin.AppointmentTypeSwitchCheck(hmConfig, ifcConfig, singleNonHmConfig, parent.Xrm);
};

GetConsultsForPatient.AppointmentTypeSwitchCheck = function (hmConfig, ifcConfig, singleNonHmConfig, Xrm) {
    var tsaObj = Xrm.Page.getAttribute("cvt_relatedschedulingpackage").getValue();
    if (tsaObj == null)
        return false;
    var tsaId = tsaObj[0].id;
    var patFacId = null;
    var proFacId = null;
    var subSpecialty = null;
    var specialty = null;
    var isInterFacility = false;
    CrmRestKit.Retrieve('mcs_resourcepackage', tsaId, ['cvt_specialty', 'cvt_specialtysubtype'], false)
        .fail(function (err) {
            alert("failed TSA check, defaulting to display Consults" + MCS.cvt_Common.RestError(err));
        })
        .done(function (data) {
            if (data != null && data.d != null) {
                //if (data.d.cvt_PatientFacility != null)
                //    patFacId = data.d.cvt_PatientFacility.Id;
                //if (data.d.cvt_ProviderFacility != null)
                //    proFacId = data.d.cvt_ProviderFacility.Id;
                //if (data.d.cvt_ServiceScope != null)
                //    isInterFacility = data.d.cvt_ServiceScope.Value == 917290000;
                if (data.d.cvt_servicetype != null)
                    specialty = data.d.cvt_specialty.Id;
                if (data.d.cvt_servicesubtype != null)
                    subSpecialty = data.d.cvt_specialtysubtype.Id;
                //if (data.d.cvt_relatedprovidersiteid != null)
                //    TsaProviderSiteId = data.d.cvt_relatedprovidersiteid.Id; //This is key to run each time TSA is set because the Provider Site does not come through until after TSA js has run, but this function runs before TSA js is complete, so pulling in TSAProviderSiteId will set providerSiteId when its not otherwise populated
                //if (data.d.cvt_relatedprovidersiteid != null)
                //    TsaPatientSiteId = data.d.cvt_relatedpatientsiteid.Id;
            }
        });

    var isHomeMobile = Xrm.Page.getAttribute("cvt_type").getValue();
    if (isHomeMobile)
        return hmConfig;
    var isSingleNonHm = Xrm.Page.getAttribute("cvt_telehealthmodality").getValue();
    if (isSingleNonHm)
        return singleNonHmConfig;

    var subSpecialtySwitch = null;
    if (subSpecialty != null) {
        //Check SubSpecialty Switch
        CrmRestKit.Retrieve('mcs_servicesubtype', subSpecialty, ['cvt_UseVVS'], false)
            .fail(function (err) {
                alert("failed sub-specialty type check, looking for specialty switch" + MCS.cvt_Common.RestError(err));
            }).done(function (data) {
                subSpecialtySwitch = data.d.cvt_UseVVS;
            });
    }
    //various "===" is so that if the value is null, then we evaluate the next condition instead of considering it false
    if (subSpecialtySwitch === false)
        return false;
    var specialtySwitch = true;
    if (subSpecialtySwitch == null) {
        CrmRestKit.Retrieve('mcs_servicetype', specialty, ['cvt_UseVVS'], false)
            .fail(function (err) {
                alert("failed specialty type check, defaulting to display Consults" + MCS.cvt_Common.RestError(err));
            })
            .done(function (data) {
                specialtySwitch = data.d.cvt_UseVVS;
            });
    }
    if (specialtySwitch === false)
        return false;

    if (isInterFacility)
        return ifcConfig;

    var facilitySwitch = true;

    if (patFacId != null && proFacId != null && patFacId == proFacId) {
        CrmRestKit.Retrieve('mcs_facility', patFacId, ['cvt_UseVistaIntrafacility'], false)
            .fail(function (err) {
                alert("failed Intrafacility check, defaulting to display Consults" + MCS.cvt_Common.RestError(err));
            })
            .done(function (data) {
                if (data != null && data.d != null)
                    facilitySwitch = data.d.cvt_UseVistaIntrafacility != null ? data.d.cvt_UseVistaIntrafacility : true;
            });
    }
    return facilitySwitch === false ? false : true;
};

GetConsultsForPatient.BindConsultsResults = function (consultResultsTable, data) {
    var filterVal = $('#FilterType').val();
    if (filterVal == "Consult") {
        $("#ConsultResultsGrid").show();
        $("#RtcResultsGrid").hide();
    }

    var consultTableHeaders = ['Title', 'IEN', 'Consult Created Date', 'Clinically Indicated Date', 'Status', 'Location']; //'Text',
    var thead = document.createElement('tr');
    for (var i = 0; i < consultTableHeaders.length; i++) {
        var th = document.createElement('th');
        th.className = "grid_title_left";
        th.appendChild(document.createTextNode(consultTableHeaders[i]));
        th.id = "th_" + consultTableHeaders[i].replace(' ', '');
        th.title = consultTableHeaders[i];
        if (consultTableHeaders[i] == "Text") {
            th.style = "display:none";
        }
        th.scope = "col";
        thead.appendChild(th);
    }
    consultResultsTable.append(thead);
    GetConsultsForPatient.SetUserDuzs(data);
    //Skip first row because it has been re-purposed to pass across the Pat and Pro User Duz so user only logs in 1x during GetConsults, then login is re-used during make appointment
    for (var i = 1; i < data.length; i++) {
        if (data[i].cvt_ConsultType == true) {
            var row = document.createElement('tr');
            row.id = i;
            var crmValues = GetConsultsForPatient.GetValues(data[i], row, i);
            for (var j = 0; j < consultTableHeaders.length; j++) {
                var td;
                if (j == 0) {
                    td = document.createElement('th');
                    td.scope = "row";
                    td.className = "th_row_left";
                }
                else {
                    td = document.createElement('td');
                }
                td.id = "th_" + i + "_" + j + "_" + consultTableHeaders[j].replace(' ', '');
                td.title = crmValues[j];

                td.appendChild(document.createTextNode(crmValues[j]));

                row.appendChild(td);
            }
            row.className = "grid_row_left";
            row.ondblclick = function () { GetConsultsForPatient.SetConsultValues(this); };
            consultResultsTable.append(row);
        }
    }
    //force focus to message
    consultResultsTable.focus();
}

//Todo: Review and refactor this method
GetConsultsForPatient.BindReturnToClinicsResults = function (rtcResultsTable, data) {
    var filterVal = $('#FilterType').val();
    if (filterVal != "Consult") {
        $("#RtcResultsGrid").show();
        $("#ConsultResultsGrid").hide();
    }

    var rtcTableHeaders = ['RTC ID', 'RTC Request Date', 'Clinically Indicated Date', 'Clinic IEN', 'Clinic Name', 'Stop Codes', 'Provider', 'Comments', 'Location']; //'Text',
    var thead = document.createElement('tr');
    for (var i = 0; i < rtcTableHeaders.length; i++) {
        var th = document.createElement('th');
        th.className = "grid_title_left";
        th.appendChild(document.createTextNode(rtcTableHeaders[i]));
        th.id = "th_" + rtcTableHeaders[i].replace(' ', '');
        th.title = rtcTableHeaders[i];
        th.scope = "col";
        thead.appendChild(th);
    }
    rtcResultsTable.append(thead);
    //Skip first row because it has been re-purposed to pass across the Pat and Pro User Duz so user only logs in 1x during GetConsults, then login is re-used during make appointment
    for (var i = 1; i < data.length; i++) {
        if (data[i].cvt_ConsultType != true) {
            var row = document.createElement('tr');
            row.id = i;
            var crmValues = GetConsultsForPatient.GetRtcValues(data[i], row, i);
            for (var j = 0; j < rtcTableHeaders.length; j++) {
                var td;
                if (j == 0) {
                    td = document.createElement('th');
                    td.scope = "row";
                }
                else {
                    td = document.createElement('td');
                }
                td.id = "th_" + i + "_" + j + "_" + rtcTableHeaders[j].replace(' ', '');
                td.title = crmValues[j];
                td.appendChild(document.createTextNode(crmValues[j]));

                row.appendChild(td);
            }
            row.className = "grid_row_left";
            row.ondblclick = function () { GetConsultsForPatient.SetRtcValues(this); };
            rtcResultsTable.append(row);
        }
    }
    //force focus to message
    rtcResultsTable.focus();
}

GetConsultsForPatient.SetRtcValues = function (selectedRow) {
    document.getElementById("FilterType").disabled = true;
    document.getElementById("RefreshButton").disabled = true;

    var rtcId = selectedRow.getAttribute("cvt_RtcId");
    var rtcParent = selectedRow.getAttribute("cvt_rtcparent");
    var location = selectedRow.getAttribute("location").toLowerCase();

    if (location == "patient") {
        Xrm.Page.getAttribute("cvt_patrtcid").setValue(rtcId);
        Xrm.Page.getAttribute("cvt_rtcparentpatient").setValue(rtcParent);
    }    else {
        Xrm.Page.getAttribute("cvt_prortcid").setValue(rtcId);
        Xrm.Page.getAttribute("cvt_rtcparentprovider").setValue(rtcParent);
    }

    $("#selectedConsult").append("<br/>Added Return to Clinic with RTC Id: " + rtcId + " to appointment booking on " + location + " side.");
    $("#informUserConsultAdded").show();

    GetConsultsForPatient.RemoveOtherConsultsFromSameLocation(selectedRow.parentElement, selectedRow);
};