﻿if (typeof MCS == "undefined")
    MCS = {};


if (typeof MCS.VIALogin == "undefined")
    MCS.VIALogin = {};

//Variables
{
    MCS.VIALogin.KeepAliveWindowName = "crmssoi";
    MCS.VIALogin.Refreshes = 0;

    MCS.VIALogin.patFacilityNumber = null;
    MCS.VIALogin.proFacilityNumber = null;
    MCS.VIALogin.currentUser = null;
    MCS.VIALogin.SamlString = "";
    MCS.VIALogin.DuzRecord = null;
    
    MCS.VIALogin.FakeSAML = "";
    MCS.VIALogin.TestingAV = ""; //pro or pat

    MCS.VIALogin.isGrpClinicappt = false;
	MCS.VIALogin.isBlockResource = false;
    MCS.VIALogin.IsCancelServiceActivityInProgress = false;
}

MCS.VIALogin.LoginButton = function () {
    MCS.VIALogin.Login();
};

MCS.VIALogin.LoginOnCancelAppointment = function () {
    MCS.VIALogin.IsCancelServiceActivityInProgress = true;
    MCS.VIALogin.Login();
    MCS.VIALogin.IsCancelServiceActivityInProgress = false;
};
MCS.VIALogin.Login = function () {
    MCS.VIALogin.ToggleButton(false);
    MCS.VIALogin.hideAll(); 

    //Does User have a Valid SAML token on user form
    if (MCS.VIALogin.IsValidSamlToken()) { //SAML Token passes - Does User have a Valid DUZ
        if (MCS.VIALogin.IsValidUserDuz()) { //Success, so untoggle button and Trigger Get Consults
            MCS.VIALogin.ToggleButton(true);
            MCS.VIALogin.TriggerGetConsults();
        }
        else { //Not a Valid User Duz, Need to get Duz
            MCS.VIALogin.ViaLoginVimt();
            //setTimeout(function () { MCS.VIALogin.Login(); }, 1000);          
        }
    }
    else{ //OR get new token - which calls this function again
        if (!MCS.VIALogin.isGrpClinicappt || MCS.VIALogin.IsCancelServiceActivityInProgress){
        MCS.VIALogin.Saml();  
		}
	}
};

// ************************************************SAML Functions****************************************************
{

    



    //SAML: 1. Determine if the SAML on the User's record is still active
    //Return True or False
    MCS.VIALogin.IsValidSamlToken = function () {
        if (typeof Xrm.Page.ui == "undefined" || Xrm.Page.ui == null)
            Xrm = parent.Xrm;

        var typeCode = Xrm.Page.context.getQueryStringParameters().etc;

		if(typeCode == 4214 && (!Xrm.Page.getAttribute("cvt_type").getValue() && Xrm.Page.getAttribute("mcs_groupappointment").getValue())){
			MCS.VIALogin.isGrpClinicappt = true;
		}
//		else if(typeCode==4201){
//		    MCS.VIALogin.isBlockResource=true;
//		}
		else{
			MCS.VIALogin.isGrpClinicappt = false;
		}

        if (!MCS.VIALogin.RunVistaIntegration()) {
            MCS.VIALogin.ToggleIcon("SAML", "failure", "VistA Integration not turned on.");
            return true;

        }
        else if (MCS.VIALogin.isGrpClinicappt && !MCS.VIALogin.IsCancelServiceActivityInProgress)
		{
		     MCS.VIALogin.ToggleIcon("SAML", "success", "VistA Integration not required at this stage.");
			 return false;
		}

        MCS.VIALogin.ToggleIcon("SAML", "working", "Checking for valid token.");
        MCS.VIALogin.RetrieveUserSAMLToken();

        if (MCS.VIALogin.SamlString == "") //No token
        {
            MCS.VIALogin.ToggleIcon("SAML", "failure", "No Token found.");
            return false;
        }

        var errorTag = MCS.VIALogin.SamlString.indexOf("<wst:Reason>");
        if (errorTag != -1) //Errored Token
        {
            MCS.VIALogin.ToggleIcon("SAML", "failure", "Check failed: Token has error.");
            return false;

        }
        var endTimeIndex = MCS.VIALogin.SamlString.indexOf("NotOnOrAfter");
        if (endTimeIndex != -1) {
            var endTimeString = MCS.VIALogin.SamlString.substring(endTimeIndex + "NotOnOrAfter".length + 2, endTimeIndex + "NotOnOrAfter".length + 2 + 20);
            var end = new Date(endTimeString).getTime();

            if (isNaN(end)) {
                MCS.VIALogin.ToggleIcon("SAML", "failure", "Check failed: Expiration Date could not be parsed.");
                return false;
            }

            //Note: VA computer clocks are controlled by IT, so it should be safe to assume that clocks are close enough to accurate that this is a safe way to check
            //Should we make sure the SAML is active for longer than end-30 second?
            if (new Date().getTime() + 1000 * 30 > end) {//Inactive token, or token will be inactive in 30 seconds, so consider it expired
                MCS.VIALogin.ToggleIcon("SAML", "failure", "Check failed: Token is expired.");
                return false;
            }
            else //Valid token that doesnt expire for at least 30 seconds from now            
            {
                MCS.VIALogin.ToggleIcon("SAML", "success", "Check passed: Token is valid.");
                return true;
            }
        }
        else //Invalid Token - all valid tokens must contain the NotOnOrAfter token
        {
            MCS.VIALogin.ToggleIcon("SAML", "failure", "Check failed: Token missing expiration time.");
            return false;
        }
    };

    //SAML: 1A. Gets SAML from User's record 
    //Sets global variable to SAML token or "" if not found 
    MCS.VIALogin.RetrieveUserSAMLToken = function () {
        if (MCS.VIALogin.currentUser == null) {
            if (typeof Xrm != "undefined")
                MCS.VIALogin.currentUser = Xrm.Page.context.getUserId();
            else
                MCS.VIALogin.currentUser = parent.Xrm.Page.context.getUserId();
        }
        CrmRestKit.Retrieve('SystemUser', MCS.VIALogin.currentUser, ['SystemUserId', 'FullName', 'cvt_SAMLToken'], false).fail(
            function (err2) {               
                MCS.VIALogin.SamlString = "";
                MCS.VIALogin.ToggleIcon("SAML", "failure", "Error on User Retrieve: Unable to get user's record.");
            }).done(
            function (user) {
                //return the SAML token
                if (user != null && user.d != null && user.d.cvt_SAMLToken != null) {
                    var samlString = user.d.cvt_SAMLToken;
                    MCS.VIALogin.SamlString = samlString;
                    MCS.VIALogin.ToggleIcon("SAML", "success", "Success on User Retrieve: SAML Token on user's record.");
                }
                else {
                    MCS.VIALogin.SamlString = "";
                    MCS.VIALogin.ToggleIcon("SAML", "working", "Success on User Retrieve: No SAML Token on user's record. Attempting to get new SAML.");
                }
            });
    };

    //Updates SAML token on User's record
    //Called from IAM, KeepAlive or Fakes functions
    MCS.VIALogin.UpdateUserSAMLToken = function (saml) {

        if (MCS.VIALogin.currentUser == null) {
            if (typeof Xrm != "undefined")
                MCS.VIALogin.currentUser = Xrm.Page.context.getUserId();
            else
                MCS.VIALogin.currentUser = parent.Xrm.Page.context.getUserId();
        }

        var userRecord = {
            'cvt_SAMLToken': saml
        };

        CrmRestKit.Update('SystemUser', MCS.VIALogin.currentUser, userRecord, false)
            .fail(function (err) {
                MCS.VIALogin.ToggleIcon("SAML", "failure", "Error Updating User SAML Information: " + MCS.cvt_Common.RestError(err));
                //alert("Error Updating User SAML Information: " + MCS.cvt_Common.RestError(err));
            }).done(function () {
                MCS.VIALogin.ToggleIcon("SAML", "success", "Successful Retrieval of new SAML Token.");
                MCS.VIALogin.Login();
            });
    };

    //Retrieves the SSOi SAML Token either through Keep Alive or through Direct IAM STS depending on which URLs are available
    //Called from Appt, BR ribbons and LoginButton
    MCS.VIALogin.Saml = function () {      
        if (!MCS.VIALogin.RunVistaIntegration()) {
            return;
        }
        else {
            var refreshUrl = MCS.VIALogin.GetKeepAliveUrl();
            var keepAliveLoginUrl = MCS.VIALogin.GetKeepAliveLoginUrl();
            var directIamUrl = MCS.VIALogin.GetStsUrl();

            if (refreshUrl != "" && keepAliveLoginUrl != "")
                MCS.VIALogin.RefreshToken();
            else if (directIamUrl != "")
                MCS.VIALogin.CallIamSts(directIamUrl);
            else {
                alert("No PIV Authentication has been set up.  Faking valid SAML Token.");

                MCS.VIALogin.UpdateFakeSAML();
                MCS.VIALogin.UpdateUserSAMLToken(MCS.VIALogin.FakeSAML);
                //MCS.VIALogin.Login();
            }
        }
    };
}
// ************************************************STS Retrieval Functions****************************************************
{
    //Update Fake SAML to tomorrow
    MCS.VIALogin.UpdateFakeSAML = function () {
        var currentTime = new Date(); //2017-11-27T19:37:26Z
        var month = (currentTime.getMonth() + 1);
        if (month < 10)
            month = "0" + month;
        var date = (currentTime.getDate() + 2);
        if (date < 10)
            date = "0" + date;
        var tomorrow = currentTime.getFullYear() + "-" + month + "-" + date;
        var fake = '<?xml version="1.0" encoding="UTF-8"?>' +
            '<soapenv:Envelope xmlns:wst="http://schemas.xmlsoap.org/ws/2005/02/trust" xmlns:wsa="http://www.w3.org/2005/08/addressing" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xmlns:xsd="http://www.w3.org/2001/XMLSchema" xmlns:soapenv="http://schemas.xmlsoap.org/soap/envelope/"><soapenv:Body><wst:RequestSecurityTokenResponse><wst:RequestedSecurityToken><saml:Assertion ID="Assertion-uuid7cf42a96-a36b-4a51-9135-bb22579a358d" Version="2.0" IssueInstant="2018-03-07T14:35:30Z" xmlns:saml="urn:oasis:names:tc:SAML:2.0:assertion"><saml:Issuer Format="urn:oasis:names:tc:SAML:2.0:assertion">https://DNS            /Issuer/SAML2</saml:Issuer><Signature xmlns="http://www.w3.org/2000/09/xmldsig#">' +
            '<SignedInfo>' +
            '  <CanonicalizationMethod Algorithm="http://www.w3.org/2001/10/xml-exc-c14n#"/>' +
            '  <SignatureMethod Algorithm="http://www.w3.org/2001/04/xmldsig-more#rsa-sha256"/>' +
            '  <Reference URI="#Assertion-uuid7cf42a96-a36b-4a51-9135-bb22579a358d">' +
            '    <Transforms>' +
            '      <Transform Algorithm="http://www.w3.org/2000/09/xmldsig#enveloped-signature"/>' +
            '      <Transform Algorithm="http://www.w3.org/2001/10/xml-exc-c14n#"/>' +
            '    </Transforms>' +
            '    <DigestMethod Algorithm="http://www.w3.org/2001/04/xmlenc#sha256"/>' +
            '    <DigestValue>gDIooXX3salmum0DQg8MSF2orJT/4+wjQbQfmDk/yVA=</DigestValue>' +
            '  </Reference>' +
            '</SignedInfo>' +
            '    <SignatureValue>P+PB9Vbn2OwocpzSHi+phJZk+XibOk4XTyo0ORplumK/2C6RKneeZRsAkCvAyW//gQWdRoepctqNIEPAesbPCqSU5z3OhD8f+rgOf5VWlAeb/rwpeenbm4Q1e1xvZ1/OjamsjrD7m5qGGVxRHLZNhp68Zq3JSuEDEmr3VP/KRKt/eFsBC5zqBUUaF5aT2duNA3hjK3/fw9NGeGlxcOIrdtEfWMWmOwSceDb8kKnDONpUHAh1915u0ARPzuTr7SZ+wSZFjYIhbP8FBgusECnA4UU7X3o05Gj1FXdpCzz+htG1SISqsa2NVswSm8FVvFEUG/UP9OAO3LpCXleX37kZ7q7nA9NaHGWwfFHd0Y3w3+Jk9u5r0nK+c6ULb5+1hoYhFaW3xH+LmjGyduHG028QX6HSnnUnidpL/FIrfD3zfRdC+H1NbxAUnvg2L3fpJCzdhgI+3Kh9OylCjN/jbdKeykHvYoxzlT+uR0hg9jl/RD21I2PBR1okovmAMnlYlarch+C3Di+7K48BMm3KAlgbl+UZMgEMVdaeklwJTHLS77ROOVqRZsLVIYMIIwrkChx7TS/DjTdzLWGtt4rApqSEtVeHllo4HrczPQbeika8glVE0YwwG2ix1JHZbviUByw+5r8OIevQ6ztvu2xivlXddqRCiLnhr8bHNDRiWwwzLjE=</SignatureValue><KeyInfo><X509Data><X509Certificate>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</X509Certificate><X509IssuerSerial><X509IssuerName>CN=VA-Internal-S2-ICA1-v1, DC=va, DC=gov</X509IssuerName><X509SerialNumber>17169973579401760</X509SerialNumber></X509IssuerSerial></X509Data></KeyInfo></Signature><saml:Subject><saml:NameID Format="urn:oasis:names:tc:SAML:2.0:nameid-format:persistent">CN=LastName\, FirstName,OU=JIT,OU=Users,OU=National Contractors,DC=vha,DC=med,DC=va,DC=gov</saml:NameID><saml:SubjectConfirmation Method="urn:oasis:names:tc:SAML:2.0:cm:sender-vouches"><saml:SubjectConfirmationData Recipient="https://DNS        .crm15.xrm.DNS   /TMP" Address="CN=LastName\, FirstName,OU=JIT,OU=Users,OU=National Contractors,DC=vha,DC=med,DC=va,DC=gov"/></saml:SubjectConfirmation></saml:Subject><saml:Conditions NotBefore="2018-03-07T14:30:30Z" NotOnOrAfter="' +
            tomorrow +
            'T14:50:30Z"><saml:AudienceRestriction><saml:Audience>https://*.DNS   /*</saml:Audience></saml:AudienceRestriction></saml:Conditions><saml:AuthnStatement AuthnInstant="2018-03-07T14:35:30Z"><saml:AuthnContext><saml:AuthnContextClassRef>urn:oasis:names:tc:SAML:2.0:ac:classes:TLSClient</saml:AuthnContextClassRef></saml:AuthnContext></saml:AuthnStatement><saml:AttributeStatement><saml:Attribute Name="transactionid" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>807743ce-f0f9-40a8-bd83-329567b0f08d</saml:AttributeValue></saml:Attribute><saml:Attribute Name="urn:va:vrm:iam:corpid" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue/></saml:Attribute><saml:Attribute Name="issueinstant" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>2018-03-07T14:35:30.849Z</saml:AttributeValue></saml:Attribute><saml:Attribute Name="authnsystem" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>SSOi</saml:AttributeValue></saml:Attribute><saml:Attribute Name="authenticationtype" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>Direct</saml:AttributeValue></saml:Attribute><saml:Attribute Name="proofingauthority" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>VA</saml:AttributeValue></saml:Attribute><saml:Attribute Name="assurancelevel" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>3</saml:AttributeValue></saml:Attribute><saml:Attribute Name="sessionScope" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>B</saml:AttributeValue></saml:Attribute><saml:Attribute Name="urn:va:vrm:iam:firstname" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>FIRSTNAME</saml:AttributeValue></saml:Attribute><saml:Attribute Name="urn:va:vrm:iam:lastname" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>LASTNAME</saml:AttributeValue></saml:Attribute><saml:Attribute Name="urn:va:vrm:iam:secid" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>1013029324</saml:AttributeValue></saml:Attribute><saml:Attribute Name="urn:va:ad:samaccountname" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>UserName</saml:AttributeValue></saml:Attribute><saml:Attribute Name="upn" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>Email@DNS   </saml:AttributeValue></saml:Attribute><saml:Attribute Name="email" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>Email@DNS   </saml:AttributeValue></saml:Attribute><saml:Attribute Name="urn:oasis:names:tc:xspa:1.0:subject:subject-id" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>FIRSTNAME LASTNAME</saml:AttributeValue></saml:Attribute><saml:Attribute Name="urn:oasis:names:tc:xspa:1.0:subject:organization" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>Department of Veterans Affairs</saml:AttributeValue></saml:Attribute><saml:Attribute Name="urn:oasis:names:tc:xspa:1.0:subject:organization-id" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>urn:oid:2.16.840.1.113883.4.349</saml:AttributeValue></saml:Attribute><saml:Attribute Name="urn:nhin:names:saml:homeCommunityId" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>urn:oid:2.16.840.1.113883.4.349</saml:AttributeValue></saml:Attribute><saml:Attribute Name="uniqueUserId"><saml:AttributeValue><SECID Name="urn:va:vrm:iam:secid">000000000</SECID></saml:AttributeValue></saml:Attribute><saml:Attribute Name="urn:va:vrm:iam:mviicn" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>1013029324V606354</saml:AttributeValue></saml:Attribute><saml:Attribute Name="urn:va:vrm:iam:vistaid" NameFormat="urn:oasis:names:tc:SAML:2.0:attrname-format:unspecified"><saml:AttributeValue>516-00000000</saml:AttributeValue><saml:AttributeValue>631-000000000</saml:AttributeValue></saml:Attribute></saml:AttributeStatement></saml:Assertion></wst:RequestedSecurityToken><wst:RequestType>http://schemas.xmlsoap.org/ws/2005/02/trust/Validate</wst:RequestType><wst:TokenType>http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV2.0</wst:TokenType><wst:Status><wst:Code>http://docs.oasis-open.org/ws-sx/ws-trust/200512/status/valid</wst:Code></wst:Status></wst:RequestSecurityTokenResponse></soapenv:Body></soapenv:Envelope>';

        MCS.VIALogin.FakeSAML = fake;
    };

    //Retrieves the Token from IAM directly
    MCS.VIALogin.CallIamSts = function (iamUrl) {
        var poststring = "<soapenv:Envelope xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:ns=\"http://docs.oasis-open.org/ws-sx/ws-trust/200512\">"
            + "<soapenv:Header/>"
            + "<soapenv:Body>"
            + "<ns:RequestSecurityToken>"
            + "<ns:Base>"
            + "<wss:TLS xmlns:wss=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd\"/>"
            + "</ns:Base>"
            + "<wsp:AppliesTo xmlns:wsp=\"http://schemas.xmlsoap.org/ws/2004/09/policy\">"
            + "<wsa:EndpointReference xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">"
            + "<wsa:Address>https://DNS        .crm15.xrm.DNS   /TMP</wsa:Address>"
            + "</wsa:EndpointReference>"
            + "</wsp:AppliesTo>"
            + "<ns:Issuer>"
            + "<wsa:Address xmlns:wsa=\"http://schemas.xmlsoap.org/ws/2004/08/addressing\">https://DNS            /Issuer/smtoken/SAML2</wsa:Address>"
            + "</ns:Issuer>"
            + "<ns:RequestType>http://schemas.xmlsoap.org/ws/2005/02/trust/Validate</ns:RequestType>"
            + "</ns:RequestSecurityToken>"
            + "</soapenv:Body>"
            + "</soapenv:Envelope>"
            ;
        url = iamUrl == null ? MCS.VIALogin.GetStsUrl() : iamUrl;
        //$.support.cors = true;
        $.get(url).done(function () {
            $.ajax({
                url: url,
                type: 'POST',
                crossDomain: true,
                data: poststring,
                contentType: 'text/plain',
                dataType: 'text',
                success: function (result) {
                    MCS.VIALogin.UpdateUserSAMLToken(result);
                    //MCS.VIALogin.Login();
                },
                error: function (jqXHR, tranStatus, errorThrown) {
                    alert("Unable to Get SAML token to log into Vista\n" +
                        'Status: ' + jqXHR.status + ' ' + jqXHR.statusText + '. ' +
                        'Response: ' + jqXHR.responseText
                    );
                }
            });
        }).fail(function (err) {
            alert("Failure to Get SAML token to log into Vista\n" +
                'Status: ' + err.status + ' ' + err.statusText + '. ' +
                'Response: ' + err.responseText
            );
        });

    };

    //Function calls the refresh endpoint and sets the resulting SAML token onto the form if the call is successful, otherwise keeps calling itself every 5 seconds
    MCS.VIALogin.RefreshToken = function () {
        MCS.VIALogin.Refreshes++;
        var url = MCS.VIALogin.GetKeepAliveUrl();
        var token = "";
        $.ajax({
            url: url,
            success: function (result) {
                if (result != null)
                    token = result.SAMLToken;
                if (token != null && token != "") {
                    MCS.VIALogin.UpdateUserSAMLToken(token);
                }
                else if (MCS.VIALogin.Refreshes == 1)
                    alert("Please login with your PIN in the new window to sign into Vista.");
            },
            error: function (request, status, error) {
                alert("Token Refresh call failed: " + request.responseText + "; info: " + request.statusText);
            },
            complete: function () {
                MCS.VIALogin.RetrieveUserSAMLToken();
                if (MCS.VIALogin.SamlString == "" && MCS.VIALogin.Refreshes < 4) {
                    setTimeout(MCS.VIALogin.RefreshToken, 15000);
                    MCS.VIALogin.KeepSessionAlive();
                }
            }

        });
    };

    //Funtion to open the Keep Alive page (if its already open, then it will just force focus to it)
    MCS.VIALogin.KeepSessionAlive = function () {
        var url = MCS.VIALogin.GetKeepAliveLoginUrl();
        ssoiWindow = window.open(url,
            MCS.VIALogin.KeepAliveWindowName,
            'height=500, width=865, location=yes, resizable=yes, scrollbars=yes, status=yes, titlebar=yes, top=100, left=100',
            true
        );
        ssoiWindow.focus();
        return;
    };

}
// ************************************************DUZ Checking Functions****************************************************
{
    //Returns T or F. //this returns false if either pat or pro is not valid.
    MCS.VIALogin.IsValidUserDuz = function () {
        if (!MCS.VIALogin.RunVistaIntegration())
            return true;

        var duzSideValue = MCS.VIALogin.DuzSide();
        var duzIsValid = true;

        //Intrafacility - so just pro
        if (duzSideValue == "both" || duzSideValue == "pro") {
            MCS.VIALogin.proFacilityNumber = MCS.VIALogin.GetFacilityNumber("pro");
            var proDuz = MCS.VIALogin.ActiveDuz(MCS.VIALogin.proFacilityNumber);
            duzIsValid = !duzIsValid ? false : proDuz != "";
            if (proDuz != "") {
                MCS.VIALogin.ToggleIcon("ProDuz", "success", "Successful retrieval of current Provider Duz: " + MCS.VIALogin.proFacilityNumber);
                if (Xrm.Page.getAttribute("cvt_prouserduz") != null)
                    Xrm.Page.getAttribute("cvt_prouserduz").setValue(proDuz);
                else if (parent.Xrm.Page.getAttribute("cvt_prouserduz") != null)
                    parent.Xrm.Page.getAttribute("cvt_prouserduz").setValue(proDuz);
            }
            else {
                MCS.VIALogin.ToggleIcon("ProDuz", "failure", "Unsuccessful retrieval of current Provider Duz: " + MCS.VIALogin.proFacilityNumber);
            }
        }
        //Interfacility or just pat

        if (duzSideValue == "both" || duzSideValue == "pat") {
            MCS.VIALogin.patFacilityNumber = MCS.VIALogin.GetFacilityNumber("pat");
            var patDuz = MCS.VIALogin.ActiveDuz(MCS.VIALogin.patFacilityNumber);
            duzIsValid = !duzIsValid ? false : patDuz != "";
            if (patDuz != "") {
                MCS.VIALogin.ToggleIcon("PatDuz", "success", "Successful retrieval of current Patient Duz: " + MCS.VIALogin.patFacilityNumber);
                if (Xrm.Page.getAttribute("cvt_patuserduz") != null)
                    Xrm.Page.getAttribute("cvt_patuserduz").setValue(proDuz);
                else if (parent.Xrm.Page.getAttribute("cvt_patuserduz") != null)
                    parent.Xrm.Page.getAttribute("cvt_patuserduz").setValue(proDuz);
            }
            else
                MCS.VIALogin.ToggleIcon("PatDuz", "failure", "Unsuccessful retrieval of current Patient Duz: " + MCS.VIALogin.patFacilityNumber);

        }
        return duzIsValid;
    };

    //Duz Supporting Functions
    //Gets Pat Pro or Both
    MCS.VIALogin.DuzSide = function () {
        if (typeof Xrm == "undefined")
            Xrm = parent.Xrm;

        var typeCode = Xrm.Page.context.getQueryStringParameters().etc;

        var runProSide = true;
        var runPatSide = true;
        if (typeCode == 4214) {
            runPatSide = Xrm.Page.getAttribute("cvt_type").getValue() == false;
            runProSide = Xrm.Page.getAttribute("cvt_telehealthmodality").getValue() == false;
        }

        if (runPatSide && runProSide)
            return "both";
        else if (runPatSide)
            return "pat";
        else if (runProSide)
            return "pro";
        else
            return null;
    };

    //Helper method to get the station number of the facility from input of "pat" or "pro"
    MCS.VIALogin.GetFacilityNumber = function (side) {

        //var tsaId = MCS.VIALogin.GetTsaId();
        var patSite = Xrm.Page.getAttribute("mcs_relatedsite").getValue();
        var proSite = Xrm.Page.getAttribute("mcs_relatedprovidersite").getValue();
        var siteId;
        if (patSite != null) {
            siteId = patSite[0].id;
        }
        else if (proSite != null) {
            siteId = proSite[0].id;
        }

        var siteFacId = null;

        CrmRestKit.Retrieve('mcs_site', siteId, ['mcs_FacilityId', 'mcs_siteId'], false)
            .fail(function (err) {
                alert("failed TMP Site check, Unable to perform VIA login: " + MCS.cvt_Common.RestError(err));
            })
            .done(function (data) {
                if (data != null && data.d != null) {
                    if (data.d.mcs_FacilityId != null)
                        siteFacId = data.d.mcs_FacilityId.Id;
                }
            });

        //var id = side == "pat" ? patFacId : proFacId;
        var facilityNumber = null;
        CrmRestKit.Retrieve('mcs_facility', siteFacId, ['mcs_StationNumber'], false)
            .fail(function (err) {
                alert("Failed to get Facility station code, Unable to Perform VIA Login: " + MCS.cvt_Common.RestError(err));
            }).done(function (data) {
                if (data != null && data.d != null)
                    facilityNumber = data.d.mcs_StationNumber;
                else
                    alert("Failed to get Facility station number, Unable to Perform VIA Login.");
            });

        return facilityNumber;
    };

    //Helper method to get the TSA id whether the current record is an appt or a block resource
    //MCS.VIALogin.GetTsaId = function () {
    //    if (typeof Xrm == "undefined")
    //        Xrm = parent.Xrm;

    //    var spObj = Xrm.Page.getAttribute("cvt_relatedschedulingpackage");
    //    if (spObj != null)
    //        return spObj.getValue()[0].id;
    //    var spId;
    //    var sa = Xrm.Page.getAttribute("cvt_serviceactivityid").getValue()[0].id;

    //    CrmRestKit.Retrieve('ServiceAppointment', sa, ['cvt_relatedschedulingpackage'], false)
    //        .fail(function (err) {
    //            alert("failed SP check, Unable to perform VIA login: " + MCS.cvt_Common.RestError(err));
    //        })
    //        .done(function (data) {
    //            if (data != null && data.d != null)
    //                spId = data.d.cvt_relatedschedulingpackage.Id;

    //        });
    //    return spId;
    //};

    //Returns the duz name or ""
    MCS.VIALogin.ActiveDuz = function (stationNumber) {
        MCS.VIALogin.GetUserDuzRecord(stationNumber, true);

        if (MCS.VIALogin.DuzRecord != null)
            return MCS.VIALogin.DuzRecord.cvt_name;
        else
            return "";
    };

    //Retrieves the actual duzRecord - sets global variable
    MCS.VIALogin.GetUserDuzRecord = function (stationNumber, isActive) {
        if (typeof Xrm == "undefined")
            Xrm = parent.Xrm;

        var varState = 0;
        if (!isActive)
            varState = 1;
        var userGUID = MCS.cvt_Common.TrimBookendBrackets(Xrm.Page.context.getUserId());
        var filter = "statecode/Value eq " + varState + " and cvt_StationNumber eq '" + stationNumber + "' and cvt_User/Id eq guid'" + userGUID + "'";
        var call = CrmRestKit.ByQuery('cvt_userduz', ['cvt_name', 'statecode', 'cvt_ExpirationDate', 'cvt_userduzId', 'cvt_StationNumber'], filter, false);
        var duzRecord = null;

        call.fail(function (err) {
            var errorMessage = MCS.cvt_Common.RestError(err);
            alert("Failed to retrieve Duz: " + errorMessage);
        }).done(function (data) {
            if (data && data.d && data.d.results != null && data.d.results.length == 1)
                duzRecord = data.d.results[0];
            else if (data.d.results.length > 1) {
                //if active, get most recently modified?
                //if inactive, then get most recently modified?
                duzRecord = data.d.results[0];

                if (data.d.results[0].cvt_StationNumber == MCS.VIALogin.patFacilityNumber) {
                    //alert("More than 1 DUZ for that User/StationNumber combination found.  Only 1 or 0 records should be found.");
                    MCS.VIALogin.ToggleIcon("PatDuz", "failure", "More than 1 DUZ for that User/StationNumber (" + data.d.results[0].cvt_StationNumber +") combination found.  Only 1 or 0 records should be found. Using first one returned.");
                }
                if (data.d.results[0].cvt_StationNumber == MCS.VIALogin.proFacilityNumber) {
                    //alert("More than 1 DUZ for that User/StationNumber combination found.  Only 1 or 0 records should be found.");
                    MCS.VIALogin.ToggleIcon("ProDuz", "failure", "More than 1 DUZ for that User/StationNumber (" + data.d.results[0].cvt_StationNumber +") combination found.  Only 1 or 0 records should be found. Using first one returned");
                }
                
            }
            MCS.VIALogin.DuzRecord = duzRecord;
        });
    };
}

/////////////////////EC ViaLogin  //main method to log into VIA using VIMT EC (through Actions/CWF/LOB)
// ************************************************DUZ Getting Functions****************************************************
//Access and Verify input were always undefined, so set to ""
{
    MCS.VIALogin.ViaLoginVimt = function () {
        //MCS.VIALogin.RetrieveUserSAMLToken();
        var duzSideValue = MCS.VIALogin.DuzSide();

        if (duzSideValue == "both") {
            if (MCS.VIALogin.patFacilityNumber == null)
                MCS.VIALogin.patFacilityNumber = MCS.VIALogin.GetFacilityNumber("pat");

            if (MCS.VIALogin.proFacilityNumber == null)
                MCS.VIALogin.proFacilityNumber = MCS.VIALogin.GetFacilityNumber("pro");

            //Interfacility
            if (MCS.VIALogin.patFacilityNumber != MCS.VIALogin.proFacilityNumber) {
                var patDuz = MCS.VIALogin.ActiveDuz(MCS.VIALogin.patFacilityNumber);
                var proDuz = MCS.VIALogin.ActiveDuz(MCS.VIALogin.proFacilityNumber);

                if (patDuz == "")
                    MCS.VIALogin.LoginWithAction(MCS.VIALogin.patFacilityNumber, "pat", "", "");

                if (proDuz == "")
                    MCS.VIALogin.LoginWithAction(MCS.VIALogin.proFacilityNumber, "pro", "", "");
            }
            //Intrafacility
            else {
                var proDuz = MCS.VIALogin.ActiveDuz(MCS.VIALogin.proFacilityNumber);
                if (proDuz == "")
                    MCS.VIALogin.LoginWithAction(MCS.VIALogin.proFacilityNumber, "pro", "", "");
            }
        }
        else {
            var stationNumber = duzSideValue == "pro" ? MCS.VIALogin.proFacilityNumber : MCS.VIALogin.patFacilityNumber;
            MCS.VIALogin.LoginWithAction(stationNumber, duzSideValue, "", "");
        }
    };

    //Calls the action and submits the resulting DUZ or else calls the Login through Access-Verify codes
    MCS.VIALogin.LoginWithAction = function (stationNumber, side, access, verify) {
        var isAV = (access != "" && verify != "") ? true : false;
        var loginType = isAV ? "VistA login with Access/Verify" : "VistA login with SAML";
        if (parent.Xrm.Page.context.getClientUrl().search("pssc") > -1) {
            if (isAV)
                MCS.VIALogin.SetUserDuz(stationNumber, "FakeUserDuzAV");
            else {
                if (MCS.VIALogin.TestingAV != side)
                    MCS.VIALogin.SetUserDuz(stationNumber, "FakeUserDuzSAML");
                else {
                    switch (side) {
                        case "pat":
                            $("#PatAV").show();
                            MCS.VIALogin.ToggleIcon("PatDuz", "failure", "Failed VistA login with SAML. Try Access/Verify codes for patient (" + stationNumber + ").");
                            break;
                        case "pro":
                            $("#ProAV").show();
                            MCS.VIALogin.ToggleIcon("ProDuz", "failure", "Failed VistA login with SAML. Try Access/Verify codes for provider (" + stationNumber + ").");
                            break;
                        case "both":
                            $("#ProAV").show();
                            MCS.VIALogin.ToggleIcon("ProDuz", "failure", "Failed VistA login with SAML. Try Access/Verify codes for intrafacility (" + stationNumber + ").");
                            break;
                    }

                }
            }
            return;
        }

        var requestName = "cvt_ViaLoginAction";
        var requestParams =
            [{
                Key: "StationNumber",
                Type: MCS.Scripts.Process.DataType.String,
                Value: stationNumber
            },
            {
                Key: "SamlToken",
                Type: MCS.Scripts.Process.DataType.String,
                Value: MCS.VIALogin.SamlString
            },
            {
                Key: "AccessCode",
                Type: MCS.Scripts.Process.DataType.String,
                Value: typeof access === "undefined" ? "" : access
            },
            {
                Key: "VerifyCode",
                Type: MCS.Scripts.Process.DataType.String,
                Value: typeof verify === "undefined" ? "" : verify
            }];
 
        MCS.Scripts.Process.ExecuteAction(requestName, requestParams)
            .done(function (response) {
                // Success
                var userDuz = response.UserDuz;
                var success = response.SuccessfulLogin;
                var errorMessage = response.ErrorMessage;

                if (success) {
                    MCS.VIALogin.SetUserDuz(stationNumber, userDuz);
                    
                    if ((Xrm.Page.getAttribute("cvt_patuserduz") == null & parent.Xrm.Page.getAttribute("cvt_patuserduz") != null))
                        Xrm = parent.Xrm;

                    if (stationNumber == MCS.VIALogin.proFacilityNumber) {
                        Xrm.Page.getAttribute("cvt_prouserduz").setValue(userDuz);
                        MCS.VIALogin.ToggleIcon("ProDuz", "success", loginType + " successful for " + stationNumber + ".");
                    }
                    if (stationNumber == MCS.VIALogin.patFacilityNumber) {
                        Xrm.Page.getAttribute("cvt_patuserduz").setValue(userDuz);
                        MCS.VIALogin.ToggleIcon("PatDuz", "success", loginType + " successful for " + stationNumber + ".");
                    }
                    MCS.VIALogin.TriggerGetConsults();
                }
                else {
                    //Intrafacility
                    if (MCS.VIALogin.patFacilityNumber == MCS.VIALogin.proFacilityNumber) {
                        $("#ProAV").show();
                        MCS.VIALogin.ToggleIcon("ProDuz", "failure", loginType + " failed for " + stationNumber + ". Try Access/Verify codes. Error Details: " + errorMessage);
                    }
                    else { //Interfacility, SFT, or H/M
                        //Pro
                        if (stationNumber == MCS.VIALogin.proFacilityNumber) {
                            $("#ProAV").show();
                            MCS.VIALogin.ToggleIcon("ProDuz", "failure", loginType + " failed for " + stationNumber + ". Try Access/Verify codes. Error Details: " + errorMessage);
                        }

                        //Pat
                        if (stationNumber == MCS.VIALogin.patFacilityNumber) {
                            $("#PatAV").show();
                            MCS.VIALogin.ToggleIcon("PatDuz", "failure", loginType + " failed for " + stationNumber + ". Try Access/Verify codes. Error Details: " + errorMessage);
                        }
                    }
                }
                MCS.VIALogin.ToggleButton(true);
            })
            .fail(function (err) {
                if (stationNumber == MCS.VIALogin.proFacilityNumber) {
                    MCS.VIALogin.ToggleIcon("ProDuz", "failure", loginType + " failed for " + stationNumber + ". Error Details: " + err.responseText);
                }
                if (stationNumber == MCS.VIALogin.patFacilityNumber) {
                    MCS.VIALogin.ToggleIcon("PatDuz", "failure", loginType + " failed for " + stationNumber + ". Error Details: " + err.responseText);
                }

                MCS.VIALogin.ToggleButton(true);
            });
    };

    //Do we write this new duz to the activity form?
    MCS.VIALogin.SetUserDuz = function (stationNumber, duz) {
        if (typeof Xrm == "undefined")
            Xrm = parent.Xrm;

        var userDuzRecord = {
            'cvt_name': duz
        };

        //Attempt to retrieve an inactive duz
        MCS.VIALogin.GetUserDuzRecord(stationNumber, false);

        if (MCS.VIALogin.DuzRecord) {
            //Activate record
            MCS.cvt_Common.changeRecordStatus(MCS.VIALogin.DuzRecord.cvt_userduzId, 'cvt_userduz', 0, 1);

            //Update Duz
            if (MCS.VIALogin.DuzRecord.cvt_userduzId != duz) {
                CrmRestKit.Update('cvt_userduz', MCS.VIALogin.DuzRecord.cvt_userduzId, userDuzRecord, false)
                    .fail(function (err) {
                        var errorMessage = MCS.cvt_Common.RestError(err);
                        alert("Error Updating User Duz Login Information: " + errorMessage);
                    }).done(function () {
                    });
            }
        }
        else {

            userDuzRecord["cvt_StationNumber"] = stationNumber;
            userDuzRecord["cvt_User"] = { __metadata: { type: "Microsoft.Crm.Sdk.Data.Services.EntityReference" }, Id: Xrm.Page.context.getUserId(), LogicalName: "systemuser" };

            //Create record from temp object
            CrmRestKit.Create('cvt_userduz', userDuzRecord, false)
                .fail(function (err) {
                    var errorMessage = MCS.cvt_Common.RestError(err);
                    alert("Error Creating User Duz Login Information: " + errorMessage);
                }).done(function () {
                });
        }
        //MCS.VIALogin.Login();
    };

    MCS.VIALogin.TriggerGetConsults = function () {
        if (typeof Xrm == "undefined")
            Xrm = parent.Xrm;

        var typecode = Xrm.Page.context.getQueryStringParameters().etc;
        if (typecode == 4214)
            Xrm.Page.getAttribute("cvt_rungetconsults").fireOnChange();
    };

    MCS.VIALogin.PatDuzButton = function () {       
        //var useAVCodes = confirm("Failed to log in with PIV, attempting Access Verify Codes for patient side.");
        //if (useAVCodes) {
        //    MCS.VIALogin.ToggleIcon("PatDuz", "working", "Attempting Access/Verify codes.");
        //    MCS.VIALogin.LoginWithAccessVerify(MCS.VIALogin.patFacilityNumber, "pat");
        //}

        MCS.VIALogin.ToggleIcon("PatDuz", "working", "Attempting Access/Verify codes.");


        var access = $("#PatientAccessCodeTextBox").val();
        var verify = $("#PatientVerifyCodeTextBox").val();

        if (access != "" && verify != "") {
            MCS.VIALogin.LoginWithAction(MCS.VIALogin.patFacilityNumber, "pat", access, verify);
            $("#PatAV").hide();
        }
        else
            MCS.VIALogin.ToggleIcon("PatDuz", "failure", "Please fill out Access and Verify codes then Submit.");
    };

    MCS.VIALogin.ProDuzButton = function () {
        
        //var useAVCodes = confirm("Failed to log in with PIV, attempting Access Verify Codes for provider side (or both if intrafacility).");
        //if (useAVCodes) {
        //    MCS.VIALogin.ToggleIcon("ProDuz", "working", "Attempting Access/Verify codes.");
        //    MCS.VIALogin.LoginWithAccessVerify(MCS.VIALogin.proFacilityNumber, "pro");
        //}
        var access = $("#ProviderAccessCodeTextBox").val();
        var verify = $("#ProviderVerifyCodeTextBox").val();

        MCS.VIALogin.ToggleIcon("ProDuz", "working", "Attempting Access/Verify codes.");
        if (access != "" && verify != "") {
            MCS.VIALogin.LoginWithAction(MCS.VIALogin.proFacilityNumber, "pro", access, verify);
            $("#ProAV").hide();
        }
        else
            MCS.VIALogin.ToggleIcon("ProDuz", "failure", "Please fill out Access and Verify codes then Submit.");
    };

    //Helper to re-call LoginVIMT using Access/Verify entered by user prompt - user can leave blank or hit cancel to end loop
    MCS.VIALogin.LoginWithAccessVerify = function (stationNumber, side) {
        var facilityString = side == "both" ? "the" : "the " + side;
        var accessCode = prompt("Please enter your access code for " + facilityString + " facility (" + stationNumber + ").", "");

        if (accessCode != null && accessCode != "") {
            var verifyCode = prompt("Please enter your verify code for " + facilityString + " facility (" + stationNumber + ").", "");
            if (verifyCode != null && verifyCode != "")
                MCS.VIALogin.LoginWithAction(stationNumber, side, accessCode, verifyCode);
        }
    };

}

// ************************VistA Switches and Integration checks *************************************
{
    MCS.VIALogin.RunVistaIntegration = function () {
        if (typeof Xrm.Page.ui == "undefined" || Xrm.Page.ui == null)
            Xrm = parent.Xrm;

        var typeCode = Xrm.Page.context.getQueryStringParameters().etc;
        //if block resource and theres no related appointment
        if (typeCode == 4201 && Xrm.Page.getAttribute("cvt_serviceactivityid").getValue() == null)
			{return false;}
		else if(typeCode == 4201 && Xrm.Page.getAttribute("cvt_serviceactivityid").getValue() != null)
			{return true;}
        //if appointment and no tsa is set
        if (typeCode == 4214 && (Xrm.Page.getAttribute("cvt_relatedschedulingpackage") == null || Xrm.Page.getAttribute("cvt_relatedschedulingpackage").getValue() == null)) {
            MCS.VIALogin.ToggleIcon("SAML", "failure", "Please select a SP.");
            return false;
        }
        //if appt and clinic based Group
        if (typeCode == 4214 && (!Xrm.Page.getAttribute("cvt_type").getValue() && Xrm.Page.getAttribute("mcs_groupappointment").getValue())) {
            return true;
		}
        var stateCode = Xrm.Page.getAttribute('statecode').getValue();
        //if not active
        if (stateCode != 3 && Xrm.Page.ui.getFormType() != 1)
            return false;
        //If vista integration switch is turned off
        if (!MCS.VIALogin.CheckVistaSwitches())
            return false;
        return true;
    };

    MCS.VIALogin.CheckVistaSwitches = function () {
        var VistaSwitchesConfig = true;
        var baseSwitchConfig = true;
        var hmConfig = true;
        var ifcConfig = true;
        var singleNonHmConfig = true;
        var filter = "mcs_name eq 'Active Settings'";
        calls = CrmRestKit.ByQuery("mcs_setting", ['cvt_UseVistaIntegration', 'cvt_UseVVSHomeMobile', 'cvt_UseVVSInterfacility', 'cvt_UseVVSSingleEncounterNonHomeMobile'], filter, false);
        calls.fail(function (err) {
            return VistaSwitchesConfig;
        }).done(function (data) {
            if (data && data.d && data.d.results != null && data.d.results.length != 0) {
                var record = data.d.results[0];
                baseSwitchConfig = record.cvt_UseVistaIntegration == null ? false : record.cvt_UseVistaIntegration;
                hmConfig = record.cvt_UseVVSHomeMobile == null ? false : record.cvt_UseVVSHomeMobile;
                ifcConfig = record.cvt_UseVVSInterfacility == null ? false : record.cvt_UseVVSInterfacility;
                singleNonHmConfig = record.cvt_UseVVSSingleEncounterNonHomeMobile == null ? false : record.cvt_UseVVSSingleEncounterNonHomeMobile;
            }
        });
        //Note that this is a triple equal, not a double, so a null value is considered acceptable to continue, only a false will mean "don't show Get Consults"
        if (baseSwitchConfig === false)
            return false;

        if (typeof Xrm != "undefined")
            return MCS.VIALogin.AppointmentTypeSwitchCheck(hmConfig, ifcConfig, singleNonHmConfig, Xrm);
        else
            return MCS.VIALogin.AppointmentTypeSwitchCheck(hmConfig, ifcConfig, singleNonHmConfig, parent.Xrm);
    };

    //Checking for switches in the following order
    //MAIN H/M --> MAIN SFT --> Record Specialty --> Record Specialty SubType --> Record Provider Facility --> MAIN Interfacility --> Record Patient Facility
    MCS.VIALogin.AppointmentTypeSwitchCheck = function (hmConfig, ifcConfig, sftConfig, Xrm) {
        var patFacId = null;
        var proFacId = null;
        var subSpecialty = null;
        var specialty = null;
        var isInterFacility = false;

        var tsaId = null;
        var isHomeMobile = null;
        var isSft = null;

        //check for Appt vs BR
        var typeCode = Xrm.Page.context.getQueryStringParameters().etc;

        //BR
        if (typeCode == 4201 && Xrm.Page.getAttribute("cvt_serviceactivityid").getValue() != null) {
            //Retrieve the SA, so we can get the tsa
            CrmRestKit.Retrieve('ServiceAppointment', Xrm.Page.getAttribute("cvt_serviceactivityid").getValue()[0].id, ['cvt_relatedschedulingpackage', 'cvt_Type', 'cvt_TelehealthModality'], false)
                .fail(function (err) {
                    //
                })
                .done(function (data) {
                    if (data != null && data.d != null) {
                        //Set the TSA ID
                        if (data.d.cvt_relatedschedulingpackage != null)
                            tsaId = data.d.cvt_relatedschedulingpackage.Id;

                        //Set H/M
                        if (data.d.cvt_Type != null)
                            isHomeMobile = data.d.cvt_Type;
                        else
                            isHomeMobile = false;

                        //Set SFT
                        if (data.d.cvt_TelehealthModality != null)
                            isSft = data.d.cvt_TelehealthModality;
                        else
                            isSft = false;
                    }
                });
        }
        //Appt so use this record
        else if (typeCode == 4214) {
            {
                if ((Xrm.Page.getAttribute("cvt_relatedschedulingpackage")) && (Xrm.Page.getAttribute("cvt_relatedschedulingpackage").getValue() != null))
                    tsaId = Xrm.Page.getAttribute("cvt_relatedschedulingpackage").getValue()[0].id;
                isHomeMobile = Xrm.Page.getAttribute("cvt_type").getValue();
                isSft = Xrm.Page.getAttribute("cvt_telehealthmodality").getValue();
            }
        }
        if (tsaId != null) {
            //Checking MAIN H/M Switch
            if (isHomeMobile && !hmConfig) // If Home Mobile and Main switch for VA Video Connect Encounter is turned off then return false
                return false;

            //Checking MAIN SFT Switch
            if (isSft && !sftConfig) // If SFT and Main switch for SFT Encounter is turned off then return false
                return false;

            //Retrieving the TSA details
            CrmRestKit.Retrieve('cvt_resourcepackage', tsaId, ['cvt_specialty', 'cvt_specialtysubtype'], false)
                .fail(function (err) {
                    alert("failed Scheduling Package check, defaulting to display Consults" + MCS.cvt_Common.RestError(err));
                })
                .done(function (data) {
                    if (data != null && data.d != null) {                      
                        if (data.d.cvt_specialty != null)
                            specialty = data.d.cvt_specialty.Id;
                        if (data.d.cvt_specialtysubtype != null)
                            subSpecialty = data.d.cvt_specialtysubtype.Id;
                    }
                });

            //Checking Specialty Switch
            var specialtySwitch = true;
            if (specialty != null) {
                CrmRestKit.Retrieve('mcs_servicetype', specialty, ['cvt_UseVVS'], false)
                    .fail(function (err) {
                        alert("Failed specialty type check, defaulting to display Consults" + MCS.cvt_Common.RestError(err));
                    })
                    .done(function (data) {
                        specialtySwitch = (data.d.cvt_UseVVS == null ? false : data.d.cvt_UseVVS);
                    });

                if (!specialtySwitch)
                    return false;
            }

            //Checking Specialty Sub-type Switch
            var subSpecialtySwitch = true;
            if (subSpecialty != null) {
                CrmRestKit.Retrieve('mcs_servicesubtype', subSpecialty, ['cvt_UseVVS'], false)
                    .fail(function (err) {
                        alert("failed sub-specialty type check, looking for specialty switch: " + MCS.cvt_Common.RestError(err));
                    }).done(function (data) {
                        subSpecialtySwitch = (data.d.cvt_UseVVS == null ? false : data.d.cvt_UseVVS);
                    });
            }

            if (!subSpecialtySwitch)
                return false;

            //Check Facility Switch
            var patSite = Xrm.Page.getAttribute("mcs_relatedsite").getValue();
            var proSite = Xrm.Page.getAttribute("mcs_relatedprovidersite").getValue();

            var siteId;
            if (patSite != null) {
                siteId = patSite[0].id;
                var siteFacId = null;

                if (patSite != null) {
                    CrmRestKit.Retrieve('mcs_site', siteId, ['mcs_FacilityId'], false)
                        .fail(function (err) {
                            alert("failed TMP Site check, Unable to perform VIA login: " + MCS.cvt_Common.RestError(err));
                        })
                        .done(function (data) {
                            if (data != null && data.d != null) {
                                if (data.d.mcs_FacilityId != null)
                                    siteFacId = data.d.mcs_FacilityId.Id;
                            }
                        });

                    var patFacilitySwitch = true;
                    CrmRestKit.Retrieve('mcs_facility', siteFacId, ['cvt_UseVistaIntrafacility'], false)
                        .fail(function (err) {
                            alert("failed Provider facility check, defaulting to display Consults" + MCS.cvt_Common.RestError(err));
                        })
                        .done(function (data) {
                            if (data != null && data.d != null)
                                patFacilitySwitch = (data.d.cvt_UseVistaIntrafacility == null ? false : data.d.cvt_UseVistaIntrafacility);
                        });

                    if (!patFacilitySwitch)
                        return false;
                }
            }
            else if (proSite != null) {
                siteId = proSite[0].id;
                var siteFacId = null;

                CrmRestKit.Retrieve('mcs_site', siteId, ['mcs_FacilityId'], false)
                    .fail(function (err) {
                        alert("failed TMP Site check, Unable to perform VIA login: " + MCS.cvt_Common.RestError(err));
                    })
                    .done(function (data) {
                        if (data != null && data.d != null) {
                            if (data.d.mcs_FacilityId != null)
                                siteFacId = data.d.mcs_FacilityId.Id;
                        }
                    });

                var proFacilitySwitch = true;
                CrmRestKit.Retrieve('mcs_facility', siteFacId, ['cvt_UseVistaIntrafacility'], false)
                    .fail(function (err) {
                        alert("failed Provider facility check, defaulting to display Consults" + MCS.cvt_Common.RestError(err));
                    })
                    .done(function (data) {
                        if (data != null && data.d != null)
                            proFacilitySwitch = (data.d.cvt_UseVistaIntrafacility == null ? false : data.d.cvt_UseVistaIntrafacility);
                    });

                if (!proFacilitySwitch)
                    return false;
            }

            return true;
        }
        //tsa obj is null
    }
}

// ************************Helper methods to retrieve Integration Settings (URLS) *************************************
{
    //Helper method to get any integration setting with the passed in name
    MCS.VIALogin.GetSetting = function (name) {
        var value = "";
        var filter = "mcs_name eq '" + name + "'";

        CrmRestKit.ByQuery("mcs_integrationsetting", ['mcs_value'], filter, false)
            .fail(function (err) {
                return value;
            }).done(function (data) {
                if (data && data.d && data.d.results != null && data.d.results.length != 0)
                    value = data.d.results[0].mcs_value;

            });
        return value;
    };
    //Helper Method to get SAML Token URL
    MCS.VIALogin.GetStsUrl = function () {
        var defaultUrl = "";// "https://dev.services.eauth.DNS   :9301/STS/RequestSecurityToken";
        var url = MCS.VIALogin.GetSetting("IAM SAML Token Endpoint");
        return url != "" ? url : defaultUrl;
    };

    //Helper method to get the Keep Alive Login Page
    MCS.VIALogin.GetKeepAliveLoginUrl = function () {
        var defaultUrl = "";//"https://qacrmdac.np.crm.vrm.vba.DNS   /CRMSSOi/qa/default.aspx";
        var url = MCS.VIALogin.GetSetting("Keep Alive Login Endpoint");
        return url != "" ? url : defaultUrl;
    };

    //Helper Method to get the url to refresh your token (assuming you have already called the login page)
    MCS.VIALogin.GetKeepAliveUrl = function () {
        var defaultUrl = "";// "https://qacrmdac.np.crm.vrm.vba.DNS   /CRMSSOi/qa/refreshtokensession.aspx";
        var url = MCS.VIALogin.GetSetting("Refresh SAML Token Endpoint");
        return url != "" ? url : defaultUrl;
    };

    //Helper Method to get BAH VIA Login iHub Endpoint URL
    MCS.VIALogin.ViaLoginUrl = function () {
        var url = MCS.VIALogin.GetSetting("VIA Login Endpoint");
        var defaultUrl = "";//"https://qacrmdac.np.crm.vrm.vba.DNS   /WebParts/DEV/api/VIA/LoginVIA/2.1/json";
        return url != "" ? url : defaultUrl;
    };
}

//HTML functions
{
    //Hide all Message Divs
    MCS.VIALogin.hideAll = function () {
        MCS.VIALogin.ToggleIcon("SAML", " ", "");
        MCS.VIALogin.ToggleIcon("PatDuz", " ", "");
        MCS.VIALogin.ToggleIcon("ProDuz", " ", "");

        $("#PatAV").hide();
        $("#ProAV").hide();
        if (Xrm.Page.getAttribute("cvt_relatedschedulingpackage") != null) {
            Xrm.Page.getAttribute("cvt_relatedschedulingpackage").addOnChange(MCS.VIALogin.Login);
        }
        else if (parent.Xrm.Page.getAttribute("cvt_relatedschedulingpackage") != null) {
            parent.Xrm.Page.getAttribute("cvt_relatedschedulingpackage").addOnChange(MCS.VIALogin.Login);
        }

        if (Xrm.Page.getAttribute("createdon") != null) {
            Xrm.Page.getAttribute("createdon").addOnChange(MCS.VIALogin.LoginOnCancelAppointment);
        }
        else if (parent.Xrm.Page.getAttribute("createdon") != null) {
            parent.Xrm.Page.getAttribute("createdon").addOnChange(MCS.VIALogin.LoginOnCancelAppointment);
        }
    };

    //SAML, PatDuz, ProDuz
    MCS.VIALogin.ToggleIcon = function (area, toggle, message) {
        var icons = [
            $("#msg" + area + "_working"),
            $("#msg" + area + "_success"),
            $("#msg" + area + "_failure")
        ];

        for (i = 0; i < icons.length; i++) {
            if (icons[i].selector.search(toggle) > -1)
                icons[i].show();
            else
                icons[i].hide();
        }

        var notification = $("#" + area + "Notification");
        notification.text("");
        notification.append(message);
    };

    MCS.VIALogin.ToggleButton = function (isVisible) {
        $("#LoginButton").attr('disabled', !isVisible);
        //if (isVisible)
            //MCS.VIALogin.ToggleIcon("SAML", "working", "Login button clicked. Working...");
    };
}