﻿//If the SDK namespace object is not defined, create it.
if (typeof MCS == "undefined")
    MCS = {};
// Create Namespace container for functions in this library;
if (typeof MCS.mcs_Service_Activity_OnLoad == "undefined")
    MCS.mcs_Service_Activity_OnLoad = {};

//Global Variables
var totalPatients = new Array();
var totalGroupPatients = new Array();
MCS.Patients = [];

//This onLoad function is the master function that coordinates the actual scripts that run
MCS.mcs_Service_Activity_OnLoad.OnLoad = function () {
    //Add Scripting events to fields for when fields change
    Xrm.Page.getAttribute("cvt_type").addOnChange(MCS.mcs_Service_Activity.CVTtoHome);
    Xrm.Page.getAttribute("mcs_groupappointment").addOnChange(MCS.mcs_Service_Activity.GroupAppt);
    Xrm.Page.getAttribute("mcs_groupappointment").addOnChange(MCS.mcs_Service_Activity.EnableSchedulingPackage);
    Xrm.Page.getAttribute("mcs_groupappointment").addOnChange(MCS.mcs_Service_Activity.HandleOnChangeSchedulingPackageLookup);
    Xrm.Page.getAttribute("mcs_groupappointment").addOnChange(MCS.mcs_Service_Activity.CreateName);
    Xrm.Page.getAttribute("cvt_telehealthmodality").addOnChange(MCS.mcs_Service_Activity.HandleOnChangeSchedulingPackageLookup);
    Xrm.Page.getAttribute("mcs_relatedsite").addOnChange(MCS.mcs_Service_Activity.EnableSchedulingPackage);
    Xrm.Page.getAttribute("mcs_relatedsite").addOnChange(MCS.mcs_Service_Activity.HandleOnChangeSchedulingPackageLookup);
    Xrm.Page.getAttribute("mcs_relatedprovidersite").addOnChange(MCS.mcs_Service_Activity.EnableSchedulingPackage);
    Xrm.Page.getAttribute("mcs_relatedprovidersite").addOnChange(MCS.mcs_Service_Activity.HandleOnChangeSchedulingPackageLookup);
    Xrm.Page.getAttribute("mcs_servicetype").addOnChange(MCS.mcs_Service_Activity.EnableServiceSubType);
    Xrm.Page.getAttribute("mcs_servicetype").addOnChange(MCS.mcs_Service_Activity.HandleOnChangeSchedulingPackageLookup);
    Xrm.Page.getAttribute("mcs_servicetype").addOnChange(MCS.mcs_Service_Activity.CreateName);
    Xrm.Page.getAttribute("mcs_servicesubtype").addOnChange(MCS.mcs_Service_Activity.EnableSchedulingPackage);
    Xrm.Page.getAttribute("mcs_servicesubtype").addOnChange(MCS.mcs_Service_Activity.HandleOnChangeSchedulingPackageLookup);
    Xrm.Page.getAttribute("mcs_servicesubtype").addOnChange(MCS.mcs_Service_Activity.CreateName);
    Xrm.Page.getAttribute("cvt_relatedproviderid").addOnChange(MCS.mcs_Service_Activity.HandleOnChangeSchedulingPackageLookup);
    Xrm.Page.getAttribute("cvt_relatedschedulingpackage").addOnChange(MCS.mcs_Service_Activity.GetSchedulingPackageData);
    Xrm.Page.getAttribute("cvt_relatedschedulingpackage").addOnChange(MCS.mcs_Service_Activity.HandleOnChangeSchedulingPackageLookup);
    Xrm.Page.getAttribute("cvt_relatedschedulingpackage").addOnChange(MCS.mcs_Service_Activity.ClearResources);
    Xrm.Page.getAttribute("cvt_relatedschedulingpackage").addOnChange(MCS.mcs_Service_Activity.filterSubGrid);
    //Xrm.Page.getAttribute("cvt_relatedschedulingpackage").addOnChange(MCS.VIALogin.Login);
    //Xrm.Page.getAttribute("cvt_samltoken").addOnChange(MCS.VIALogin.Login);

    //Xrm.Page.getAttribute("customers").addOnChange(MCS.mcs_Service_Activity.CalculateRemainingCapacity);
    //Xrm.Page.getAttribute("customers").addOnChange(MCS.mcs_Service_Activity.CreateName);
    //Xrm.Page.getAttribute("resources").addOnChange(MCS.mcs_Service_Activity.SchedulingInfo);
    Xrm.Page.getAttribute("customers").addOnChange(MCS.mcs_Service_Activity.BlockAddPatient);

    //Run the following functions when the form loads
    MCS.mcs_Service_Activity.EnableServiceSubType();
    MCS.mcs_Service_Activity.EnableSchedulingPackage();
    MCS.mcs_Service_Activity.GroupAppt();
    MCS.mcs_Service_Activity_OnLoad.SetDefaultDateTime();
    MCS.mcs_Service_Activity.GetSchedulingPackageData();
    MCS.mcs_Service_Activity.HandleOnChangeSchedulingPackageLookup();
    MCS.mcs_Service_Activity.CVTtoHome();
    MCS.mcs_Service_Activity_OnLoad.RemoveNotification();
    MCS.mcs_Service_Activity_OnLoad.ShowMVI();
    MCS.mcs_Service_Activity_OnLoad.LoadPatients();
    MCS.mcs_Service_Activity_OnLoad.ResetPatients();
    //MCS.VIALogin.Saml();
    //MCS.VIALogin.Login();

    Xrm.Page.getAttribute("cvt_patuserduz").setValue(null);
    Xrm.Page.getAttribute("cvt_prouserduz").setValue(null);
    Xrm.Page.getAttribute("cvt_samltoken").setValue(null);

    Xrm.Page.getAttribute("cvt_patuserduz").setSubmitMode("never");
    Xrm.Page.getAttribute("cvt_prouserduz").setSubmitMode("never");
    Xrm.Page.getAttribute("cvt_samltoken").setSubmitMode("never");
};


//If the Service is not loaded, default the start and end time to 8:30-9:30
MCS.mcs_Service_Activity_OnLoad.SetDefaultDateTime = function () {
    //Set Default Datetime if the Scheduling Package Service has not been loaded yet. 
    if (Xrm.Page.getAttribute("serviceid").getValue() == null) {
        MCS.cvt_Common.DateTime('scheduledstart', 8, 30);
        MCS.cvt_Common.DateTime('scheduledend', 9, 30);
        Xrm.Page.getAttribute("scheduleddurationminutes").setValue(60);
    }
};

//unsupported modification to clear out the incorrect notification that the resources do not match the service rules listed (they are in the appointments per design)
MCS.mcs_Service_Activity_OnLoad.RemoveNotification = function () {
    //Group and Update Form
    if (Xrm.Page.getAttribute("mcs_groupappointment").getValue() == true && Xrm.Page.ui.getFormType() != 1) {
        var notificationsList = Sys.Application.findComponent('crmNotifications');
        if (notificationsList) {
            //Hide message
            notificationsList.SetVisible(false);
        }
    }
};

//Read the configuration value from Active Settings to determine whether or not to display the Patient Search (MVI) iFrame as well as the patients field
MCS.mcs_Service_Activity_OnLoad.ShowMVI = function () {
    var patObj = Xrm.Page.getAttribute("customers");
    var patientExists = patObj.getValue() != null;
    var mviTab = Xrm.Page.ui.tabs.get("tab_7");
    var showMVI = MCS.cvt_Common.MVIConfig();
    showMVI = showMVI && !MCS.cvt_Common.AppointmentOccursInPast();
    mviTab.setVisible(showMVI);
    Xrm.Page.getControl("customers").setDisabled(!showMVI);
    if (showMVI && !patientExists)
        mviTab.setFocus();
    else
        Xrm.Page.getControl("cvt_type").setFocus();

    if (patientExists) {
        mviTab.setDisplayState("collapsed");
    }
};

MCS.mcs_Service_Activity_OnLoad.LoadPatients = function () {
    var patientObj = Xrm.Page.getAttribute("customers");
    var patients = patientObj != null ? patientObj.getValue() : [];
    MCS.Patients = patients;
};

//This function is required in order to ensure the "Patients" Activity Party List does not show empty/duplicate APs - existing CRM bug
MCS.mcs_Service_Activity_OnLoad.ResetPatients = function () {
    var cust = Xrm.Page.getAttribute("customers").getValue();
    Xrm.Page.getAttribute("customers").setValue(cust);
};
