﻿using MCSShared;
using Microsoft.Xrm.Sdk;
using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.OptionSets;

namespace VA.TMP.CRM
{
    public class ResourcePackageCreatePreStageRunner : PluginRunner
    {
        public ResourcePackageCreatePreStageRunner(IServiceProvider serviceProvider) : base(serviceProvider){}
        /// <summary>
        /// Entry Point for Resource Package Pre Create Plugin Runner
        /// </summary>
        /// <param name="serviceProvider">CRM Service Provider used to Retrieve Org Service, PluginContext, Tracing Service, etc.</param>
        public new void RunPlugin(IServiceProvider serviceProvider) { base.RunPlugin(serviceProvider); }

        /// <summary>
        /// Ensure the name is correct
        /// </summary>
        public override void Execute()
        {
            Logger.setMethod = "Execute";

            Logger.WriteDebugMessage("About to check for duplicates.");
            CheckForDuplicate();

            Logger.WriteDebugMessage("About to retrieve the derived name.");
            //Check Pre Name against format and update if needed
            var derivedName = CvtHelper.ReturnRecordNameIfChanged(PrimaryEntity.ToEntity<cvt_resourcepackage>(), true, Logger, OrganizationService);
            Logger.WriteDebugMessage("The derivedName came back, it is: " + derivedName.ToString());

            if (!String.IsNullOrEmpty(derivedName))
            {
                Logger.WriteDebugMessage(String.Format("The Resource Package name should be different than {0}, updating it in the CreatePreStage to: {1}.", PrimaryEntity.Attributes["cvt_name"].ToString(), derivedName));
                PrimaryEntity.Attributes["cvt_name"] = (string)derivedName;
                Logger.WriteDebugMessage("New name as read from the PrimaryEntity: " + PrimaryEntity.Attributes["cvt_name"].ToString());
            }
            else
            {
                Logger.WriteDebugMessage("No change made to the name.  The Resource Package name is already correct.");
            }
            CheckForHubTeams();
            Logger.setMethod = "Execute";
            Logger.WriteDebugMessage("End of PreStageCreate Execute method.");
        }
        //Check for duplicate
        public void CheckForDuplicate()
        {
            Logger.setMethod = "CheckForDuplicate";
            using (var srv = new Xrm(OrganizationService))
            {
                var thisRecord = PrimaryEntity.ToEntity<cvt_resourcepackage>();
                var existingSP = srv.cvt_resourcepackageSet.FirstOrDefault(rp =>
                    rp.cvt_providerlocationtype == thisRecord.cvt_providerlocationtype &&
                    rp.cvt_patientlocationtype == thisRecord.cvt_patientlocationtype &&
                    rp.cvt_availabletelehealthmodality == thisRecord.cvt_availabletelehealthmodality &&
                    rp.cvt_groupappointment == thisRecord.cvt_groupappointment &&
                    rp.cvt_specialty == thisRecord.cvt_specialty &&
                    rp.cvt_specialtysubtype == thisRecord.cvt_specialtysubtype &&
                    rp.cvt_hub == thisRecord.cvt_hub
                    );

                if (existingSP != null)
                {
                    if (existingSP.statuscode.Value == (int)cvt_resourcepackage_statuscode.Active)
                        throw new InvalidPluginExecutionException("Scheduling Package already exists, please use that record.");
                    else
                        throw new InvalidPluginExecutionException("Deactivated Scheduling Package already exists, please reactivate it and use that record.");
                }
            }
        }
        //Check for Hub Teams
        public void CheckForHubTeams()
        {
            Logger.setMethod = "CheckForHubTeams";
            using (var srv = new Xrm(OrganizationService))
            {
                var thisRecord = PrimaryEntity.ToEntity<cvt_resourcepackage>();
                var hub = thisRecord.cvt_hub != null ? thisRecord.cvt_hub.Id : Guid.Empty;
                if (hub != null && hub != Guid.Empty)
                {
                    Logger.WriteDebugMessage("Hub found, checking for teams.");
                    Logger.WriteDebugMessage("Getting Hub Facility approval teams.");
                    var hubDirectorTeam = srv.TeamSet.FirstOrDefault(T => T.cvt_Type.Value == (int)Teamcvt_Type.HubDirector && T.cvt_Facility.Id == hub);
                    var hubTSAManagerTeam = srv.TeamSet.FirstOrDefault(T => T.cvt_Type.Value == (int)Teamcvt_Type.HubTSAManager && T.cvt_Facility.Id == hub);

                    //Check if team exists and if there are team members.
                    var teamCheck = checkTeam(hubDirectorTeam, "Hub Director");
                    teamCheck = checkTeam(hubTSAManagerTeam, "Hub TSA Manager");

                    if (teamCheck != "")
                        throw new InvalidPluginExecutionException(teamCheck);
                    Logger.WriteDebugMessage("Hub Director and TSA Manager Teams exists.");
                }
                Logger.WriteDebugMessage("Not a hub SP, so not returning a Hub TSA Manager team.");
            }
        }

        public string checkTeam(Team thisTeam, string check)
        {
            var message = "";

            if (thisTeam == null)
                message = check + " Team is missing, it needs to be created. \n";
            else
            {
                //Check for team members
                using (var srv = new Xrm(OrganizationService))
                {
                    var members = srv.TeamMembershipSet.Where(tm => tm.TeamId.Value == thisTeam.Id).ToList();
                    if (members == null || members.Count == 0)
                        message = thisTeam.Name + " has no members, users need to be added. \n";
                }
            }
            return message;
        }
        #region Additional Interface Methods/Properties
        /// <summary>
        /// Used for Debugging - turns on or off creation of log records for this particular entity
        /// </summary>
        public override string McsSettingsDebugField
        {
            get { return "cvt_ppereview"; }
        }
        #endregion
    }
}