﻿using MCSShared;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Collections.Generic;
using System.Linq;
using System.ServiceModel;
using VA.TMP.DataModel;
using VA.TMP.OptionSets;

namespace VA.TMP.CRM
{
    public class McsResourceUpdatePostStageAsyncRunner:PluginRunner
    {
        #region Constructor
        public McsResourceUpdatePostStageAsyncRunner(IServiceProvider ServiceProvider) : base(ServiceProvider)
        { }
        #endregion

        public override void Execute()
        {
            Logger.WriteDebugMessage("Starting");
            var thisResource = PrimaryEntity.ToEntity<mcs_resource>();
            Logger.WriteDebugMessage("Primary Entity Cast as mcs_resource");
            //if ((PrimaryEntity.LogicalName == mcs_resource.EntityLogicalName) && ((int)PrimaryEntity.Attributes["mcs_type"] == (int)mcs_resourcetype.VistaClinic))

            if (thisResource.LogicalName == mcs_resource.EntityLogicalName)
            {
                Logger.WriteDebugMessage("check 1");
            }
            Logger.WriteDebugMessage("VistaClinic has optionSetValue = " + (int)mcs_resourcetype.VistaClinic);

            mcs_resource resPre = PluginExecutionContext.PreEntityImages["PreImage"]?.ToEntity<mcs_resource>();
            mcs_resource resPost = PluginExecutionContext.PostEntityImages["PostImage"]?.ToEntity<mcs_resource>();

            if (resPost.mcs_Type.Value == (int)mcs_resourcetype.VistaClinic)
            {
                Logger.WriteDebugMessage("check 2");
            }

            if ((thisResource.LogicalName==mcs_resource.EntityLogicalName)&&(resPost.mcs_Type.Value == (int)mcs_resourcetype.VistaClinic))
            {
                Logger.WriteDebugMessage("This Resource is a VC.");
                var mcsResource = PrimaryEntity.ToEntity<mcs_resource>();
                //throw new NotImplementedException();
                // get pr/post images to compare
                //mcs_resource resPre = PluginExecutionContext.PreEntityImages["PreImage"]?.ToEntity<mcs_resource>();
                //mcs_resource resPost = PluginExecutionContext.PostEntityImages["PostImage"]?.ToEntity<mcs_resource>();

                Logger.WriteDebugMessage("Got Images.");
                string prePrimary = string.Empty;
                string postPrimary = string.Empty;

                //Need to check with Phil re: need for secondary stop codes
                //string preSecondary = string.Empty;
                //string postSecondary = string.Empty;

                EntityReference prePrimaryProvider = null;
                EntityReference postPrimaryProvider = null;
                Guid prePrimaryProviderId = Guid.Empty;
                Guid postPrimaryProviderId = Guid.Empty;

                bool preIsActive = false;
                bool postIsActive = false;


                #region Get Primary Stop Code for comparison
                //cvt_primarystopcode (text)
                Logger.WriteDebugMessage("beginning 'Get primary stop codes for comparison'.");
                if (resPre.Contains("cvt_primarystopcode"))
                {
                    prePrimary = resPre["cvt_primarystopcode"].ToString();
                }
                Logger.WriteDebugMessage("Got primary stop code from PreImage");
                if (resPost.Contains("cvt_primarystopcode"))
                {
                    postPrimary = resPost["cvt_primarystopcode"].ToString();
                }
                Logger.WriteDebugMessage("Got primary stop code from PostImage");
                Logger.WriteDebugMessage("Got primary stop codes for comparison.");
                #endregion

                #region Get Secondary Stop Code for comparison
                //cvt_secondarystopcode (text)
                //if (resPre.Contains("cvt_secondarystopcode"))
                //{
                //    preSecondary = resPre["cvt_secondarystopcode"].ToString();
                //}

                //if (resPost.Contains("cvt_secondarystopcode"))
                //{
                //    postSecondary = resPost["cvt_secondarystopcode"].ToString();
                //}
                #endregion

                #region Get Default Provider for comparison
                //cvt_defaultprovider (lookup)
                Logger.WriteDebugMessage("beginning 'Get Default Provider for comparison'.");
                if (resPre.Contains("cvt_defaultprovider"))
                {
                    prePrimaryProvider = (EntityReference)resPre["cvt_defaultprovider"];
                    prePrimaryProviderId = prePrimaryProvider.Id;
                }
                Logger.WriteDebugMessage("Got Default Provider code from PreImage: " + prePrimaryProviderId);
                if (resPost.Contains("cvt_defaultprovider"))
                {
                    postPrimaryProvider = (EntityReference)resPost["cvt_defaultprovider"];
                    postPrimaryProviderId = postPrimaryProvider.Id;
                }
                Logger.WriteDebugMessage("Got Default Provider from PostImage: " + postPrimaryProviderId);
                Logger.WriteDebugMessage("Got Default Provider for comparison.");
                #endregion

                #region Get Pre/Post Status for comparison
                //statuscode (status)
                Logger.WriteDebugMessage("beginning 'Get record Status for comparison'.");
                if (resPre.Contains("statuscode"))
                {
                    preIsActive=CheckRecordStatus(resPre.statuscode.Value);
                }
                Logger.WriteDebugMessage("Got Status from PreImage: " + preIsActive);
                if (resPost.Contains("statuscode"))
                {
                    postIsActive = CheckRecordStatus(resPost.statuscode.Value);
                }
                Logger.WriteDebugMessage("Got Status from PostImage: " + postIsActive);
                Logger.WriteDebugMessage("Got record Status for comparison.");


                #endregion

                #region Do Comparisons
                Logger.WriteDebugMessage("Beginning Comparison operations.");
                Logger.WriteDebugMessage("Primary Stop Code Comparison: prePrimary=" + prePrimary + ". postPrimary=" + postPrimary);
                if (prePrimary != postPrimary && (prePrimary == "690" || postPrimary == "690"|| prePrimary == "694" || postPrimary == "694"))
                {
                    Logger.WriteDebugMessage("Primary Stop Code not equal in Pre/Post, calling EntryFromVistaClinic");
                    CvtHelper.EntryFromVistaClinic(resPre, resPost, Logger, OrganizationService);
                }
                //else if (preSecondary != postSecondary)
                //{
                //    CvtHelper.EntryFromVistaClinic(resPre, resPost, Logger, OrganizationService);
                //}
                else if (prePrimaryProviderId != postPrimaryProviderId)
                {
                    Logger.WriteDebugMessage("Default Provider not equal in Pre/Post, calling EntryFromVistaClinic");
                    CvtHelper.EntryFromVistaClinic(resPre, resPost, Logger, OrganizationService);
                }
                else if (preIsActive != postIsActive)
                {
                    Logger.WriteDebugMessage("Record Status not equal in Pre/Post, calling EntryFromVistaClinic");
                    CvtHelper.EntryFromVistaClinic(resPre, resPost, Logger, OrganizationService);
                }
                else
                    Logger.WriteDebugMessage("No Changes detected. Did not call EntryFromVistaClinc function.");
                #endregion


            }
            else //it's not a mcs_resource of type 'Vista Clinic'
            {
                return;
            }

        }

        public bool CheckRecordStatus(int? statuscode)
        {
            bool isActive = true;

            if (statuscode != null)
            {
                switch (statuscode)
                {
                    case (int)mcs_resource_statuscode.Active:
                        isActive = true;
                        break;
                    case (int)mcs_resource_statuscode.Inactive:
                        isActive = false;
                        break;
                }
            }

            return isActive;
        }
        public override string McsSettingsDebugField
        {
            get { return "mcs_resourceplugin"; }
        }
    }
}
