﻿using MCSShared;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Linq;
using System.ServiceModel;
using VA.TMP.DataModel;
using VA.TMP.OptionSets;

namespace VA.TMP.CRM
{
    public class McsResourceCreatePostStageAsyncRunner:PluginRunner
    {
        #region Constructor
        public McsResourceCreatePostStageAsyncRunner(IServiceProvider serviceProvider) : base(serviceProvider) { }
        #endregion

        public override void Execute()
        {
            Logger.WriteDebugMessage("Starting");
            var thisResource = PrimaryEntity.ToEntity<mcs_resource>();
            Logger.WriteDebugMessage("Primary Entity Cast as mcs_resource");

            if (thisResource.LogicalName == mcs_resource.EntityLogicalName)
            {
                Logger.WriteDebugMessage("check 1");
            }

            //this is a plugin that runs async after the CREATE message - no 'PreImage' image available
            //mcs_resource resPre = PluginExecutionContext.PreEntityImages["PreImage"]?.ToEntity<mcs_resource>();
            mcs_resource resPost = PluginExecutionContext.PostEntityImages["PostImage"]?.ToEntity<mcs_resource>();
            Logger.WriteDebugMessage("Got PostImage.");

            //Make sure its a Vista Clinic:
            if (resPost.mcs_Type != null)
            {
                if (resPost.mcs_Type.Value == (int)mcs_resourcetype.VistaClinic)
                {
                    Logger.WriteDebugMessage("'Type' specified for MCS Resource is 'Vista Clinic'.");
                }
                else {
                    Logger.WriteDebugMessage("'Type' specified for MCS Resource is other than Vista Clinic.  Exiting.");
                    return;
                }
            }
            else {
                Logger.WriteDebugMessage("no 'Type' specified for MCS Resource.  Exiting.");
                return;
            }

            if ((thisResource.LogicalName == mcs_resource.EntityLogicalName) && (resPost.mcs_Type.Value == (int)mcs_resourcetype.VistaClinic))
            {

                string postPrimary = string.Empty;
                Guid postPrimaryProviderId = Guid.Empty;
                bool postIsActive = false;

                Logger.WriteDebugMessage("Getting primary stop code from PostImage");
                if (resPost.Contains("cvt_primarystopcode"))
                {
                    postPrimary = resPost["cvt_primarystopcode"].ToString();
                }
                Logger.WriteDebugMessage("Got primary stop code from PostImage");
                Logger.WriteDebugMessage("Getting Status from PostImage");
                if (resPost.Contains("statuscode"))
                {
                    postIsActive = CheckRecordStatus(resPost.statuscode.Value);
                }
                Logger.WriteDebugMessage("Got Status from PostImage: " + postIsActive);

                //if PSC=690 and the record is active, call the entry point

                if (((postPrimary == "690")||(postPrimary=="694")) && (postIsActive))
                {
                    Logger.WriteDebugMessage("trying to generate service - PreImage is Null");
                    CvtHelper.EntryFromVistaClinic(resPost,true, Logger, OrganizationService);
                }
            }

            //throw new NotImplementedException();
        }

        #region Methods
        public bool CheckRecordStatus(int? statuscode)
        {
            bool isActive = true;

            if (statuscode != null)
            {
                switch (statuscode)
                {
                    case (int)mcs_resource_statuscode.Active:
                        isActive = true;
                        break;
                    case (int)mcs_resource_statuscode.Inactive:
                        isActive = false;
                        break;
                }
            }

            return isActive;
        }
        #endregion

        #region Additional Interface Methods
        public override string McsSettingsDebugField
        {
            get { return "mcs_resourceplugin"; }
        }
        #endregion

    }
}
