﻿using MCSShared;
using Microsoft.Crm.Sdk.Messages;
using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Collections.Generic;
using System.Globalization;
using System.Linq;
using System.Text;
using VA.TMP.DataModel;
using VA.TMP.OptionSets;

namespace VA.TMP.CRM
{
    public class EMailCreatePostStageRunner : PluginRunner
    {
        public EMailCreatePostStageRunner(IServiceProvider serviceProvider) : base(serviceProvider) { }
        //Declare global variables
        //string customMessage;

        #region Implementation
        /// <summary>
        /// Called by PluginRunner - Decide which email to send out (aka which branch of the plugin to run)
        /// </summary>
        public override void Execute()
        {
            Email email = (Email)OrganizationService.Retrieve(Email.EntityLogicalName.ToString(), PrimaryEntity.Id, new ColumnSet(true));
            if (email.Subject.StartsWith("FW:") || email.Subject.StartsWith("RE:"))
                return;

            Logger.setMethod = "EMailCreatePostStageRunner -> Execute";
            Logger.WriteDebugMessage("Starting plugin for Email with Subject: '" + email.Subject + "'");

            if (email.mcs_RelatedServiceActivity != null)
            {
                Logger.WriteDebugMessage("Related ServiceAvtivity = '" + email.mcs_RelatedServiceActivity.Id + "'");
            }

            if (email.mcs_RelatedServiceActivity != null)
            {
                Logger.WriteDebugMessage("RelatedServiceActivity is not Null");
                //Retrieve and Use relatedAppt and TSA throughout ServiceAppointment Email Execute Functions
                ServiceAppointment relatedAppt = (ServiceAppointment)OrganizationService.Retrieve(
                    ServiceAppointment.EntityLogicalName.ToString(), email.mcs_RelatedServiceActivity.Id, new ColumnSet(true));

                //using (var srv = new Xrm(OrganizationService))
                //{
                   //sa = srv.ServiceAppointmentSet.FirstOrDefault(s => s.Id == PrimaryEntity.Id);
                   //replacing with reference to Scheduling Package - WMC 11/15/2018
                   //mcs_services tsa = (mcs_services)OrganizationService.Retrieve(mcs_services.EntityLogicalName, relatedAppt.mcs_relatedtsa.Id, new ColumnSet(true));
                   cvt_resourcepackage tsa = (cvt_resourcepackage)OrganizationService.Retrieve(cvt_resourcepackage.EntityLogicalName, relatedAppt.cvt_relatedschedulingpackage.Id, new ColumnSet(true));

                    var SAEmail = new ServiceAppointmentEmail(OrganizationService, Logger, email, relatedAppt, tsa);
                    SAEmail.Execute();
                //}
            }
            if (email.RegardingObjectId != null)
            {
                //replacing with reference to Scheduling Package - WMC 11/15/2018
                //if (email.RegardingObjectId.LogicalName == mcs_services.EntityLogicalName)
                if(email.RegardingObjectId.LogicalName==cvt_resourcepackage.EntityLogicalName)
                {
                    var TsaEmail = new TsaEmail(OrganizationService, Logger, email);
                    TsaEmail.Execute();
                    Logger.WriteDebugMessage("Completed Send TSA Email");
                }
                //Facility Approval Emails
                else if (email.RegardingObjectId.LogicalName == cvt_facilityapproval.EntityLogicalName || email.RegardingObjectId.LogicalName == cvt_participatingsite.EntityLogicalName)
                {
                    var FAEmail = new FacilityApprovalEmail(OrganizationService, Logger, email);
                    FAEmail.Execute();
                }
                //Guest Emails
                else if (email.RegardingObjectId.LogicalName == cvt_nonvaemail.EntityLogicalName)
                {
                    Logger.WriteDebugMessage("RegardingObjectId is the Guest Email");
                    var GstEmail = new GuestEmail(OrganizationService, Logger, email);
                    GstEmail.Execute();
                    Logger.WriteDebugMessage("Email Sent to Veteran's Guest");
                }
                else
                {
                    var privilegingEmail = new PrivilegingEmail(OrganizationService, Logger, email);
                    privilegingEmail.Execute();
                }  
            }
            if (email.Subject == "Action Required: Update Your Provider Preferences in TMP")
            {
                Logger.WriteDebugMessage("Beginning Provider Preferences Email");
                var userEmail = new UserEmail(OrganizationService, Logger, email);
                userEmail.Execute();
            }
            
        }
        #endregion

        #region Debug Field for Logging
        public override string McsSettingsDebugField
        {
            get { return "cvt_serviceactivityplugin"; }
        }
        #endregion
    }
}
