﻿using Microsoft.Xrm.Sdk.Client;
using System;
using System.Collections.Generic;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Messages.Vista;
//using VIMT.VIASchedulingService.Messages;
//using VIMT.VideoVisit.Messages;
using VRM.Integration.Servicebus.Core;
using VA.TMP.Integration.VIMT.Vista.Mappers;
using VIMT.VIASchedulingService.Messages;
using VIMT.VIAEMRService.Messages;

namespace VA.TMP.Integration.VIMT.Vista.StateObject
{
    public class MakeAppointmentStateObject : PipeState
    {
        public MakeAppointmentStateObject(MakeAppointmentRequestMessage request)
        {
            OrganizationName = request.OrganizationName;
            UserId = request.UserId;
        }
        /// <summary>
        /// Gets or sets the CRM organization name.
        /// </summary>
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log the request.
        /// </summary>
        public bool LogRequest { get; set; }

        /// <summary>
        /// Get or set the CRM Organization Service Proxy.
        /// </summary>
        public OrganizationServiceProxy OrganizationServiceProxy { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        public Guid AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets whether to use a fake response.
        /// </summary>
        public string VistaFakeResponseType { get; set; }

        public AppointmentType AppointmentType { get; set; }

        /// <summary>
        /// Get or set the Service Appointment.
        /// </summary>
        public ServiceAppointment ServiceAppointment { get; set; }

        /// <summary>
        /// Get or set the Service Appointment.
        /// </summary>
        public Appointment CrmAppointment { get; set; }

        /// <summary>
        /// Get or set the Service Appointment.
        /// </summary>
        public List<Guid> ContactIds { get; set; }

        /// <summary>
        /// Get or set the Service Appointment.
        /// </summary>
        public List<SystemUser> SystemUsers { get; set; }

        /// <summary>
        /// Gets or sets a serialized Appointment.
        /// </summary>
        public string SerializedAppointment { get; set; }

        /// <summary>
        /// Gets or Sets whether an exception occured.
        /// </summary>
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Gets or Sets the exception message.
        /// </summary>
        public string ExceptionMessage { get; set; }

        /// <summary>
        /// Plugin Request Message
        /// </summary>
        public MakeAppointmentRequestMessage MakeAppointmentRequestMessage { get; set; }

        /// <summary>
        /// Plugin Response Message.
        /// </summary>
        public MakeAppointmentResponseMessage MakeAppointmentResponseMessage { get; set; }

        /// <summary>
        /// Patient Side Ec Request
        /// </summary>
        public VIMTVIASchdMakeApptmakeAppointmentRequest PatEcRequest { get; set; }

        /// <summary>
        /// Patient Side Ec Response
        /// </summary>
        public VIMTVIASchdMakeApptmakeAppointmentResponse PatEcResponse { get; set; }
        /// <summary>
        /// Provider Side Ec Request
        /// </summary>
        public VIMTVIASchdMakeApptmakeAppointmentRequest ProEcRequest { get; set; }

        /// <summary>
        /// Provider Side Ec Response
        /// </summary>
        public VIMTVIASchdMakeApptmakeAppointmentResponse ProEcResponse { get; set; }

        /// <summary>
        /// Query Bean for appointment request (both sides sharing same bean)
        /// </summary>
        public VIMTVIASchdMakeApptReqqueryBean EcQueryBean { get; set; }

        public VIMTVIAScheLIloginVIARequest PatLoginRequest { get; set; }

        public VIMTVIAScheLIloginVIARequest ProLoginRequest { get; set; }
    }
}
