﻿using Microsoft.Xrm.Sdk.Client;
using System;
using System.Collections.Generic;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Messages.Vista;
//using VIMT.VideoVisit.Messages;
using VRM.Integration.Servicebus.Core;
using VIMT.VIAEMRService.Messages;
using VIMT.VIASchedulingService.Messages;

namespace VA.TMP.Integration.VIMT.Vista.StateObject
{
    public class GetConsultsForPatientStateObject : PipeState
    {
        public GetConsultsForPatientStateObject(GetConsultsForPatientRequest request)
        {
            OrganizationName = request.OrganizationName;
            UserId = request.UserId;
            GetConsultsRequest = request;
            LogRequest = request.LogRequest;
        }

        /// <summary>
        /// Gets or sets a serialized Consult EC Request.
        /// </summary>
        public string SerializedConsult { get; set; }

        /// <summary>
        /// Gets or Sets whether an exception occured.
        /// </summary>
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Gets or Sets the exception message.
        /// </summary>
        public string ExceptionMessage { get; set; }

        /// <summary>
        /// Gets or sets the CRM organization name.
        /// </summary>
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log the request.
        /// </summary>
        public bool LogRequest { get; set; }

        /// <summary>
        /// Get or set the CRM Organization Service Proxy.
        /// </summary>
        public OrganizationServiceProxy OrganizationServiceProxy { get; set; }

        /// <summary>
        /// Used to fake the EC Call/Response for local testing
        /// </summary>
        public string ConsultsFakeResponseType { get; set; }

        /// <summary>
        /// Request Message coming from the Plugin
        /// </summary>
        public GetConsultsForPatientRequest GetConsultsRequest { get; set; }

        /// <summary>
        /// Response Message to be sent back to the Plugin
        /// </summary>
        public GetConsultsForPatientResponse GetConsultsResponse { get; set; }

        /// <summary>
        /// Request Message to be sent to the EC
        /// </summary>
        public VIMTVIAEMRgcfpgetConsultsForPatientRequest PatEcRequest { get; set; }

        public VIMTVIAEMRgcfpgetConsultsForPatientRequest ProEcRequest { get; set; }

        /// <summary>
        /// Response Message Received from the EC
        /// </summary>
        public VIMTVIAEMRgcfpgetConsultsForPatientResponse PatEcResponse { get; set; }

        public VIMTVIAEMRgcfpgetConsultsForPatientResponse ProEcResponse { get; set; }

        public string mcs_status { get; set; }

        public string Via_AppToken { get; set; }

        public string Via_AppPassword { get; set; }

        public VIMTVIAScheLIloginVIARequest PatLoginRequest { get; set; }

        public VIMTVIAScheLIloginVIARequest ProLoginRequest { get; set; }

        //public string mcs_localPid { get; set; }

        //public string mcs_localSiteId { get; set; }

        //public string mcs_mpiPid { get; set; }

        //public string mcs_vistaLocation { get; set; }

    }
}
