﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Vista.PipelineSteps.GetConsultsForPatient;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.Processor
{
    public class GetConsultsForPatientProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request"></param>
        /// <returns></returns>
        public IMessageBase Execute(GetConsultsForPatientRequest request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<GetConsultsForPatientStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsForPatientStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsForPatientStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsForPatientStateObject>, MapToGetConsultsRequestStep>("MapToGetConsultsRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsForPatientStateObject>, MapToProGetConsultsRequest>("MapToProGetConsultsRequest", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsForPatientStateObject>, SendPatientSideToEcStep>("SendPatientSideToEcStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsForPatientStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<GetConsultsForPatientStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new GetConsultsForPatientStateObject(request))
            {
                new Pipeline<GetConsultsForPatientStateObject>()
                    .Register(container.Resolve<FilterBase<GetConsultsForPatientStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsForPatientStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsForPatientStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsForPatientStateObject>>("MapToGetConsultsRequestStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsForPatientStateObject>>("MapToProGetConsultsRequest"))
                    .Register(container.Resolve<FilterBase<GetConsultsForPatientStateObject>>("SendPatientSideToEcStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsForPatientStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<GetConsultsForPatientStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.GetConsultsResponse;
            }
        }

    }
}
