﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.Vista.Processor;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.MakeAppointmentRequestMessage)]
    public class MakeAppointmentHandler : RequestResponseHandler
    {
        private MakeAppointmentRequestMessage _request;
        private string _serializedRequest;

        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                _request = (MakeAppointmentRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var processor = new MakeAppointmentProcessor();
                var response = (MakeAppointmentResponseMessage)processor.Execute(_request);

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);

                return response;
            } 
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        private MakeAppointmentResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: VideoVisit Create Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new MakeAppointmentResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}