﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.Vista.Processor;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.MessageHandler
{
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.GetConsultsRequestMessage)]
    public class GetConsultsHandler : RequestResponseHandler
    {
        private GetConsultsRequestMessage _request;
        private string _serializedRequest;

        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                _request = (GetConsultsRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var processor = new GetConsultsProcessor();
                var response = (GetConsultsResponseMessage)processor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: GetConsults: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);

                return response;
            } 
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        private GetConsultsResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: VideoVisit Create Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new GetConsultsResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}
