﻿using Microsoft.Xrm.Sdk;
using Microsoft.Xrm.Sdk.Query;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VA.TMP.OptionSets;
using VIMT.VIASchedulingService.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Vista.Mappers
{
    public class MakeAppointmentMapper
    {

        public VIMTVIASchdMakeApptmakeAppointmentRequest MapMakeAppointmentRequest(MakeAppointmentStateObject state, Side side)
        {
            var dateTime = state.ServiceAppointment.ScheduledStart.Value;
            //var facility = VistaMapperHelper.GetFacility(state, side);
            var apptReqInfo = new VIMTVIASchdMakeApptReqappointment
            {
                mcs_clinicId = GetClinicIen(state, side).ToString(),
                mcs_appointmentLength = state.ServiceAppointment.ScheduledDurationMinutes.ToString(),
                mcs_purpose = "4",
                mcs_timestamp = state.ServiceAppointment.ScheduledStart.Value.ToString("yyyyMMdd.HHmm"),
                mcs_appointmentType = "9"
            };

            return new VIMTVIASchdMakeApptmakeAppointmentRequest
            {
                UserId = state.UserId,
                OrganizationName = state.OrganizationName,
                VIMTVIASchdMakeApptReqappointmentInfo = apptReqInfo,
                VIMTVIASchdMakeApptReqqueryBeanInfo = VistaMapperHelper.GetQueryBean(state, side),
                Debug = true,
                LogSoap = true
            };
        }

        public string GetClinicIen(MakeAppointmentStateObject state, Side side)
        {
            using (var srv = new Xrm(state.OrganizationServiceProxy))
            {
                var bookedResources = state.ServiceAppointment.Resources.Where(r => r.PartyId.LogicalName == "equipment").ToList();
                if (state.CrmAppointment != null && state.CrmAppointment.RequiredAttendees != null)
                {
                        bookedResources.AddRange(state.CrmAppointment.RequiredAttendees.Where(r => r.PartyId.LogicalName == "equipment").ToList());
                }
                var clinicIen = string.Empty;
                foreach (var equipmentParty in bookedResources)
                {
                    var resource = srv.mcs_resourceSet.FirstOrDefault(r => r.mcs_relatedResourceId != null && r.mcs_relatedResourceId.Id == equipmentParty.PartyId.Id);
                    if (resource?.mcs_Type != null && resource.mcs_Type.Value == (int)mcs_resourcetype.VistaClinic)
                    {
                        //Ensure that the VistA Clinic retrieved is the one for the appropriate site, otherwise skip to the next one
                        if (side == Side.Patient)
                        {
                            if (state.ServiceAppointment.mcs_relatedsite != null)
                            {
                                if (state.ServiceAppointment.mcs_relatedsite.Id == resource.mcs_RelatedSiteId.Id)
                                    return resource.cvt_ien;
                                else
                                    Logger.Instance.Debug("Vista Clinic Site doesnt match Patient Site, looking for next Vista Clinic: " + resource.mcs_name);
                            }
                            else
                                throw new Exception("No Patient Site is listed");
                        }
                        else
                        {
                            if (state.ServiceAppointment.mcs_relatedprovidersite != null)
                            {
                                if (state.ServiceAppointment.mcs_relatedprovidersite.Id == resource.mcs_RelatedSiteId.Id)
                                    return resource.cvt_ien;
                                else
                                    Logger.Instance.Debug("Vista Clinic Site doesn't match Provider Site, looking for next Vista Clinic: " + resource.mcs_name);
                            }
                            else
                                throw new Exception("No Provider Site is listed");
                        }

                    }
                }
                throw new Exception(string.Format("No Valid Vista Clinics were found for the {0} side", side.ToString()));
            }
        }
    }

    public enum Side
    {
        Patient,
        Provider
    }

    public enum AppointmentType
    {
        HOME_MOBILE,
        STORE_FORWARD,
        GROUP,
        CLINIC_BASED
    }

    public class QueryBeanSecuritySettings
    {
        public string RequestingApp;
        public string ConsumingAppToken;
        public string ConsumingAppPassword;
    }
}
