﻿using Microsoft.Xrm.Sdk;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.DataModel;
using VIMT.VIASchedulingService.Messages;

namespace VA.TMP.Integration.VIMT.Vista.Mappers
{
    public class LoginMapper
    {
        public VIMTVIAScheLIloginVIARequest GetLoginRequest(Guid userId, string siteCode, IOrganizationService orgService)
        {
            var queryBeanSecuritySettings = VistaMapperHelper.GetSecuritySettings(orgService);
            return new VIMTVIAScheLIloginVIARequest
            {
                UserId = userId,
                mcs_sitecode = siteCode,
                mcs_accesscode = GetUserAccessCode(userId, siteCode, orgService),
                mcs_verifycode = GetUserVerifyCode(userId, siteCode, orgService),
                VIMTVIAScheLIReqqueryBeanInfo = new VIMTVIAScheLIReqqueryBean
                {
                    mcs_requestingApp = queryBeanSecuritySettings.RequestingApp,
                    mcs_consumingAppToken = queryBeanSecuritySettings.ConsumingAppToken,
                    mcs_consumingAppPassword = queryBeanSecuritySettings.ConsumingAppPassword
                },
                Debug = true,
                LogSoap = true
            };
        }

        // TO DO - build out new table to store access verify codes mapped to user/facility combos
        public string GetUserAccessCode(Guid userId, string siteCode, IOrganizationService orgService)
        {
            //Retrieve Access Code for a given site/user combo
            return siteCode;
        }

        public string GetUserVerifyCode(Guid userId, string siteCode, IOrganizationService orgService)
        {
            //Retrieve Verify Code for a given site/user combo
            return siteCode;
        }

        //public string[] GetUserVistaLogins(Guid userId, string siteCode, IOrganizationService orgService)
        //{
        //    Account securityRecord = null;
        //    //Retrieve Access Code for a given site/user combo
        //    using (var srv = new Xrm(orgService))
        //        securityRecord = srv.AccountSet.FirstOrDefault(c => c.cvt_userId == userId && c.cvt_siteCode == siteCode);
        //    if (securityRecord != null)
        //        return new {securityRecord.cvt_accessCode, securityRecord.cvt_verifyCode};
        //}
    }
}