﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Vista.StateObject;
using VIMT.VIAEMRService.Messages;
using VA.TMP.Integration.VIMT.Messages.Vista;
using VA.TMP.OptionSets;

namespace VA.TMP.Integration.VIMT.Vista.Mappers
{
    public class GetConsultsforPatientMapper
    {
        public VIMTVIAEMRgcfpgetConsultsForPatientRequest mapGetConsultRequest(GetConsultsForPatientStateObject state, Side side)
        {
            string _localPid = string.Empty;
            var _mpiPid = string.Empty;
            string _providername = string.Empty;
            var sitecode = side == Side.Patient ? state.GetConsultsRequest.PatLoginSiteCode : state.GetConsultsRequest.ProLoginSiteCode;

            using (var _service = new Xrm(state.OrganizationServiceProxy))
            {
                var provider = _service.SystemUserSet.FirstOrDefault(i => i.Id == state.GetConsultsRequest.ProviderIds.FirstOrDefault());
                if (provider == null) { throw new Exception("Vista Provider Name Could Not Be Retrieved from CRM: " + state.GetConsultsRequest.ProviderIds.FirstOrDefault()); }
                _providername = provider.FullName;

                //TODO - Error message is popping up wrong id (it is popping up provider id instead of patient ID - will lead to confusion)
                var _patientId = state.GetConsultsRequest.PatientIds.FirstOrDefault();
                var Icn = _service.mcs_personidentifiersSet.FirstOrDefault(i => i.mcs_patient.Id == _patientId && i.mcs_assigningauthority == "USVHA" && i.mcs_identifiertype.Value == (int)mcs_personidentifiersmcs_identifiertype.NationalIdentifier_NI);
                if (Icn == null) { throw new Exception("Icn Could Not Be Retrieved from CRM: " + state.GetConsultsRequest.ProviderIds.FirstOrDefault()); }
                _mpiPid = Icn.mcs_identifier;

                var patientIdentifier = _service.mcs_personidentifiersSet.FirstOrDefault(i => i.mcs_patient.Id == _patientId && i.mcs_assigningfacility == sitecode && i.mcs_identifiertype.Value == (int)mcs_personidentifiersmcs_identifiertype.ParticipantIdentifier_PI);
                if (patientIdentifier == null) { throw new Exception(string.Format("Vista - No patient identifier found for station code {0}{1}", sitecode, _patientId)); }
                _localPid = patientIdentifier.mcs_identifier;
            }

            return new VIMTVIAEMRgcfpgetConsultsForPatientRequest
            {
                OrganizationName=state.OrganizationName,
                VIMTVIAEMRgcfpReqqueryBeanInfo = new VIMTVIAEMRgcfpReqqueryBean
                {
                    mcs_requestingApp = state.OrganizationName,
                    mcs_status = state.mcs_status,
                    mcs_multiSiteQuery = false,
                    mcs_consumingAppToken = state.Via_AppToken,
                    mcs_consumingAppPassword = state.Via_AppPassword,
                    VIMTVIAEMRgcfpReqproviderInfo = new VIMTVIAEMRgcfpReqprovider
                    {
                        mcs_name = _providername,
                        mcs_loginSiteCode = sitecode
                    },
                    VIMTVIAEMRgcfpReqpatientInfo = new VIMTVIAEMRgcfpReqpatient
                    {
                        mcs_localPid = _localPid,
                        mcs_localSiteId = sitecode,
                        mcs_mpiPid = _mpiPid,
                        mcs_vistaLocations = sitecode
                    }
                }
            };
        }

        public GetConsultsForPatientRespTaggedConsultArrays MapEcToLob(VIMTVIAEMRgcfpgetConsultsForPatientResponse ecResponse)
        {
            if (ecResponse.VIMTVIAEMRgcfptaggedConsultArraysInfo == null) { throw new Exception("EcResponse does not contain data."); }
            var _arrPatientRespArraysInfo = ArrPatientRespArray(ecResponse);


            return new GetConsultsForPatientRespTaggedConsultArrays
            {
                Count = ecResponse.VIMTVIAEMRgcfptaggedConsultArraysInfo.mcs_count,
                CountSpecified = ecResponse.VIMTVIAEMRgcfptaggedConsultArraysInfo.mcs_countSpecified,
                GetConsultsForPatientRespArraysInfo = _arrPatientRespArraysInfo
            };
        }

        public GetConsultsForPatientRespArraysMultipleResponse[] ArrPatientRespArray(VIMTVIAEMRgcfpgetConsultsForPatientResponse ecResponse)
        {
            
            var _tempList = new List<GetConsultsForPatientRespArraysMultipleResponse>();

            foreach (var i in ecResponse.VIMTVIAEMRgcfptaggedConsultArraysInfo.VIMTVIAEMRgcfparraysInfo)
            {
                var _innerList = new List<GetConsultsForPatientRespConsultsMultipleResponse>();
                foreach(var j in i.VIMTVIAEMRgcfpconsultsInfo)
                {
                    var _locConsult = new GetConsultsForPatientRespConsultsMultipleResponse
                    {
                        Title = j.mcs_title,
                        RequestedProcedure = j.mcs_requestedProcedure,
                        ConsultIen = j.mcs_consultIen,
                        RequestDate = j.mcs_requestDate,
                        ServiceIen = j.mcs_serviceIen,
                        ServiceName = j.mcs_serviceName,
                        PatientDfn = j.mcs_patientDfn,
                        PatientName = j.mcs_patientName,
                        SendingProviderDuz = j.mcs_sendingProviderDuz,
                        SendingProviderName = j.mcs_sendingProviderName,
                        ProvisionalDiagnosis = j.mcs_provisionalDiagnosis,
                        Id = j.mcs_id,
                        Timestamp = j.mcs_timestamp,
                        OrderingServiceName = j.mcs_orderingServiceName,
                        TreatingSpecialty = j.mcs_treatingSpecialty,
                        StartDate = j.mcs_startDate,
                        StopDate = j.mcs_stopDate,
                        Status = j.mcs_status,
                        DateSigned = j.mcs_dateSigned,
                        VerifyingNurse = j.mcs_verifyingNurse,
                        VerifyingClerk = j.mcs_verifyingClerk,
                        DateVerified = j.mcs_dateVerified,
                        ChartReviewer = j.mcs_chartReviewer,
                        DateReviewed = j.mcs_dateReviewed,
                        Text = j.mcs_text,
                        Detail = j.mcs_detail,
                        ErrMsg = j.mcs_errMsg,
                        Flag = j.mcs_flag,
                        FlagSpecified = j.mcs_flagSpecified
                    };

                    _innerList.Add(_locConsult);
                }
                _tempList.Add(new GetConsultsForPatientRespArraysMultipleResponse
                {
                    Tag = i.mcs_tag,
                    Count = i.mcs_count,
                    CountSpecified = i.mcs_countSpecified,
                    GetConsultsForPatientRespConsultsInfo = _innerList.ToArray(),
                    GetConsultsForPatientRespFault23Info = new GetConsultsForPatientRespFault23
                    {
                        InnerMessage = i.VIMTVIAEMRgcfpfault23Info.mcs_innerMessage,
                        InnerStackTrace = i.VIMTVIAEMRgcfpfault23Info.mcs_innerStackTrace,
                        InnerType = i.VIMTVIAEMRgcfpfault23Info.mcs_innerType,
                        Message = i.VIMTVIAEMRgcfpfault23Info.mcs_message,
                        StackTrace = i.VIMTVIAEMRgcfpfault23Info.mcs_stackTrace,
                        Suggestion = i.VIMTVIAEMRgcfpfault23Info.mcs_suggestion,
                        Type = i.VIMTVIAEMRgcfpfault23Info.mcs_type
                    }


                });
            }
            return _tempList.ToArray();

        }
    }
}
