﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.OnDemand;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.Processor
{
    /// <summary>
    /// VMR On Demand Processor for VIMT.
    /// </summary>
    public class VmrOnDemandCreateProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">VmrOnDemandCreateRequestMessage.</param>
        /// <returns>VmrOnDemandCreateResponseMessage.</returns>
        public IMessageBase Execute(VmrOnDemandCreateRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, GetVodStep>("GetVodStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, SetMeetingRoomNameStep>("SetMeetingRoomNameStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, GeneratePinsStep>("GeneratePinsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, SetMiscDataStep>("SetMiscDataStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, SerializeVmrStep>("SerializeVmrStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, ValidateXmlStep>("ValidateXmlStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, CreateMeetingRoomeRequestStep>("CreateMeetingRoomeRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, CreateUrlsStep>("CreateUrlsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VmrOnDemandCreateStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new VmrOnDemandCreateStateObject(request))
            {
                new Pipeline<VmrOnDemandCreateStateObject>()
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("GetVodStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("SetMeetingRoomNameStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("GeneratePinsStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("SetMiscDataStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("SerializeVmrStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("ValidateXmlStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("CreateMeetingRoomeRequestStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("CreateUrlsStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<VmrOnDemandCreateStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.VmrOnDemandCreateResponseMessage;
            }
        }
    }
}