﻿using Microsoft.Practices.Unity;
using Microsoft.Practices.Unity.InterceptionExtension;
using VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.PipelineSteps.Delete;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.Processor
{
    /// <summary>
    /// Virtual Meeting Room Processor for VIMT.
    /// </summary>
    public class VirtualMeetingRoomDeleteProcessor
    {
        /// <summary>
        ///  Execute the pipeline steps.
        /// </summary>
        /// <param name="request">VirtualMeetingRoomDeleteRequestMessage.</param>
        /// <returns>VirtualMeetingRoomDeleteResponseMessage.</returns>
        public IMessageBase Execute(VirtualMeetingRoomDeleteRequestMessage request)
        {
            IUnityContainer container = new UnityContainer();
            container.AddNewExtension<Interception>();
            container
                .RegisterType<FilterBase<VirtualMeetingRoomDeleteStateObject>, StartProcessingStep>("StartProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomDeleteStateObject>, ConnectToCrmStep>("ConnectToCrmStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomDeleteStateObject>, GetIntegrationSettingsStep>("GetIntegrationSettingsStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomDeleteStateObject>, SerializeDeleteVmrStep>("SerializeDeleteVmrStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomDeleteStateObject>, ValidateDeleteXmlStep>("ValidateDeleteXmlStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomDeleteStateObject>, DeleteMeetingRoomRequestStep>("DeleteMeetingRoomRequestStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomDeleteStateObject>, CreateResponseStep>("CreateResponseStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>())
                .RegisterType<FilterBase<VirtualMeetingRoomDeleteStateObject>, StopProcessingStep>("StopProcessingStep", new Interceptor<VirtualMethodInterceptor>(), new InterceptionBehavior<Shared.Interceptor>());

            using (var state = new VirtualMeetingRoomDeleteStateObject(request))
            {
                new Pipeline<VirtualMeetingRoomDeleteStateObject>()
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomDeleteStateObject>>("StartProcessingStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomDeleteStateObject>>("ConnectToCrmStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomDeleteStateObject>>("GetIntegrationSettingsStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomDeleteStateObject>>("SerializeDeleteVmrStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomDeleteStateObject>>("ValidateDeleteXmlStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomDeleteStateObject>>("DeleteMeetingRoomRequestStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomDeleteStateObject>>("CreateResponseStep"))
                    .Register(container.Resolve<FilterBase<VirtualMeetingRoomDeleteStateObject>>("StopProcessingStep"))
                    .Execute(state);

                return state.VirtualMeetingRoomDeleteResponseMessage;
            }
        }
    }
}