﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.Messages.VirtualMeetingRoom;
using VA.TMP.Integration.VIMT.Shared;
using VA.TMP.Integration.VIMT.VirtualMeetingRoom.Processor;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VirtualMeetingRoom.MessageHandler
{
    /// <summary>
    /// VMR On Demand handler for VIMT.
    /// </summary>
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VmrOnDemandCreateRequestMessage)]
    public class VmrOnDemandCreateHandler : RequestResponseHandler
    {
        private VmrOnDemandCreateRequestMessage _request;
        private string _serializedRequest;

        /// <summary>
        /// Handle the VMR On Demand Request and send back a response.
        /// </summary>
        /// <param name="message">VmrOnDemandCreateRequestMessage.</param>
        /// <returns>VmrOnDemandCreateResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                _request = (VmrOnDemandCreateRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var requestProcessor = new VmrOnDemandCreateProcessor();
                var response = (VmrOnDemandCreateResponseMessage)requestProcessor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: Virtual Meeting Room Create: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);

                return response;
            }
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        /// <summary>
        /// Log and create an error response.
        /// </summary>
        /// <param name="exception">Exception.</param>
        /// <returns>VmrOnDemandCreateResponseMessage.</returns>
        private VmrOnDemandCreateResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: VMR On Demand Create Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new VmrOnDemandCreateResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}