﻿using Microsoft.Xrm.Sdk.Client;
using System;
using System.Collections.Generic;
using VA.TMP.DataModel;
using VA.TMP.Integration.VIMT.Messages.VideoVisit;
using VIMT.VideoVisit.Messages;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.StateObject
{
    /// <summary>
    /// Class used to hold state between VIMT pipeline steps.
    /// </summary>
    public class VideoVisitCreateStateObject : PipeState
    {
        /// <summary>
        /// Default constructor.
        /// </summary>
        /// <param name="videoVisitCreateRequestMessage">VideoVisitCreateRequestMessage instance.</param>
        public VideoVisitCreateStateObject(VideoVisitCreateRequestMessage videoVisitCreateRequestMessage)
        {
            OrganizationName = videoVisitCreateRequestMessage.OrganizationName;
            UserId = videoVisitCreateRequestMessage.UserId;
            LogRequest = videoVisitCreateRequestMessage.LogRequest;
            AppointmentId = videoVisitCreateRequestMessage.AppointmentId;
            SystemUsers = new List<SystemUser>();
            ContactIds = new List<Guid>();
            ContactIds.AddRange(videoVisitCreateRequestMessage.AddedPatients);
        }

        /// <summary>
        /// Gets or sets the CRM organization name.
        /// </summary>
        public string OrganizationName { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        public Guid UserId { get; set; }

        /// <summary>
        /// Gets or sets whether to log the request.
        /// </summary>
        public bool LogRequest { get; set; }

        /// <summary>
        /// Get or set the CRM Organization Service Proxy.
        /// </summary>
        public OrganizationServiceProxy OrganizationServiceProxy { get; set; }

        /// <summary>
        /// Gets or sets the UserId.
        /// </summary>
        public Guid AppointmentId { get; set; }

        /// <summary>
        /// Gets or sets whether to use a fake response.
        /// </summary>
        public string VistaFakeResponseType { get; set; }

        /// <summary>
        /// Get or set the Service Appointment.
        /// </summary>
        public ServiceAppointment ServiceAppointment { get; set; }

        /// <summary>
        /// Get or set the Service Appointment.
        /// </summary>
        public Appointment CrmAppointment { get; set; }

        /// <summary>
        /// Get or set the Service Appointment.
        /// </summary>
        public List<Guid> ContactIds { get; set; }

        /// <summary>
        /// Get or set the Service Appointment.
        /// </summary>
        public List<SystemUser> SystemUsers { get; set; }

        /// <summary>
        /// Gets or sets an Appointment.
        /// </summary>
        public VIMTTmpCreateAppointmentRequestData Appointment { get; set; }

        /// <summary>
        /// Gets or sets a serialized Appointment.
        /// </summary>
        public string SerializedAppointment { get; set; }

        /// <summary>
        /// Gets or Sets whether an exception occured.
        /// </summary>
        public bool ExceptionOccured { get; set; }

        /// <summary>
        /// Gets or Sets the exception message.
        /// </summary>
        public string ExceptionMessage { get; set; }
        
        /// <summary>
        /// Gets or sets the Video Visit Response Message.
        /// </summary>
        public VideoVisitCreateResponseMessage VideoVisitCreateResponseMessage { get; set; }

        public VIMTTmpCreateAppointmentResponse EcResponse { get; set; }

    }
}