﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.VideoVisit.Processor;
using VA.TMP.Integration.VIMT.Messages.VideoVisit;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.MessageHandler
{
    /// <summary>
    /// Video Visit handler for VIMT.
    /// </summary>
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.VideoVisitDeleteRequestMessage)]
    public class VideoVisitDeleteHandler : RequestResponseHandler
    {
        private VideoVisitDeleteRequestMessage _request;
        private string _serializedRequest;

        /// <summary>
        /// Handle the Video Visit Request and send back a response.
        /// </summary>
        /// <param name="message">VideoVisitDeleteRequestMessage.</param>
        /// <returns>VideoVisitDeleteResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                _request = (VideoVisitDeleteRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var requestProcessor = new VideoVisitDeleteProcessor();
                var response = (VideoVisitDeleteResponseMessage)requestProcessor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: Video Visit Delete: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);

                return response;
            }
            catch (Exception ex)
            {
                return LogAndDeleteResponseMessage(ex);
            }
        }

        /// <summary>
        /// Log and Delete an error response.
        /// </summary>
        /// <param name="exception">Exception.</param>
        /// <returns>VideoVisitDeleteResponseMessage.</returns>
        private VideoVisitDeleteResponseMessage LogAndDeleteResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: VideoVisit Delete Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new VideoVisitDeleteResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}