﻿using System;
using System.ComponentModel.Composition;
using VA.TMP.Integration.VIMT.Messages.Mvi;
using VA.TMP.Integration.VIMT.Mvi.Processor;
using VA.TMP.Integration.VIMT.Shared;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Mvi.MessageHandler
{
    /// <summary>
    /// Person Search handler for VIMT.
    /// </summary>
    [Export(typeof(IMessageHandler))]
    [ExportMetadata("MessageType", MessageRegistry.PersonSearchRequestMessage)]
    public class PersonSearchHandler : RequestResponseHandler
    {
        private PersonSearchRequestMessage _request;
        private string _serializedRequest;

        /// <summary>
        /// Handle the Person Search Request and send back a response.
        /// </summary>
        /// <param name="message">PersonSearchRequestMessage.</param>
        /// <returns>PersonSearchResponseMessage.</returns>
        public override IMessageBase HandleRequestResponse(object message)
        {
            try
            {
                _request = (PersonSearchRequestMessage)message;
                _serializedRequest = PipelineUtilities.SerializeInstance(_request);

                var requestProcessor = new PersonSearchProcessor();
                var response = (PersonSearchResponseMessage)requestProcessor.Execute(_request);

                if (response.ExceptionOccured) Logger.Instance.Error(string.Format("ERROR: MVI Person Search: {0}", response.ExceptionMessage));

                response.VimtRequest = _serializedRequest;
                response.VimtResponse = PipelineUtilities.SerializeInstance(response);

                return response;
            }
            catch (Exception ex)
            {
                return LogAndCreateResponseMessage(ex);
            }
        }

        /// <summary>
        /// Log and create an error response.
        /// </summary>
        /// <param name="exception">Exception.</param>
        /// <returns>PersonSearchResponseMessage.</returns>
        private PersonSearchResponseMessage LogAndCreateResponseMessage(Exception exception)
        {
            Logger.Instance.Error("ERROR: MVI Person Search Handler Exception", exception);

            var exceptionMessage = exception.Message;
            exceptionMessage += PipelineUtilities.BuildErrorMessage(exception);

            return new PersonSearchResponseMessage
            {
                ExceptionOccured = true,
                ExceptionMessage = exceptionMessage,
                VimtRequest = _serializedRequest
            };
        }
    }
}