using System.ComponentModel.Composition;
using System.Runtime.Serialization;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.Messages.Vista
{
    [Export(typeof(IMessageBase))]
	[ExportMetadata("MessageType", MessageRegistry.MakeAppointmentResponseMessage)]
	[DataContract]
	public class MakeAppointmentResponseMessage : MessageBase
	{
		[DataMember]
		public MakeApptRespAppointmentTo MakeApptRespAppointmentToInfo { get; set; }
		[DataMember]
		public bool ExceptionOccured { get; set; }
		[DataMember]
		public string ExceptionMessage { get; set; }
        [DataMember]
        public string SerializedInstance { get; set; }
        [DataMember]
        public string VimtRequest { get; set; }
        [DataMember]
        public string VimtResponse { get; set; }
        //[DataMember]
        //public List<VIASchdMakeApptmakeAppointmentResponse> Responses { get; set; }
    }

	[DataContract]
	public class MakeApptRespAppointmentTo
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Timestamp { get; set; }
		[DataMember]
		public string Title { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string LabDateTime { get; set; }
		[DataMember]
		public string XrayDateTime { get; set; }
		[DataMember]
		public string EkgDateTime { get; set; }
		[DataMember]
		public string Purpose { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string CurrentStatus { get; set; }
		[DataMember]
		public string ClinicId { get; set; }
		[DataMember]
		public string PurposeSubcategory { get; set; }
		[DataMember]
		public string AppointmentLength { get; set; }
		[DataMember]
		public string AappointmentType { get; set; }
		[DataMember]
		public string BookNotes { get; set; }
		[DataMember]
		public string ConsultIen { get; set; }
		[DataMember]
		public string Lvl { get; set; }
		[DataMember]
		public string DesiredDateTime { get; set; }
		[DataMember]
		public string VisitId { get; set; }
		[DataMember]
		public string ProviderName { get; set; }
		[DataMember]
		public MakeApptRespFacility MakeApptRespFacilityInfo { get; set; }
		[DataMember]
		public MakeApptRespClinic MakeApptRespClinicInfo { get; set; }
		[DataMember]
		public MakeApptRespFault17 MakeApptRespFault17Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespFacility
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public MakeApptRespTaggedResultsMultipleResponse[] MakeApptRespTaggedResultsInfo { get; set; }
		[DataMember]
		public MakeApptRespFault MakeApptRespFaultInfo { get; set; }
	}

	[DataContract]
	public class MakeApptRespTaggedResultsMultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class MakeApptRespFault
	{
		[DataMember]
		public string InnerMessage { get; set; }
		[DataMember]
		public string InnerStackTrace { get; set; }
		[DataMember]
		public string InnerType { get; set; }
		[DataMember]
		public string Message { get; set; }
		[DataMember]
		public string StackTrace { get; set; }
		[DataMember]
		public string Suggestion { get; set; }
		[DataMember]
		public string Type { get; set; }
	}

	[DataContract]
	public class MakeApptRespClinic
	{
		[DataMember]
		public string Id { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string Building { get; set; }
		[DataMember]
		public string Floor { get; set; }
		[DataMember]
		public string Room { get; set; }
		[DataMember]
		public string Bed { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Phone { get; set; }
		[DataMember]
		public string AppointmentTimestamp { get; set; }
		[DataMember]
		public string Type { get; set; }
		[DataMember]
		public string PhysicalLocation { get; set; }
		[DataMember]
		public bool AskForCheckIn { get; set; }
		[DataMember]
		public bool AskForCheckInSpecified { get; set; }
		[DataMember]
		public string AppointmentLength { get; set; }
		[DataMember]
		public string ClinicDisplayStartTime { get; set; }
		[DataMember]
		public string DisplayIncrements { get; set; }
		[DataMember]
		public string MaxOverbooksPerDay { get; set; }
		[DataMember]
		public string ProhibitAccessToClinic { get; set; }
		[DataMember]
		public MakeApptRespDepartment MakeApptRespDepartmentInfo { get; set; }
		[DataMember]
		public MakeApptRespService MakeApptRespServiceInfo { get; set; }
		[DataMember]
		public MakeApptRespSpecialty MakeApptRespSpecialtyInfo { get; set; }
		[DataMember]
		public MakeApptRespStopCode MakeApptRespStopCodeInfo { get; set; }
		[DataMember]
		public MakeApptRespCreditStopCode MakeApptRespCreditStopCodeInfo { get; set; }
		[DataMember]
		public MakeApptRespFacility1 MakeApptRespFacility1Info { get; set; }
		[DataMember]
		public MakeApptRespAvailability MakeApptRespAvailabilityInfo { get; set; }
		[DataMember]
		public MakeApptRespFault16 MakeApptRespFault16Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespDepartment
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public MakeApptRespTaggedResults1MultipleResponse[] MakeApptRespTaggedResults1Info { get; set; }
		[DataMember]
		public MakeApptRespFault1 MakeApptRespFault1Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespTaggedResults1MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class MakeApptRespFault1
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespService
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public MakeApptRespTaggedResults2MultipleResponse[] MakeApptRespTaggedResults2Info { get; set; }
		[DataMember]
		public MakeApptRespFault2 MakeApptRespFault2Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespTaggedResults2MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class MakeApptRespFault2
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespSpecialty
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public MakeApptRespTaggedResults3MultipleResponse[] MakeApptRespTaggedResults3Info { get; set; }
		[DataMember]
		public MakeApptRespFault3 MakeApptRespFault3Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespTaggedResults3MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class MakeApptRespFault3
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespStopCode
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public MakeApptRespTaggedResults4MultipleResponse[] MakeApptRespTaggedResults4Info { get; set; }
		[DataMember]
		public MakeApptRespFault4 MakeApptRespFault4Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespTaggedResults4MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class MakeApptRespFault4
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespCreditStopCode
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public MakeApptRespTaggedResults5MultipleResponse[] MakeApptRespTaggedResults5Info { get; set; }
		[DataMember]
		public MakeApptRespFault5 MakeApptRespFault5Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespTaggedResults5MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class MakeApptRespFault5
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespFacility1
	{
		[DataMember]
		public string Sitecode { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string DisplayName { get; set; }
		[DataMember]
		public string Moniker { get; set; }
		[DataMember]
		public string RegionId { get; set; }
		[DataMember]
		public string LastEventTimestamp { get; set; }
		[DataMember]
		public string LastEventReason { get; set; }
		[DataMember]
		public string Uid { get; set; }
		[DataMember]
		public string Pid { get; set; }
		[DataMember]
		public string ParentSiteId { get; set; }
		[DataMember]
		public string Address { get; set; }
		[DataMember]
		public string City { get; set; }
		[DataMember]
		public string State { get; set; }
		[DataMember]
		public string SystemName { get; set; }
		[DataMember]
		public string SiteType { get; set; }
		[DataMember]
		public MakeApptRespDataSources MakeApptRespDataSourcesInfo { get; set; }
		[DataMember]
		public MakeApptRespChildSites MakeApptRespChildSitesInfo { get; set; }
		[DataMember]
		public MakeApptRespFault13 MakeApptRespFault13Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespDataSources
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public MakeApptRespItemsMultipleResponse[] MakeApptRespItemsInfo { get; set; }
		[DataMember]
		public MakeApptRespFault8 MakeApptRespFault8Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespItemsMultipleResponse
	{
		[DataMember]
		public string Protocol { get; set; }
		[DataMember]
		public string Modality { get; set; }
		[DataMember]
		public int Timeout { get; set; }
		[DataMember]
		public int Port { get; set; }
		[DataMember]
		public string Provider { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Description { get; set; }
		[DataMember]
		public string Context { get; set; }
		[DataMember]
		public bool TestSource { get; set; }
		[DataMember]
		public string Vendor { get; set; }
		[DataMember]
		public string Version { get; set; }
		[DataMember]
		public string WelcomeMessage { get; set; }
		[DataMember]
		public MakeApptRespSiteId MakeApptRespSiteIdInfo { get; set; }
		[DataMember]
		public MakeApptRespFault7 MakeApptRespFault7Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespSiteId
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public MakeApptRespTaggedResults6MultipleResponse[] MakeApptRespTaggedResults6Info { get; set; }
		[DataMember]
		public MakeApptRespFault6 MakeApptRespFault6Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespTaggedResults6MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class MakeApptRespFault6
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespFault7
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespFault8
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespChildSites
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public MakeApptRespSitesMultipleResponse[] MakeApptRespSitesInfo { get; set; }
		[DataMember]
		public MakeApptRespFault12 MakeApptRespFault12Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespSitesMultipleResponse
	{
		[DataMember]
		public string Sitecode { get; set; }
		[DataMember]
		public string Name { get; set; }
		[DataMember]
		public string DisplayName { get; set; }
		[DataMember]
		public string Moniker { get; set; }
		[DataMember]
		public string RegionId { get; set; }
		[DataMember]
		public string LastEventTimestamp { get; set; }
		[DataMember]
		public string LastEventReason { get; set; }
		[DataMember]
		public string Uid { get; set; }
		[DataMember]
		public string Pid { get; set; }
		[DataMember]
		public string ParentSiteId { get; set; }
		[DataMember]
		public string Address { get; set; }
		[DataMember]
		public string City { get; set; }
		[DataMember]
		public string State { get; set; }
		[DataMember]
		public string SystemName { get; set; }
		[DataMember]
		public string SiteType { get; set; }
		[DataMember]
		public MakeApptRespDataSources1 MakeApptRespDataSources1Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespDataSources1
	{
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public MakeApptRespItems1MultipleResponse[] MakeApptRespItems1Info { get; set; }
		[DataMember]
		public MakeApptRespFault11 MakeApptRespFault11Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespItems1MultipleResponse
	{
		[DataMember]
		public string Protocol { get; set; }
		[DataMember]
		public string Modality { get; set; }
		[DataMember]
		public int Timeout { get; set; }
		[DataMember]
		public int Port { get; set; }
		[DataMember]
		public string Provider { get; set; }
		[DataMember]
		public string Status { get; set; }
		[DataMember]
		public string Description { get; set; }
		[DataMember]
		public string Context { get; set; }
		[DataMember]
		public bool TestSource { get; set; }
		[DataMember]
		public string Vendor { get; set; }
		[DataMember]
		public string Version { get; set; }
		[DataMember]
		public string WelcomeMessage { get; set; }
		[DataMember]
		public MakeApptRespSiteId1 MakeApptRespSiteId1Info { get; set; }
		[DataMember]
		public MakeApptRespFault10 MakeApptRespFault10Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespSiteId1
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
		[DataMember]
		public MakeApptRespTaggedResults7MultipleResponse[] MakeApptRespTaggedResults7Info { get; set; }
		[DataMember]
		public MakeApptRespFault9 MakeApptRespFault9Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespTaggedResults7MultipleResponse
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public string[] TextArray { get; set; }
	}

	[DataContract]
	public class MakeApptRespFault9
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespFault10
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespFault11
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespFault12
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespFault13
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespAvailability
	{
		[DataMember]
		public string Tag { get; set; }
		[DataMember]
		public int Count { get; set; }
		[DataMember]
		public bool CountSpecified { get; set; }
		[DataMember]
		public MakeApptRespSlotsMultipleResponse[] MakeApptRespSlotsInfo { get; set; }
		[DataMember]
		public MakeApptRespFault15 MakeApptRespFault15Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespSlotsMultipleResponse
	{
		[DataMember]
		public string Start { get; set; }
		[DataMember]
		public string End { get; set; }
		[DataMember]
		public string Text { get; set; }
		[DataMember]
		public bool Available { get; set; }
		[DataMember]
		public MakeApptRespFault14 MakeApptRespFault14Info { get; set; }
	}

	[DataContract]
	public class MakeApptRespFault14
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespFault15
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespFault16
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }

	[DataContract]
	public class MakeApptRespFault17
	{
        [DataMember]
        public string InnerMessage { get; set; }
        [DataMember]
        public string InnerStackTrace { get; set; }
        [DataMember]
        public string InnerType { get; set; }
        [DataMember]
        public string Message { get; set; }
        [DataMember]
        public string StackTrace { get; set; }
        [DataMember]
        public string Suggestion { get; set; }
        [DataMember]
        public string Type { get; set; }
    }
}